/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.transform;

import java.time.Instant;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SecretVersionsListEntry} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SecretVersionsListEntryMarshaller {
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").isBinary(false).build();

    private static final MarshallingInfo<List> VERSIONSTAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionStages").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTACCESSEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessedDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").isBinary(false).build();

    private static final SecretVersionsListEntryMarshaller INSTANCE = new SecretVersionsListEntryMarshaller();

    private SecretVersionsListEntryMarshaller() {
    }

    public static SecretVersionsListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SecretVersionsListEntry secretVersionsListEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(secretVersionsListEntry, "secretVersionsListEntry");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(secretVersionsListEntry.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall(secretVersionsListEntry.versionStages(), VERSIONSTAGES_BINDING);
            protocolMarshaller.marshall(secretVersionsListEntry.lastAccessedDate(), LASTACCESSEDDATE_BINDING);
            protocolMarshaller.marshall(secretVersionsListEntry.createdDate(), CREATEDDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
