/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSecretRequest
extends SecretsManagerRequest
implements ToCopyableBuilder<Builder, UpdateSecretRequest> {
    private final String secretId;
    private final String clientRequestToken;
    private final String description;
    private final String kmsKeyId;
    private final ByteBuffer secretBinary;
    private final String secretString;

    private UpdateSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.clientRequestToken = builder.clientRequestToken;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.secretBinary = builder.secretBinary;
        this.secretString = builder.secretString;
    }

    public String secretId() {
        return this.secretId;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String description() {
        return this.description;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public ByteBuffer secretBinary() {
        return this.secretBinary == null ? null : this.secretBinary.asReadOnlyBuffer();
    }

    public String secretString() {
        return this.secretString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretBinary());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecretRequest)) {
            return false;
        }
        UpdateSecretRequest other = (UpdateSecretRequest)((Object)obj);
        return Objects.equals(this.secretId(), other.secretId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.secretBinary(), other.secretBinary()) && Objects.equals(this.secretString(), other.secretString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSecretRequest").add("SecretId", (Object)this.secretId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Description", (Object)this.description()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SecretBinary", (Object)this.secretBinary()).add("SecretString", (Object)this.secretString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretId": {
                return Optional.of(clazz.cast(this.secretId()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "SecretBinary": {
                return Optional.of(clazz.cast(this.secretBinary()));
            }
            case "SecretString": {
                return Optional.of(clazz.cast(this.secretString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerRequest.BuilderImpl
    implements Builder {
        private String secretId;
        private String clientRequestToken;
        private String description;
        private String kmsKeyId;
        private ByteBuffer secretBinary;
        private String secretString;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecretRequest model) {
            super(model);
            this.secretId(model.secretId);
            this.clientRequestToken(model.clientRequestToken);
            this.description(model.description);
            this.kmsKeyId(model.kmsKeyId);
            this.secretBinary(model.secretBinary);
            this.secretString(model.secretString);
        }

        public final String getSecretId() {
            return this.secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final ByteBuffer getSecretBinary() {
            return this.secretBinary;
        }

        @Override
        public final Builder secretBinary(ByteBuffer secretBinary) {
            this.secretBinary = StandardMemberCopier.copy((ByteBuffer)secretBinary);
            return this;
        }

        public final void setSecretBinary(ByteBuffer secretBinary) {
            this.secretBinary = StandardMemberCopier.copy((ByteBuffer)secretBinary);
        }

        public final String getSecretString() {
            return this.secretString;
        }

        @Override
        public final Builder secretString(String secretString) {
            this.secretString = secretString;
            return this;
        }

        public final void setSecretString(String secretString) {
            this.secretString = secretString;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecretRequest build() {
            return new UpdateSecretRequest(this);
        }
    }

    public static interface Builder
    extends SecretsManagerRequest.Builder,
    CopyableBuilder<Builder, UpdateSecretRequest> {
        public Builder secretId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder description(String var1);

        public Builder kmsKeyId(String var1);

        public Builder secretBinary(ByteBuffer var1);

        public Builder secretString(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

