/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RestoreSecretRequestModelMarshaller {
    private static final MarshallingInfo<String> SECRETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretId").isBinary(false).build();
    private static final RestoreSecretRequestModelMarshaller INSTANCE = new RestoreSecretRequestModelMarshaller();

    private RestoreSecretRequestModelMarshaller() {
    }

    public static RestoreSecretRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RestoreSecretRequest restoreSecretRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)restoreSecretRequest), (String)"restoreSecretRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)restoreSecretRequest.secretId(), SECRETID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

