/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateSecretRequestModelMarshaller {
    private static final MarshallingInfo<String> SECRETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> SECRETBINARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretBinary").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretString").isBinary(false).build();
    private static final UpdateSecretRequestModelMarshaller INSTANCE = new UpdateSecretRequestModelMarshaller();

    private UpdateSecretRequestModelMarshaller() {
    }

    public static UpdateSecretRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateSecretRequest updateSecretRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateSecretRequest), (String)"updateSecretRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateSecretRequest.secretId(), SECRETID_BINDING);
            protocolMarshaller.marshall((Object)updateSecretRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)updateSecretRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)updateSecretRequest.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)updateSecretRequest.secretBinary(), SECRETBINARY_BINDING);
            protocolMarshaller.marshall((Object)updateSecretRequest.secretString(), SECRETSTRING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

