/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRandomPasswordRequest
extends SecretsManagerRequest
implements ToCopyableBuilder<Builder, GetRandomPasswordRequest> {
    private final Long passwordLength;
    private final String excludeCharacters;
    private final Boolean excludeNumbers;
    private final Boolean excludePunctuation;
    private final Boolean excludeUppercase;
    private final Boolean excludeLowercase;
    private final Boolean includeSpace;
    private final Boolean requireEachIncludedType;

    private GetRandomPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.passwordLength = builder.passwordLength;
        this.excludeCharacters = builder.excludeCharacters;
        this.excludeNumbers = builder.excludeNumbers;
        this.excludePunctuation = builder.excludePunctuation;
        this.excludeUppercase = builder.excludeUppercase;
        this.excludeLowercase = builder.excludeLowercase;
        this.includeSpace = builder.includeSpace;
        this.requireEachIncludedType = builder.requireEachIncludedType;
    }

    public Long passwordLength() {
        return this.passwordLength;
    }

    public String excludeCharacters() {
        return this.excludeCharacters;
    }

    public Boolean excludeNumbers() {
        return this.excludeNumbers;
    }

    public Boolean excludePunctuation() {
        return this.excludePunctuation;
    }

    public Boolean excludeUppercase() {
        return this.excludeUppercase;
    }

    public Boolean excludeLowercase() {
        return this.excludeLowercase;
    }

    public Boolean includeSpace() {
        return this.includeSpace;
    }

    public Boolean requireEachIncludedType() {
        return this.requireEachIncludedType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludePunctuation());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeUppercase());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeLowercase());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeSpace());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireEachIncludedType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRandomPasswordRequest)) {
            return false;
        }
        GetRandomPasswordRequest other = (GetRandomPasswordRequest)((Object)obj);
        return Objects.equals(this.passwordLength(), other.passwordLength()) && Objects.equals(this.excludeCharacters(), other.excludeCharacters()) && Objects.equals(this.excludeNumbers(), other.excludeNumbers()) && Objects.equals(this.excludePunctuation(), other.excludePunctuation()) && Objects.equals(this.excludeUppercase(), other.excludeUppercase()) && Objects.equals(this.excludeLowercase(), other.excludeLowercase()) && Objects.equals(this.includeSpace(), other.includeSpace()) && Objects.equals(this.requireEachIncludedType(), other.requireEachIncludedType());
    }

    public String toString() {
        return ToString.builder((String)"GetRandomPasswordRequest").add("PasswordLength", (Object)this.passwordLength()).add("ExcludeCharacters", (Object)this.excludeCharacters()).add("ExcludeNumbers", (Object)this.excludeNumbers()).add("ExcludePunctuation", (Object)this.excludePunctuation()).add("ExcludeUppercase", (Object)this.excludeUppercase()).add("ExcludeLowercase", (Object)this.excludeLowercase()).add("IncludeSpace", (Object)this.includeSpace()).add("RequireEachIncludedType", (Object)this.requireEachIncludedType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PasswordLength": {
                return Optional.ofNullable(clazz.cast(this.passwordLength()));
            }
            case "ExcludeCharacters": {
                return Optional.ofNullable(clazz.cast(this.excludeCharacters()));
            }
            case "ExcludeNumbers": {
                return Optional.ofNullable(clazz.cast(this.excludeNumbers()));
            }
            case "ExcludePunctuation": {
                return Optional.ofNullable(clazz.cast(this.excludePunctuation()));
            }
            case "ExcludeUppercase": {
                return Optional.ofNullable(clazz.cast(this.excludeUppercase()));
            }
            case "ExcludeLowercase": {
                return Optional.ofNullable(clazz.cast(this.excludeLowercase()));
            }
            case "IncludeSpace": {
                return Optional.ofNullable(clazz.cast(this.includeSpace()));
            }
            case "RequireEachIncludedType": {
                return Optional.ofNullable(clazz.cast(this.requireEachIncludedType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerRequest.BuilderImpl
    implements Builder {
        private Long passwordLength;
        private String excludeCharacters;
        private Boolean excludeNumbers;
        private Boolean excludePunctuation;
        private Boolean excludeUppercase;
        private Boolean excludeLowercase;
        private Boolean includeSpace;
        private Boolean requireEachIncludedType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRandomPasswordRequest model) {
            super(model);
            this.passwordLength(model.passwordLength);
            this.excludeCharacters(model.excludeCharacters);
            this.excludeNumbers(model.excludeNumbers);
            this.excludePunctuation(model.excludePunctuation);
            this.excludeUppercase(model.excludeUppercase);
            this.excludeLowercase(model.excludeLowercase);
            this.includeSpace(model.includeSpace);
            this.requireEachIncludedType(model.requireEachIncludedType);
        }

        public final Long getPasswordLength() {
            return this.passwordLength;
        }

        @Override
        public final Builder passwordLength(Long passwordLength) {
            this.passwordLength = passwordLength;
            return this;
        }

        public final void setPasswordLength(Long passwordLength) {
            this.passwordLength = passwordLength;
        }

        public final String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        public final Builder excludeCharacters(String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        public final void setExcludeCharacters(String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
        }

        public final Boolean getExcludeNumbers() {
            return this.excludeNumbers;
        }

        @Override
        public final Builder excludeNumbers(Boolean excludeNumbers) {
            this.excludeNumbers = excludeNumbers;
            return this;
        }

        public final void setExcludeNumbers(Boolean excludeNumbers) {
            this.excludeNumbers = excludeNumbers;
        }

        public final Boolean getExcludePunctuation() {
            return this.excludePunctuation;
        }

        @Override
        public final Builder excludePunctuation(Boolean excludePunctuation) {
            this.excludePunctuation = excludePunctuation;
            return this;
        }

        public final void setExcludePunctuation(Boolean excludePunctuation) {
            this.excludePunctuation = excludePunctuation;
        }

        public final Boolean getExcludeUppercase() {
            return this.excludeUppercase;
        }

        @Override
        public final Builder excludeUppercase(Boolean excludeUppercase) {
            this.excludeUppercase = excludeUppercase;
            return this;
        }

        public final void setExcludeUppercase(Boolean excludeUppercase) {
            this.excludeUppercase = excludeUppercase;
        }

        public final Boolean getExcludeLowercase() {
            return this.excludeLowercase;
        }

        @Override
        public final Builder excludeLowercase(Boolean excludeLowercase) {
            this.excludeLowercase = excludeLowercase;
            return this;
        }

        public final void setExcludeLowercase(Boolean excludeLowercase) {
            this.excludeLowercase = excludeLowercase;
        }

        public final Boolean getIncludeSpace() {
            return this.includeSpace;
        }

        @Override
        public final Builder includeSpace(Boolean includeSpace) {
            this.includeSpace = includeSpace;
            return this;
        }

        public final void setIncludeSpace(Boolean includeSpace) {
            this.includeSpace = includeSpace;
        }

        public final Boolean getRequireEachIncludedType() {
            return this.requireEachIncludedType;
        }

        @Override
        public final Builder requireEachIncludedType(Boolean requireEachIncludedType) {
            this.requireEachIncludedType = requireEachIncludedType;
            return this;
        }

        public final void setRequireEachIncludedType(Boolean requireEachIncludedType) {
            this.requireEachIncludedType = requireEachIncludedType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRandomPasswordRequest build() {
            return new GetRandomPasswordRequest(this);
        }
    }

    public static interface Builder
    extends SecretsManagerRequest.Builder,
    CopyableBuilder<Builder, GetRandomPasswordRequest> {
        public Builder passwordLength(Long var1);

        public Builder excludeCharacters(String var1);

        public Builder excludeNumbers(Boolean var1);

        public Builder excludePunctuation(Boolean var1);

        public Builder excludeUppercase(Boolean var1);

        public Builder excludeLowercase(Boolean var1);

        public Builder includeSpace(Boolean var1);

        public Builder requireEachIncludedType(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

