/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetSecretValueRequestModelMarshaller {
    private static final MarshallingInfo<String> SECRETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretId").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONSTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionStage").isBinary(false).build();
    private static final GetSecretValueRequestModelMarshaller INSTANCE = new GetSecretValueRequestModelMarshaller();

    private GetSecretValueRequestModelMarshaller() {
    }

    public static GetSecretValueRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetSecretValueRequest getSecretValueRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getSecretValueRequest), (String)"getSecretValueRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getSecretValueRequest.secretId(), SECRETID_BINDING);
            protocolMarshaller.marshall((Object)getSecretValueRequest.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)getSecretValueRequest.versionStage(), VERSIONSTAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

