/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSecretRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<DeleteSecretRequest.Builder, DeleteSecretRequest> {
    private final String secretId;

    private final Long recoveryWindowInDays;

    private final Boolean forceDeleteWithoutRecovery;

    private DeleteSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.recoveryWindowInDays = builder.recoveryWindowInDays;
        this.forceDeleteWithoutRecovery = builder.forceDeleteWithoutRecovery;
    }

    /**
     * <p>
     * Specifies the secret that you want to delete. You can specify either the Amazon Resource Name (ARN) or the
     * friendly name of the secret.
     * </p>
     * 
     * @return Specifies the secret that you want to delete. You can specify either the Amazon Resource Name (ARN) or
     *         the friendly name of the secret.
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * (Optional) Specifies the number of days that Secrets Manager waits before it can delete the secret. You can't use
     * both this parameter and the <code>ForceDeleteWithoutRecovery</code> parameter in the same API call.
     * </p>
     * <p>
     * This value can range from 7 to 30 days. The default value is 30.
     * </p>
     * 
     * @return (Optional) Specifies the number of days that Secrets Manager waits before it can delete the secret. You
     *         can't use both this parameter and the <code>ForceDeleteWithoutRecovery</code> parameter in the same API
     *         call.</p>
     *         <p>
     *         This value can range from 7 to 30 days. The default value is 30.
     */
    public Long recoveryWindowInDays() {
        return recoveryWindowInDays;
    }

    /**
     * <p>
     * (Optional) Specifies that the secret is to be deleted without any recovery window. You can't use both this
     * parameter and the <code>RecoveryWindowInDays</code> parameter in the same API call.
     * </p>
     * <p>
     * An asynchronous background process performs the actual deletion, so there can be a short delay before the
     * operation completes. If you write code to delete and then immediately recreate a secret with the same name,
     * ensure that your code includes appropriate back off and retry logic.
     * </p>
     * <important>
     * <p>
     * Use this parameter with caution. This parameter causes the operation to skip the normal waiting period before the
     * permanent deletion that AWS would normally impose with the <code>RecoveryWindowInDays</code> parameter. If you
     * delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you have no opportunity to
     * recover the secret. It is permanently lost.
     * </p>
     * </important>
     * 
     * @return (Optional) Specifies that the secret is to be deleted without any recovery window. You can't use both
     *         this parameter and the <code>RecoveryWindowInDays</code> parameter in the same API call.</p>
     *         <p>
     *         An asynchronous background process performs the actual deletion, so there can be a short delay before the
     *         operation completes. If you write code to delete and then immediately recreate a secret with the same
     *         name, ensure that your code includes appropriate back off and retry logic.
     *         </p>
     *         <important>
     *         <p>
     *         Use this parameter with caution. This parameter causes the operation to skip the normal waiting period
     *         before the permanent deletion that AWS would normally impose with the <code>RecoveryWindowInDays</code>
     *         parameter. If you delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you
     *         have no opportunity to recover the secret. It is permanently lost.
     *         </p>
     */
    public Boolean forceDeleteWithoutRecovery() {
        return forceDeleteWithoutRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryWindowInDays());
        hashCode = 31 * hashCode + Objects.hashCode(forceDeleteWithoutRecovery());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecretRequest)) {
            return false;
        }
        DeleteSecretRequest other = (DeleteSecretRequest) obj;
        return Objects.equals(secretId(), other.secretId())
                && Objects.equals(recoveryWindowInDays(), other.recoveryWindowInDays())
                && Objects.equals(forceDeleteWithoutRecovery(), other.forceDeleteWithoutRecovery());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteSecretRequest").add("SecretId", secretId())
                .add("RecoveryWindowInDays", recoveryWindowInDays())
                .add("ForceDeleteWithoutRecovery", forceDeleteWithoutRecovery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "RecoveryWindowInDays":
            return Optional.ofNullable(clazz.cast(recoveryWindowInDays()));
        case "ForceDeleteWithoutRecovery":
            return Optional.ofNullable(clazz.cast(forceDeleteWithoutRecovery()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, DeleteSecretRequest> {
        /**
         * <p>
         * Specifies the secret that you want to delete. You can specify either the Amazon Resource Name (ARN) or the
         * friendly name of the secret.
         * </p>
         * 
         * @param secretId
         *        Specifies the secret that you want to delete. You can specify either the Amazon Resource Name (ARN) or
         *        the friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * (Optional) Specifies the number of days that Secrets Manager waits before it can delete the secret. You can't
         * use both this parameter and the <code>ForceDeleteWithoutRecovery</code> parameter in the same API call.
         * </p>
         * <p>
         * This value can range from 7 to 30 days. The default value is 30.
         * </p>
         * 
         * @param recoveryWindowInDays
         *        (Optional) Specifies the number of days that Secrets Manager waits before it can delete the secret.
         *        You can't use both this parameter and the <code>ForceDeleteWithoutRecovery</code> parameter in the
         *        same API call.</p>
         *        <p>
         *        This value can range from 7 to 30 days. The default value is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryWindowInDays(Long recoveryWindowInDays);

        /**
         * <p>
         * (Optional) Specifies that the secret is to be deleted without any recovery window. You can't use both this
         * parameter and the <code>RecoveryWindowInDays</code> parameter in the same API call.
         * </p>
         * <p>
         * An asynchronous background process performs the actual deletion, so there can be a short delay before the
         * operation completes. If you write code to delete and then immediately recreate a secret with the same name,
         * ensure that your code includes appropriate back off and retry logic.
         * </p>
         * <important>
         * <p>
         * Use this parameter with caution. This parameter causes the operation to skip the normal waiting period before
         * the permanent deletion that AWS would normally impose with the <code>RecoveryWindowInDays</code> parameter.
         * If you delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you have no
         * opportunity to recover the secret. It is permanently lost.
         * </p>
         * </important>
         * 
         * @param forceDeleteWithoutRecovery
         *        (Optional) Specifies that the secret is to be deleted without any recovery window. You can't use both
         *        this parameter and the <code>RecoveryWindowInDays</code> parameter in the same API call.</p>
         *        <p>
         *        An asynchronous background process performs the actual deletion, so there can be a short delay before
         *        the operation completes. If you write code to delete and then immediately recreate a secret with the
         *        same name, ensure that your code includes appropriate back off and retry logic.
         *        </p>
         *        <important>
         *        <p>
         *        Use this parameter with caution. This parameter causes the operation to skip the normal waiting period
         *        before the permanent deletion that AWS would normally impose with the
         *        <code>RecoveryWindowInDays</code> parameter. If you delete a secret with the
         *        <code>ForceDeleteWithouRecovery</code> parameter, then you have no opportunity to recover the secret.
         *        It is permanently lost.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDeleteWithoutRecovery(Boolean forceDeleteWithoutRecovery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private Long recoveryWindowInDays;

        private Boolean forceDeleteWithoutRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecretRequest model) {
            super(model);
            secretId(model.secretId);
            recoveryWindowInDays(model.recoveryWindowInDays);
            forceDeleteWithoutRecovery(model.forceDeleteWithoutRecovery);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final Long getRecoveryWindowInDays() {
            return recoveryWindowInDays;
        }

        @Override
        public final Builder recoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
            return this;
        }

        public final void setRecoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
        }

        public final Boolean getForceDeleteWithoutRecovery() {
            return forceDeleteWithoutRecovery;
        }

        @Override
        public final Builder forceDeleteWithoutRecovery(Boolean forceDeleteWithoutRecovery) {
            this.forceDeleteWithoutRecovery = forceDeleteWithoutRecovery;
            return this;
        }

        public final void setForceDeleteWithoutRecovery(Boolean forceDeleteWithoutRecovery) {
            this.forceDeleteWithoutRecovery = forceDeleteWithoutRecovery;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSecretRequest build() {
            return new DeleteSecretRequest(this);
        }
    }
}
