/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSecretResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<DeleteSecretResponse.Builder, DeleteSecretResponse> {
    private final String arn;

    private final String name;

    private final Instant deletionDate;

    private DeleteSecretResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.deletionDate = builder.deletionDate;
    }

    /**
     * <p>
     * The ARN of the secret that is now scheduled for deletion.
     * </p>
     * 
     * @return The ARN of the secret that is now scheduled for deletion.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name of the secret that is now scheduled for deletion.
     * </p>
     * 
     * @return The friendly name of the secret that is now scheduled for deletion.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The date and time after which this secret can be deleted by Secrets Manager and can no longer be restored. This
     * value is the date and time of the delete request plus the number of days specified in
     * <code>RecoveryWindowInDays</code>.
     * </p>
     * 
     * @return The date and time after which this secret can be deleted by Secrets Manager and can no longer be
     *         restored. This value is the date and time of the delete request plus the number of days specified in
     *         <code>RecoveryWindowInDays</code>.
     */
    public Instant deletionDate() {
        return deletionDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(deletionDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecretResponse)) {
            return false;
        }
        DeleteSecretResponse other = (DeleteSecretResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(deletionDate(), other.deletionDate());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteSecretResponse").add("ARN", arn()).add("Name", name()).add("DeletionDate", deletionDate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DeletionDate":
            return Optional.ofNullable(clazz.cast(deletionDate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerResponse.Builder, CopyableBuilder<Builder, DeleteSecretResponse> {
        /**
         * <p>
         * The ARN of the secret that is now scheduled for deletion.
         * </p>
         * 
         * @param arn
         *        The ARN of the secret that is now scheduled for deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name of the secret that is now scheduled for deletion.
         * </p>
         * 
         * @param name
         *        The friendly name of the secret that is now scheduled for deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time after which this secret can be deleted by Secrets Manager and can no longer be restored.
         * This value is the date and time of the delete request plus the number of days specified in
         * <code>RecoveryWindowInDays</code>.
         * </p>
         * 
         * @param deletionDate
         *        The date and time after which this secret can be deleted by Secrets Manager and can no longer be
         *        restored. This value is the date and time of the delete request plus the number of days specified in
         *        <code>RecoveryWindowInDays</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionDate(Instant deletionDate);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant deletionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecretResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            deletionDate(model.deletionDate);
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getDeletionDate() {
            return deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        @Override
        public DeleteSecretResponse build() {
            return new DeleteSecretResponse(this);
        }
    }
}
