/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRandomPasswordResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<GetRandomPasswordResponse.Builder, GetRandomPasswordResponse> {
    private final String randomPassword;

    private GetRandomPasswordResponse(BuilderImpl builder) {
        super(builder);
        this.randomPassword = builder.randomPassword;
    }

    /**
     * <p>
     * A string with the generated password.
     * </p>
     * 
     * @return A string with the generated password.
     */
    public String randomPassword() {
        return randomPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(randomPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRandomPasswordResponse)) {
            return false;
        }
        GetRandomPasswordResponse other = (GetRandomPasswordResponse) obj;
        return Objects.equals(randomPassword(), other.randomPassword());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRandomPasswordResponse").add("RandomPassword", randomPassword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RandomPassword":
            return Optional.ofNullable(clazz.cast(randomPassword()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerResponse.Builder, CopyableBuilder<Builder, GetRandomPasswordResponse> {
        /**
         * <p>
         * A string with the generated password.
         * </p>
         * 
         * @param randomPassword
         *        A string with the generated password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder randomPassword(String randomPassword);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String randomPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRandomPasswordResponse model) {
            super(model);
            randomPassword(model.randomPassword);
        }

        public final String getRandomPassword() {
            return randomPassword;
        }

        @Override
        public final Builder randomPassword(String randomPassword) {
            this.randomPassword = randomPassword;
            return this;
        }

        public final void setRandomPassword(String randomPassword) {
            this.randomPassword = randomPassword;
        }

        @Override
        public GetRandomPasswordResponse build() {
            return new GetRandomPasswordResponse(this);
        }
    }
}
