/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcePolicyResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<GetResourcePolicyResponse.Builder, GetResourcePolicyResponse> {
    private final String arn;

    private final String name;

    private final String resourcePolicy;

    private GetResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.resourcePolicy = builder.resourcePolicy;
    }

    /**
     * <p>
     * The ARN of the secret that the resource-based policy was retrieved for.
     * </p>
     * 
     * @return The ARN of the secret that the resource-based policy was retrieved for.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name of the secret that the resource-based policy was retrieved for.
     * </p>
     * 
     * @return The friendly name of the secret that the resource-based policy was retrieved for.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A JSON-formatted string that describes the permissions that are associated with the attached secret. These
     * permissions are combined with any permissions that are associated with the user or role that attempts to access
     * this secret. The combined permissions specify who can access the secret and what actions they can perform. For
     * more information, see <a
     * href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and Access
     * Control for AWS Secrets Manager</a> in the <i>AWS Secrets Manager User Guide</i>.
     * </p>
     * 
     * @return A JSON-formatted string that describes the permissions that are associated with the attached secret.
     *         These permissions are combined with any permissions that are associated with the user or role that
     *         attempts to access this secret. The combined permissions specify who can access the secret and what
     *         actions they can perform. For more information, see <a
     *         href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and
     *         Access Control for AWS Secrets Manager</a> in the <i>AWS Secrets Manager User Guide</i>.
     */
    public String resourcePolicy() {
        return resourcePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePolicyResponse)) {
            return false;
        }
        GetResourcePolicyResponse other = (GetResourcePolicyResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(resourcePolicy(), other.resourcePolicy());
    }

    @Override
    public String toString() {
        return ToString.builder("GetResourcePolicyResponse").add("ARN", arn()).add("Name", name())
                .add("ResourcePolicy", resourcePolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerResponse.Builder, CopyableBuilder<Builder, GetResourcePolicyResponse> {
        /**
         * <p>
         * The ARN of the secret that the resource-based policy was retrieved for.
         * </p>
         * 
         * @param arn
         *        The ARN of the secret that the resource-based policy was retrieved for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name of the secret that the resource-based policy was retrieved for.
         * </p>
         * 
         * @param name
         *        The friendly name of the secret that the resource-based policy was retrieved for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A JSON-formatted string that describes the permissions that are associated with the attached secret. These
         * permissions are combined with any permissions that are associated with the user or role that attempts to
         * access this secret. The combined permissions specify who can access the secret and what actions they can
         * perform. For more information, see <a
         * href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and
         * Access Control for AWS Secrets Manager</a> in the <i>AWS Secrets Manager User Guide</i>.
         * </p>
         * 
         * @param resourcePolicy
         *        A JSON-formatted string that describes the permissions that are associated with the attached secret.
         *        These permissions are combined with any permissions that are associated with the user or role that
         *        attempts to access this secret. The combined permissions specify who can access the secret and what
         *        actions they can perform. For more information, see <a
         *        href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication
         *        and Access Control for AWS Secrets Manager</a> in the <i>AWS Secrets Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String resourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePolicyResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            resourcePolicy(model.resourcePolicy);
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public GetResourcePolicyResponse build() {
            return new GetResourcePolicyResponse(this);
        }
    }
}
