/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecretsResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<ListSecretsResponse.Builder, ListSecretsResponse> {
    private final List<SecretListEntry> secretList;

    private final String nextToken;

    private ListSecretsResponse(BuilderImpl builder) {
        super(builder);
        this.secretList = builder.secretList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of the secrets in the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the secrets in the account.
     */
    public List<SecretListEntry> secretList() {
        return secretList;
    }

    /**
     * <p>
     * If present in the response, this value indicates that there's more output available than what's included in the
     * current response. This can occur even when the response includes no values at all, such as when you ask for a
     * filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a subsequent
     * call to the operation to continue processing and get the next part of the output. You should repeat this until
     * the <code>NextToken</code> response element comes back empty (as <code>null</code>).
     * </p>
     * 
     * @return If present in the response, this value indicates that there's more output available than what's included
     *         in the current response. This can occur even when the response includes no values at all, such as when
     *         you ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request
     *         parameter in a subsequent call to the operation to continue processing and get the next part of the
     *         output. You should repeat this until the <code>NextToken</code> response element comes back empty (as
     *         <code>null</code>).
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretsResponse)) {
            return false;
        }
        ListSecretsResponse other = (ListSecretsResponse) obj;
        return Objects.equals(secretList(), other.secretList()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSecretsResponse").add("SecretList", secretList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretList":
            return Optional.ofNullable(clazz.cast(secretList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerResponse.Builder, CopyableBuilder<Builder, ListSecretsResponse> {
        /**
         * <p>
         * A list of the secrets in the account.
         * </p>
         * 
         * @param secretList
         *        A list of the secrets in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretList(Collection<SecretListEntry> secretList);

        /**
         * <p>
         * A list of the secrets in the account.
         * </p>
         * 
         * @param secretList
         *        A list of the secrets in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretList(SecretListEntry... secretList);

        /**
         * <p>
         * A list of the secrets in the account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecretListEntry>.Builder} avoiding the need
         * to create one manually via {@link List<SecretListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecretListEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #secretList(List<SecretListEntry>)}.
         * 
         * @param secretList
         *        a consumer that will call methods on {@link List<SecretListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretList(List<SecretListEntry>)
         */
        Builder secretList(Consumer<SecretListEntry.Builder>... secretList);

        /**
         * <p>
         * If present in the response, this value indicates that there's more output available than what's included in
         * the current response. This can occur even when the response includes no values at all, such as when you ask
         * for a filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a
         * subsequent call to the operation to continue processing and get the next part of the output. You should
         * repeat this until the <code>NextToken</code> response element comes back empty (as <code>null</code>).
         * </p>
         * 
         * @param nextToken
         *        If present in the response, this value indicates that there's more output available than what's
         *        included in the current response. This can occur even when the response includes no values at all,
         *        such as when you ask for a filtered view of a very long list. Use this value in the
         *        <code>NextToken</code> request parameter in a subsequent call to the operation to continue processing
         *        and get the next part of the output. You should repeat this until the <code>NextToken</code> response
         *        element comes back empty (as <code>null</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private List<SecretListEntry> secretList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecretsResponse model) {
            super(model);
            secretList(model.secretList);
            nextToken(model.nextToken);
        }

        public final Collection<SecretListEntry.Builder> getSecretList() {
            return secretList != null ? secretList.stream().map(SecretListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secretList(Collection<SecretListEntry> secretList) {
            this.secretList = SecretListTypeCopier.copy(secretList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretList(SecretListEntry... secretList) {
            secretList(Arrays.asList(secretList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretList(Consumer<SecretListEntry.Builder>... secretList) {
            secretList(Stream.of(secretList).map(c -> SecretListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecretList(Collection<SecretListEntry.BuilderImpl> secretList) {
            this.secretList = SecretListTypeCopier.copyFromBuilder(secretList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecretsResponse build() {
            return new ListSecretsResponse(this);
        }
    }
}
