/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private final String secretId;

    private final String resourcePolicy;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.resourcePolicy = builder.resourcePolicy;
    }

    /**
     * <p>
     * Specifies the secret that you want to attach the resource-based policy to. You can specify either the ARN or the
     * friendly name of the secret.
     * </p>
     * 
     * @return Specifies the secret that you want to attach the resource-based policy to. You can specify either the ARN
     *         or the friendly name of the secret.
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * A JSON-formatted string that's constructed according to the grammar and syntax for an AWS resource-based policy.
     * The policy in the string identifies who can access or manage this secret and its versions. For information on how
     * to format a JSON parameter for the various command line tool environments, see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for
     * Parameters</a> in the <i>AWS CLI User Guide</i>.
     * </p>
     * 
     * @return A JSON-formatted string that's constructed according to the grammar and syntax for an AWS resource-based
     *         policy. The policy in the string identifies who can access or manage this secret and its versions. For
     *         information on how to format a JSON parameter for the various command line tool environments, see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
     *         JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
     */
    public String resourcePolicy() {
        return resourcePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(resourcePolicy(), other.resourcePolicy());
    }

    @Override
    public String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("SecretId", secretId()).add("ResourcePolicy", resourcePolicy())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * Specifies the secret that you want to attach the resource-based policy to. You can specify either the ARN or
         * the friendly name of the secret.
         * </p>
         * 
         * @param secretId
         *        Specifies the secret that you want to attach the resource-based policy to. You can specify either the
         *        ARN or the friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * A JSON-formatted string that's constructed according to the grammar and syntax for an AWS resource-based
         * policy. The policy in the string identifies who can access or manage this secret and its versions. For
         * information on how to format a JSON parameter for the various command line tool environments, see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a> in the <i>AWS CLI User Guide</i>.
         * </p>
         * 
         * @param resourcePolicy
         *        A JSON-formatted string that's constructed according to the grammar and syntax for an AWS
         *        resource-based policy. The policy in the string identifies who can access or manage this secret and
         *        its versions. For information on how to format a JSON parameter for the various command line tool
         *        environments, see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
         *        JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String resourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            secretId(model.secretId);
            resourcePolicy(model.resourcePolicy);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }
    }
}
