/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagResourceRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<TagResourceRequest.Builder, TagResourceRequest> {
    private final String secretId;

    private final List<Tag> tags;

    private TagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier for the secret that you want to attach tags to. You can specify either the Amazon Resource Name
     * (ARN) or the friendly name of the secret.
     * </p>
     * 
     * @return The identifier for the secret that you want to attach tags to. You can specify either the Amazon Resource
     *         Name (ARN) or the friendly name of the secret.
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
     * <code>Value</code>.
     * </p>
     * <p>
     * This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter
     * for the various command line tool environments, see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for
     * Parameters</a> in the <i>AWS CLI User Guide</i>. For the AWS CLI, you can also use the syntax:
     * <code>--Tags Key="Key1",Value="Value1",Key="Key2",Value="Value2"[,…]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
     *         <code>Value</code>.</p>
     *         <p>
     *         This parameter to the API requires a JSON text string argument. For information on how to format a JSON
     *         parameter for the various command line tool environments, see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
     *         JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. For the AWS CLI, you can also use the syntax:
     *         <code>--Tags Key="Key1",Value="Value1",Key="Key2",Value="Value2"[,…]</code>
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("TagResourceRequest").add("SecretId", secretId()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, TagResourceRequest> {
        /**
         * <p>
         * The identifier for the secret that you want to attach tags to. You can specify either the Amazon Resource
         * Name (ARN) or the friendly name of the secret.
         * </p>
         * 
         * @param secretId
         *        The identifier for the secret that you want to attach tags to. You can specify either the Amazon
         *        Resource Name (ARN) or the friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         * <code>Value</code>.
         * </p>
         * <p>
         * This parameter to the API requires a JSON text string argument. For information on how to format a JSON
         * parameter for the various command line tool environments, see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a> in the <i>AWS CLI User Guide</i>. For the AWS CLI, you can also use the syntax:
         * <code>--Tags Key="Key1",Value="Value1",Key="Key2",Value="Value2"[,…]</code>
         * </p>
         * 
         * @param tags
         *        The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         *        <code>Value</code>.</p>
         *        <p>
         *        This parameter to the API requires a JSON text string argument. For information on how to format a
         *        JSON parameter for the various command line tool environments, see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
         *        JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. For the AWS CLI, you can also use the
         *        syntax: <code>--Tags Key="Key1",Value="Value1",Key="Key2",Value="Value2"[,…]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         * <code>Value</code>.
         * </p>
         * <p>
         * This parameter to the API requires a JSON text string argument. For information on how to format a JSON
         * parameter for the various command line tool environments, see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a> in the <i>AWS CLI User Guide</i>. For the AWS CLI, you can also use the syntax:
         * <code>--Tags Key="Key1",Value="Value1",Key="Key2",Value="Value2"[,…]</code>
         * </p>
         * 
         * @param tags
         *        The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         *        <code>Value</code>.</p>
         *        <p>
         *        This parameter to the API requires a JSON text string argument. For information on how to format a
         *        JSON parameter for the various command line tool environments, see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
         *        JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. For the AWS CLI, you can also use the
         *        syntax: <code>--Tags Key="Key1",Value="Value1",Key="Key2",Value="Value2"[,…]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         * <code>Value</code>.
         * </p>
         * <p>
         * This parameter to the API requires a JSON text string argument. For information on how to format a JSON
         * parameter for the various command line tool environments, see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a> in the <i>AWS CLI User Guide</i>. For the AWS CLI, you can also use the syntax:
         * <code>--Tags Key="Key1",Value="Value1",Key="Key2",Value="Value2"[,…]</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagResourceRequest model) {
            super(model);
            secretId(model.secretId);
            tags(model.tags);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TagResourceRequest build() {
            return new TagResourceRequest(this);
        }
    }
}
