/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecretVersionStageRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<UpdateSecretVersionStageRequest.Builder, UpdateSecretVersionStageRequest> {
    private final String secretId;

    private final String versionStage;

    private final String removeFromVersionId;

    private final String moveToVersionId;

    private UpdateSecretVersionStageRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.versionStage = builder.versionStage;
        this.removeFromVersionId = builder.removeFromVersionId;
        this.moveToVersionId = builder.moveToVersionId;
    }

    /**
     * <p>
     * Specifies the secret with the version whose list of staging labels you want to modify. You can specify either the
     * Amazon Resource Name (ARN) or the friendly name of the secret.
     * </p>
     * 
     * @return Specifies the secret with the version whose list of staging labels you want to modify. You can specify
     *         either the Amazon Resource Name (ARN) or the friendly name of the secret.
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * The list of staging labels to add to this version.
     * </p>
     * 
     * @return The list of staging labels to add to this version.
     */
    public String versionStage() {
        return versionStage;
    }

    /**
     * <p>
     * (Optional) Specifies the secret version ID of the version that the staging labels are to be removed from.
     * </p>
     * <p>
     * If you want to move a label to a new version, you do not have to explicitly remove it with this parameter. Adding
     * a label using the <code>MoveToVersionId</code> parameter automatically removes it from the old version. However,
     * if you do include both the "MoveTo" and "RemoveFrom" parameters, then the move is successful only if the staging
     * labels are actually present on the "RemoveFrom" version. If a staging label was on a different version than
     * "RemoveFrom", then the request fails.
     * </p>
     * 
     * @return (Optional) Specifies the secret version ID of the version that the staging labels are to be removed
     *         from.</p>
     *         <p>
     *         If you want to move a label to a new version, you do not have to explicitly remove it with this
     *         parameter. Adding a label using the <code>MoveToVersionId</code> parameter automatically removes it from
     *         the old version. However, if you do include both the "MoveTo" and "RemoveFrom" parameters, then the move
     *         is successful only if the staging labels are actually present on the "RemoveFrom" version. If a staging
     *         label was on a different version than "RemoveFrom", then the request fails.
     */
    public String removeFromVersionId() {
        return removeFromVersionId;
    }

    /**
     * <p>
     * (Optional) The secret version ID that you want to add the staging labels to.
     * </p>
     * <p>
     * If any of the staging labels are already attached to a different version of the secret, then they are
     * automatically removed from that version before adding them to this version.
     * </p>
     * 
     * @return (Optional) The secret version ID that you want to add the staging labels to.</p>
     *         <p>
     *         If any of the staging labels are already attached to a different version of the secret, then they are
     *         automatically removed from that version before adding them to this version.
     */
    public String moveToVersionId() {
        return moveToVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(versionStage());
        hashCode = 31 * hashCode + Objects.hashCode(removeFromVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(moveToVersionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecretVersionStageRequest)) {
            return false;
        }
        UpdateSecretVersionStageRequest other = (UpdateSecretVersionStageRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(versionStage(), other.versionStage())
                && Objects.equals(removeFromVersionId(), other.removeFromVersionId())
                && Objects.equals(moveToVersionId(), other.moveToVersionId());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateSecretVersionStageRequest").add("SecretId", secretId())
                .add("VersionStage", versionStage()).add("RemoveFromVersionId", removeFromVersionId())
                .add("MoveToVersionId", moveToVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "VersionStage":
            return Optional.ofNullable(clazz.cast(versionStage()));
        case "RemoveFromVersionId":
            return Optional.ofNullable(clazz.cast(removeFromVersionId()));
        case "MoveToVersionId":
            return Optional.ofNullable(clazz.cast(moveToVersionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, UpdateSecretVersionStageRequest> {
        /**
         * <p>
         * Specifies the secret with the version whose list of staging labels you want to modify. You can specify either
         * the Amazon Resource Name (ARN) or the friendly name of the secret.
         * </p>
         * 
         * @param secretId
         *        Specifies the secret with the version whose list of staging labels you want to modify. You can specify
         *        either the Amazon Resource Name (ARN) or the friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * The list of staging labels to add to this version.
         * </p>
         * 
         * @param versionStage
         *        The list of staging labels to add to this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionStage(String versionStage);

        /**
         * <p>
         * (Optional) Specifies the secret version ID of the version that the staging labels are to be removed from.
         * </p>
         * <p>
         * If you want to move a label to a new version, you do not have to explicitly remove it with this parameter.
         * Adding a label using the <code>MoveToVersionId</code> parameter automatically removes it from the old
         * version. However, if you do include both the "MoveTo" and "RemoveFrom" parameters, then the move is
         * successful only if the staging labels are actually present on the "RemoveFrom" version. If a staging label
         * was on a different version than "RemoveFrom", then the request fails.
         * </p>
         * 
         * @param removeFromVersionId
         *        (Optional) Specifies the secret version ID of the version that the staging labels are to be removed
         *        from.</p>
         *        <p>
         *        If you want to move a label to a new version, you do not have to explicitly remove it with this
         *        parameter. Adding a label using the <code>MoveToVersionId</code> parameter automatically removes it
         *        from the old version. However, if you do include both the "MoveTo" and "RemoveFrom" parameters, then
         *        the move is successful only if the staging labels are actually present on the "RemoveFrom" version. If
         *        a staging label was on a different version than "RemoveFrom", then the request fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFromVersionId(String removeFromVersionId);

        /**
         * <p>
         * (Optional) The secret version ID that you want to add the staging labels to.
         * </p>
         * <p>
         * If any of the staging labels are already attached to a different version of the secret, then they are
         * automatically removed from that version before adding them to this version.
         * </p>
         * 
         * @param moveToVersionId
         *        (Optional) The secret version ID that you want to add the staging labels to.</p>
         *        <p>
         *        If any of the staging labels are already attached to a different version of the secret, then they are
         *        automatically removed from that version before adding them to this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moveToVersionId(String moveToVersionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String versionStage;

        private String removeFromVersionId;

        private String moveToVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecretVersionStageRequest model) {
            super(model);
            secretId(model.secretId);
            versionStage(model.versionStage);
            removeFromVersionId(model.removeFromVersionId);
            moveToVersionId(model.moveToVersionId);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getVersionStage() {
            return versionStage;
        }

        @Override
        public final Builder versionStage(String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        public final void setVersionStage(String versionStage) {
            this.versionStage = versionStage;
        }

        public final String getRemoveFromVersionId() {
            return removeFromVersionId;
        }

        @Override
        public final Builder removeFromVersionId(String removeFromVersionId) {
            this.removeFromVersionId = removeFromVersionId;
            return this;
        }

        public final void setRemoveFromVersionId(String removeFromVersionId) {
            this.removeFromVersionId = removeFromVersionId;
        }

        public final String getMoveToVersionId() {
            return moveToVersionId;
        }

        @Override
        public final Builder moveToVersionId(String moveToVersionId) {
            this.moveToVersionId = moveToVersionId;
            return this;
        }

        public final void setMoveToVersionId(String moveToVersionId) {
            this.moveToVersionId = moveToVersionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecretVersionStageRequest build() {
            return new UpdateSecretVersionStageRequest(this);
        }
    }
}
