/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.secretsmanager.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeSecretResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSecretResponseUnmarshaller implements Unmarshaller<DescribeSecretResponse, JsonUnmarshallerContext> {

    public DescribeSecretResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeSecretResponse.Builder describeSecretResponseBuilder = DescribeSecretResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeSecretResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ARN", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.kmsKeyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RotationEnabled", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.rotationEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("RotationLambdaARN", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.rotationLambdaARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RotationRules", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.rotationRules(RotationRulesTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LastRotatedDate", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.lastRotatedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("LastChangedDate", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.lastChangedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("LastAccessedDate", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.lastAccessedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("DeletedDate", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.deletedDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.tags(new ListUnmarshaller<Tag>(TagUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("VersionIdsToStages", targetDepth)) {
                    context.nextToken();
                    describeSecretResponseBuilder.versionIdsToStages(new MapUnmarshaller<String, java.util.List<String>>(context
                            .getUnmarshaller(String.class), new ListUnmarshaller<String>(context.getUnmarshaller(String.class)))
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeSecretResponseBuilder.build();
    }

    private static final DescribeSecretResponseUnmarshaller INSTANCE = new DescribeSecretResponseUnmarshaller();

    public static DescribeSecretResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
