/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetRandomPasswordRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetRandomPasswordRequestModelMarshaller {
    private static final MarshallingInfo<Long> PASSWORDLENGTH_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PasswordLength").isBinary(false).build();

    private static final MarshallingInfo<String> EXCLUDECHARACTERS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeCharacters").isBinary(false).build();

    private static final MarshallingInfo<Boolean> EXCLUDENUMBERS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeNumbers").isBinary(false).build();

    private static final MarshallingInfo<Boolean> EXCLUDEPUNCTUATION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludePunctuation").isBinary(false).build();

    private static final MarshallingInfo<Boolean> EXCLUDEUPPERCASE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeUppercase").isBinary(false).build();

    private static final MarshallingInfo<Boolean> EXCLUDELOWERCASE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeLowercase").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INCLUDESPACE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeSpace").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REQUIREEACHINCLUDEDTYPE_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RequireEachIncludedType").isBinary(false).build();

    private static final GetRandomPasswordRequestModelMarshaller INSTANCE = new GetRandomPasswordRequestModelMarshaller();

    private GetRandomPasswordRequestModelMarshaller() {
    }

    public static GetRandomPasswordRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetRandomPasswordRequest getRandomPasswordRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getRandomPasswordRequest, "getRandomPasswordRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getRandomPasswordRequest.passwordLength(), PASSWORDLENGTH_BINDING);
            protocolMarshaller.marshall(getRandomPasswordRequest.excludeCharacters(), EXCLUDECHARACTERS_BINDING);
            protocolMarshaller.marshall(getRandomPasswordRequest.excludeNumbers(), EXCLUDENUMBERS_BINDING);
            protocolMarshaller.marshall(getRandomPasswordRequest.excludePunctuation(), EXCLUDEPUNCTUATION_BINDING);
            protocolMarshaller.marshall(getRandomPasswordRequest.excludeUppercase(), EXCLUDEUPPERCASE_BINDING);
            protocolMarshaller.marshall(getRandomPasswordRequest.excludeLowercase(), EXCLUDELOWERCASE_BINDING);
            protocolMarshaller.marshall(getRandomPasswordRequest.includeSpace(), INCLUDESPACE_BINDING);
            protocolMarshaller.marshall(getRandomPasswordRequest.requireEachIncludedType(), REQUIREEACHINCLUDEDTYPE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
