/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.transform;

import java.math.*;
import software.amazon.awssdk.core.SdkBytes;
import javax.annotation.Generated;

import software.amazon.awssdk.services.secretsmanager.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetSecretValueResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetSecretValueResponseUnmarshaller implements Unmarshaller<GetSecretValueResponse, JsonUnmarshallerContext> {

    public GetSecretValueResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetSecretValueResponse.Builder getSecretValueResponseBuilder = GetSecretValueResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getSecretValueResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ARN", targetDepth)) {
                    context.nextToken();
                    getSecretValueResponseBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    getSecretValueResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    context.nextToken();
                    getSecretValueResponseBuilder.versionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SecretBinary", targetDepth)) {
                    context.nextToken();
                    getSecretValueResponseBuilder.secretBinary(context
                            .getUnmarshaller(software.amazon.awssdk.core.SdkBytes.class).unmarshall(context));
                }
                if (context.testExpression("SecretString", targetDepth)) {
                    context.nextToken();
                    getSecretValueResponseBuilder.secretString(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VersionStages", targetDepth)) {
                    context.nextToken();
                    getSecretValueResponseBuilder.versionStages(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CreatedDate", targetDepth)) {
                    context.nextToken();
                    getSecretValueResponseBuilder.createdDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getSecretValueResponseBuilder.build();
    }

    private static final GetSecretValueResponseUnmarshaller INSTANCE = new GetSecretValueResponseUnmarshaller();

    public static GetSecretValueResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
