/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RotateSecretRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RotateSecretRequestModelMarshaller {
    private static final MarshallingInfo<String> SECRETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretId").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").isBinary(false)
            .defaultValueSupplier(IdempotentUtils.getGenerator()).build();

    private static final MarshallingInfo<String> ROTATIONLAMBDAARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationLambdaARN").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ROTATIONRULES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationRules")
            .isBinary(false).build();

    private static final RotateSecretRequestModelMarshaller INSTANCE = new RotateSecretRequestModelMarshaller();

    private RotateSecretRequestModelMarshaller() {
    }

    public static RotateSecretRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RotateSecretRequest rotateSecretRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(rotateSecretRequest, "rotateSecretRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(rotateSecretRequest.secretId(), SECRETID_BINDING);
            protocolMarshaller.marshall(rotateSecretRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall(rotateSecretRequest.rotationLambdaARN(), ROTATIONLAMBDAARN_BINDING);
            protocolMarshaller.marshall(rotateSecretRequest.rotationRules(), ROTATIONRULES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
