/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecretResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<DescribeSecretResponse.Builder, DescribeSecretResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(DescribeSecretResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeSecretResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeSecretResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeSecretResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ROTATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RotationEnabled").getter(getter(DescribeSecretResponse::rotationEnabled))
            .setter(setter(Builder::rotationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationEnabled").build()).build();

    private static final SdkField<String> ROTATION_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationLambdaARN").getter(getter(DescribeSecretResponse::rotationLambdaARN))
            .setter(setter(Builder::rotationLambdaARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationLambdaARN").build()).build();

    private static final SdkField<RotationRulesType> ROTATION_RULES_FIELD = SdkField
            .<RotationRulesType> builder(MarshallingType.SDK_POJO).memberName("RotationRules")
            .getter(getter(DescribeSecretResponse::rotationRules)).setter(setter(Builder::rotationRules))
            .constructor(RotationRulesType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationRules").build()).build();

    private static final SdkField<Instant> LAST_ROTATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastRotatedDate").getter(getter(DescribeSecretResponse::lastRotatedDate))
            .setter(setter(Builder::lastRotatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRotatedDate").build()).build();

    private static final SdkField<Instant> LAST_CHANGED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastChangedDate").getter(getter(DescribeSecretResponse::lastChangedDate))
            .setter(setter(Builder::lastChangedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastChangedDate").build()).build();

    private static final SdkField<Instant> LAST_ACCESSED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAccessedDate").getter(getter(DescribeSecretResponse::lastAccessedDate))
            .setter(setter(Builder::lastAccessedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedDate").build()).build();

    private static final SdkField<Instant> DELETED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletedDate").getter(getter(DescribeSecretResponse::deletedDate)).setter(setter(Builder::deletedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedDate").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribeSecretResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> VERSION_IDS_TO_STAGES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("VersionIdsToStages")
            .getter(getter(DescribeSecretResponse::versionIdsToStages))
            .setter(setter(Builder::versionIdsToStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionIdsToStages").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> OWNING_SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwningService").getter(getter(DescribeSecretResponse::owningService))
            .setter(setter(Builder::owningService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwningService").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(DescribeSecretResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, KMS_KEY_ID_FIELD, ROTATION_ENABLED_FIELD, ROTATION_LAMBDA_ARN_FIELD, ROTATION_RULES_FIELD,
            LAST_ROTATED_DATE_FIELD, LAST_CHANGED_DATE_FIELD, LAST_ACCESSED_DATE_FIELD, DELETED_DATE_FIELD, TAGS_FIELD,
            VERSION_IDS_TO_STAGES_FIELD, OWNING_SERVICE_FIELD, CREATED_DATE_FIELD));

    private final String arn;

    private final String name;

    private final String description;

    private final String kmsKeyId;

    private final Boolean rotationEnabled;

    private final String rotationLambdaARN;

    private final RotationRulesType rotationRules;

    private final Instant lastRotatedDate;

    private final Instant lastChangedDate;

    private final Instant lastAccessedDate;

    private final Instant deletedDate;

    private final List<Tag> tags;

    private final Map<String, List<String>> versionIdsToStages;

    private final String owningService;

    private final Instant createdDate;

    private DescribeSecretResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.rotationEnabled = builder.rotationEnabled;
        this.rotationLambdaARN = builder.rotationLambdaARN;
        this.rotationRules = builder.rotationRules;
        this.lastRotatedDate = builder.lastRotatedDate;
        this.lastChangedDate = builder.lastChangedDate;
        this.lastAccessedDate = builder.lastAccessedDate;
        this.deletedDate = builder.deletedDate;
        this.tags = builder.tags;
        this.versionIdsToStages = builder.versionIdsToStages;
        this.owningService = builder.owningService;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The ARN of the secret.
     * </p>
     * 
     * @return The ARN of the secret.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The user-provided friendly name of the secret.
     * </p>
     * 
     * @return The user-provided friendly name of the secret.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The user-provided description of the secret.
     * </p>
     * 
     * @return The user-provided description of the secret.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ARN or alias of the AWS KMS customer master key (CMK) that's used to encrypt the <code>SecretString</code> or
     * <code>SecretBinary</code> fields in each version of the secret. If you don't provide a key, then Secrets Manager
     * defaults to encrypting the secret fields with the default AWS KMS CMK (the one named
     * <code>awssecretsmanager</code>) for this account.
     * </p>
     * 
     * @return The ARN or alias of the AWS KMS customer master key (CMK) that's used to encrypt the
     *         <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret. If you don't
     *         provide a key, then Secrets Manager defaults to encrypting the secret fields with the default AWS KMS CMK
     *         (the one named <code>awssecretsmanager</code>) for this account.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether automatic rotation is enabled for this secret.
     * </p>
     * <p>
     * To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a value greater
     * than 0. To disable rotation, use <a>CancelRotateSecret</a>.
     * </p>
     * 
     * @return Specifies whether automatic rotation is enabled for this secret.</p>
     *         <p>
     *         To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a value
     *         greater than 0. To disable rotation, use <a>CancelRotateSecret</a>.
     */
    public Boolean rotationEnabled() {
        return rotationEnabled;
    }

    /**
     * <p>
     * The ARN of a Lambda function that's invoked by Secrets Manager to rotate the secret either automatically per the
     * schedule or manually by a call to <code>RotateSecret</code>.
     * </p>
     * 
     * @return The ARN of a Lambda function that's invoked by Secrets Manager to rotate the secret either automatically
     *         per the schedule or manually by a call to <code>RotateSecret</code>.
     */
    public String rotationLambdaARN() {
        return rotationLambdaARN;
    }

    /**
     * <p>
     * A structure that contains the rotation configuration for this secret.
     * </p>
     * 
     * @return A structure that contains the rotation configuration for this secret.
     */
    public RotationRulesType rotationRules() {
        return rotationRules;
    }

    /**
     * <p>
     * The most recent date and time that the Secrets Manager rotation process was successfully completed. This value is
     * null if the secret has never rotated.
     * </p>
     * 
     * @return The most recent date and time that the Secrets Manager rotation process was successfully completed. This
     *         value is null if the secret has never rotated.
     */
    public Instant lastRotatedDate() {
        return lastRotatedDate;
    }

    /**
     * <p>
     * The last date and time that this secret was modified in any way.
     * </p>
     * 
     * @return The last date and time that this secret was modified in any way.
     */
    public Instant lastChangedDate() {
        return lastChangedDate;
    }

    /**
     * <p>
     * The last date that this secret was accessed. This value is truncated to midnight of the date and therefore shows
     * only the date, not the time.
     * </p>
     * 
     * @return The last date that this secret was accessed. This value is truncated to midnight of the date and
     *         therefore shows only the date, not the time.
     */
    public Instant lastAccessedDate() {
        return lastAccessedDate;
    }

    /**
     * <p>
     * This value exists if the secret is scheduled for deletion. Some time after the specified date and time, Secrets
     * Manager deletes the secret and all of its versions.
     * </p>
     * <p>
     * If a secret is scheduled for deletion, then its details, including the encrypted secret information, is not
     * accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.
     * </p>
     * 
     * @return This value exists if the secret is scheduled for deletion. Some time after the specified date and time,
     *         Secrets Manager deletes the secret and all of its versions.</p>
     *         <p>
     *         If a secret is scheduled for deletion, then its details, including the encrypted secret information, is
     *         not accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.
     */
    public Instant deletedDate() {
        return deletedDate;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user-defined tags that are associated with the secret. To add tags to a secret, use
     * <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of user-defined tags that are associated with the secret. To add tags to a secret, use
     *         <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the VersionIdsToStages property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVersionIdsToStages() {
        return versionIdsToStages != null && !(versionIdsToStages instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of all of the currently assigned <code>VersionStage</code> staging labels and the <code>VersionId</code>
     * that each is attached to. Staging labels are used to keep track of the different versions during the rotation
     * process.
     * </p>
     * <note>
     * <p>
     * A version that does not have any staging labels attached is considered deprecated and subject to deletion. Such
     * versions are not included in this list.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersionIdsToStages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all of the currently assigned <code>VersionStage</code> staging labels and the
     *         <code>VersionId</code> that each is attached to. Staging labels are used to keep track of the different
     *         versions during the rotation process.</p> <note>
     *         <p>
     *         A version that does not have any staging labels attached is considered deprecated and subject to
     *         deletion. Such versions are not included in this list.
     *         </p>
     */
    public Map<String, List<String>> versionIdsToStages() {
        return versionIdsToStages;
    }

    /**
     * <p>
     * Returns the name of the service that created this secret.
     * </p>
     * 
     * @return Returns the name of the service that created this secret.
     */
    public String owningService() {
        return owningService;
    }

    /**
     * <p>
     * The date that the secret was created.
     * </p>
     * 
     * @return The date that the secret was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(rotationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(rotationLambdaARN());
        hashCode = 31 * hashCode + Objects.hashCode(rotationRules());
        hashCode = 31 * hashCode + Objects.hashCode(lastRotatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastChangedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedDate());
        hashCode = 31 * hashCode + Objects.hashCode(deletedDate());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(versionIdsToStages());
        hashCode = 31 * hashCode + Objects.hashCode(owningService());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecretResponse)) {
            return false;
        }
        DescribeSecretResponse other = (DescribeSecretResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(rotationEnabled(), other.rotationEnabled())
                && Objects.equals(rotationLambdaARN(), other.rotationLambdaARN())
                && Objects.equals(rotationRules(), other.rotationRules())
                && Objects.equals(lastRotatedDate(), other.lastRotatedDate())
                && Objects.equals(lastChangedDate(), other.lastChangedDate())
                && Objects.equals(lastAccessedDate(), other.lastAccessedDate())
                && Objects.equals(deletedDate(), other.deletedDate()) && Objects.equals(tags(), other.tags())
                && Objects.equals(versionIdsToStages(), other.versionIdsToStages())
                && Objects.equals(owningService(), other.owningService()) && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSecretResponse").add("ARN", arn()).add("Name", name()).add("Description", description())
                .add("KmsKeyId", kmsKeyId()).add("RotationEnabled", rotationEnabled())
                .add("RotationLambdaARN", rotationLambdaARN()).add("RotationRules", rotationRules())
                .add("LastRotatedDate", lastRotatedDate()).add("LastChangedDate", lastChangedDate())
                .add("LastAccessedDate", lastAccessedDate()).add("DeletedDate", deletedDate()).add("Tags", tags())
                .add("VersionIdsToStages", versionIdsToStages()).add("OwningService", owningService())
                .add("CreatedDate", createdDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "RotationEnabled":
            return Optional.ofNullable(clazz.cast(rotationEnabled()));
        case "RotationLambdaARN":
            return Optional.ofNullable(clazz.cast(rotationLambdaARN()));
        case "RotationRules":
            return Optional.ofNullable(clazz.cast(rotationRules()));
        case "LastRotatedDate":
            return Optional.ofNullable(clazz.cast(lastRotatedDate()));
        case "LastChangedDate":
            return Optional.ofNullable(clazz.cast(lastChangedDate()));
        case "LastAccessedDate":
            return Optional.ofNullable(clazz.cast(lastAccessedDate()));
        case "DeletedDate":
            return Optional.ofNullable(clazz.cast(deletedDate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VersionIdsToStages":
            return Optional.ofNullable(clazz.cast(versionIdsToStages()));
        case "OwningService":
            return Optional.ofNullable(clazz.cast(owningService()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecretResponse, T> g) {
        return obj -> g.apply((DescribeSecretResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSecretResponse> {
        /**
         * <p>
         * The ARN of the secret.
         * </p>
         * 
         * @param arn
         *        The ARN of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The user-provided friendly name of the secret.
         * </p>
         * 
         * @param name
         *        The user-provided friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The user-provided description of the secret.
         * </p>
         * 
         * @param description
         *        The user-provided description of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN or alias of the AWS KMS customer master key (CMK) that's used to encrypt the
         * <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret. If you don't
         * provide a key, then Secrets Manager defaults to encrypting the secret fields with the default AWS KMS CMK
         * (the one named <code>awssecretsmanager</code>) for this account.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN or alias of the AWS KMS customer master key (CMK) that's used to encrypt the
         *        <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret. If you
         *        don't provide a key, then Secrets Manager defaults to encrypting the secret fields with the default
         *        AWS KMS CMK (the one named <code>awssecretsmanager</code>) for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether automatic rotation is enabled for this secret.
         * </p>
         * <p>
         * To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a value
         * greater than 0. To disable rotation, use <a>CancelRotateSecret</a>.
         * </p>
         * 
         * @param rotationEnabled
         *        Specifies whether automatic rotation is enabled for this secret.</p>
         *        <p>
         *        To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a
         *        value greater than 0. To disable rotation, use <a>CancelRotateSecret</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationEnabled(Boolean rotationEnabled);

        /**
         * <p>
         * The ARN of a Lambda function that's invoked by Secrets Manager to rotate the secret either automatically per
         * the schedule or manually by a call to <code>RotateSecret</code>.
         * </p>
         * 
         * @param rotationLambdaARN
         *        The ARN of a Lambda function that's invoked by Secrets Manager to rotate the secret either
         *        automatically per the schedule or manually by a call to <code>RotateSecret</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationLambdaARN(String rotationLambdaARN);

        /**
         * <p>
         * A structure that contains the rotation configuration for this secret.
         * </p>
         * 
         * @param rotationRules
         *        A structure that contains the rotation configuration for this secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationRules(RotationRulesType rotationRules);

        /**
         * <p>
         * A structure that contains the rotation configuration for this secret.
         * </p>
         * This is a convenience that creates an instance of the {@link RotationRulesType.Builder} avoiding the need to
         * create one manually via {@link RotationRulesType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RotationRulesType.Builder#build()} is called immediately and its
         * result is passed to {@link #rotationRules(RotationRulesType)}.
         * 
         * @param rotationRules
         *        a consumer that will call methods on {@link RotationRulesType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rotationRules(RotationRulesType)
         */
        default Builder rotationRules(Consumer<RotationRulesType.Builder> rotationRules) {
            return rotationRules(RotationRulesType.builder().applyMutation(rotationRules).build());
        }

        /**
         * <p>
         * The most recent date and time that the Secrets Manager rotation process was successfully completed. This
         * value is null if the secret has never rotated.
         * </p>
         * 
         * @param lastRotatedDate
         *        The most recent date and time that the Secrets Manager rotation process was successfully completed.
         *        This value is null if the secret has never rotated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRotatedDate(Instant lastRotatedDate);

        /**
         * <p>
         * The last date and time that this secret was modified in any way.
         * </p>
         * 
         * @param lastChangedDate
         *        The last date and time that this secret was modified in any way.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastChangedDate(Instant lastChangedDate);

        /**
         * <p>
         * The last date that this secret was accessed. This value is truncated to midnight of the date and therefore
         * shows only the date, not the time.
         * </p>
         * 
         * @param lastAccessedDate
         *        The last date that this secret was accessed. This value is truncated to midnight of the date and
         *        therefore shows only the date, not the time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedDate(Instant lastAccessedDate);

        /**
         * <p>
         * This value exists if the secret is scheduled for deletion. Some time after the specified date and time,
         * Secrets Manager deletes the secret and all of its versions.
         * </p>
         * <p>
         * If a secret is scheduled for deletion, then its details, including the encrypted secret information, is not
         * accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.
         * </p>
         * 
         * @param deletedDate
         *        This value exists if the secret is scheduled for deletion. Some time after the specified date and
         *        time, Secrets Manager deletes the secret and all of its versions.</p>
         *        <p>
         *        If a secret is scheduled for deletion, then its details, including the encrypted secret information,
         *        is not accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedDate(Instant deletedDate);

        /**
         * <p>
         * The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         * <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * </p>
         * 
         * @param tags
         *        The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         *        <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         * <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * </p>
         * 
         * @param tags
         *        The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         *        <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         * <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A list of all of the currently assigned <code>VersionStage</code> staging labels and the
         * <code>VersionId</code> that each is attached to. Staging labels are used to keep track of the different
         * versions during the rotation process.
         * </p>
         * <note>
         * <p>
         * A version that does not have any staging labels attached is considered deprecated and subject to deletion.
         * Such versions are not included in this list.
         * </p>
         * </note>
         * 
         * @param versionIdsToStages
         *        A list of all of the currently assigned <code>VersionStage</code> staging labels and the
         *        <code>VersionId</code> that each is attached to. Staging labels are used to keep track of the
         *        different versions during the rotation process.</p> <note>
         *        <p>
         *        A version that does not have any staging labels attached is considered deprecated and subject to
         *        deletion. Such versions are not included in this list.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages);

        /**
         * <p>
         * Returns the name of the service that created this secret.
         * </p>
         * 
         * @param owningService
         *        Returns the name of the service that created this secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningService(String owningService);

        /**
         * <p>
         * The date that the secret was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the secret was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String kmsKeyId;

        private Boolean rotationEnabled;

        private String rotationLambdaARN;

        private RotationRulesType rotationRules;

        private Instant lastRotatedDate;

        private Instant lastChangedDate;

        private Instant lastAccessedDate;

        private Instant deletedDate;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> versionIdsToStages = DefaultSdkAutoConstructMap.getInstance();

        private String owningService;

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecretResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            kmsKeyId(model.kmsKeyId);
            rotationEnabled(model.rotationEnabled);
            rotationLambdaARN(model.rotationLambdaARN);
            rotationRules(model.rotationRules);
            lastRotatedDate(model.lastRotatedDate);
            lastChangedDate(model.lastChangedDate);
            lastAccessedDate(model.lastAccessedDate);
            deletedDate(model.deletedDate);
            tags(model.tags);
            versionIdsToStages(model.versionIdsToStages);
            owningService(model.owningService);
            createdDate(model.createdDate);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getRotationEnabled() {
            return rotationEnabled;
        }

        @Override
        public final Builder rotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
            return this;
        }

        public final void setRotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
        }

        public final String getRotationLambdaARN() {
            return rotationLambdaARN;
        }

        @Override
        public final Builder rotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
            return this;
        }

        public final void setRotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
        }

        public final RotationRulesType.Builder getRotationRules() {
            return rotationRules != null ? rotationRules.toBuilder() : null;
        }

        @Override
        public final Builder rotationRules(RotationRulesType rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        public final void setRotationRules(RotationRulesType.BuilderImpl rotationRules) {
            this.rotationRules = rotationRules != null ? rotationRules.build() : null;
        }

        public final Instant getLastRotatedDate() {
            return lastRotatedDate;
        }

        @Override
        public final Builder lastRotatedDate(Instant lastRotatedDate) {
            this.lastRotatedDate = lastRotatedDate;
            return this;
        }

        public final void setLastRotatedDate(Instant lastRotatedDate) {
            this.lastRotatedDate = lastRotatedDate;
        }

        public final Instant getLastChangedDate() {
            return lastChangedDate;
        }

        @Override
        public final Builder lastChangedDate(Instant lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
            return this;
        }

        public final void setLastChangedDate(Instant lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
        }

        public final Instant getLastAccessedDate() {
            return lastAccessedDate;
        }

        @Override
        public final Builder lastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
            return this;
        }

        public final void setLastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
        }

        public final Instant getDeletedDate() {
            return deletedDate;
        }

        @Override
        public final Builder deletedDate(Instant deletedDate) {
            this.deletedDate = deletedDate;
            return this;
        }

        public final void setDeletedDate(Instant deletedDate) {
            this.deletedDate = deletedDate;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListTypeCopier.copyFromBuilder(tags);
        }

        public final Map<String, ? extends Collection<String>> getVersionIdsToStages() {
            return versionIdsToStages;
        }

        @Override
        public final Builder versionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages) {
            this.versionIdsToStages = SecretVersionsToStagesMapTypeCopier.copy(versionIdsToStages);
            return this;
        }

        public final void setVersionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages) {
            this.versionIdsToStages = SecretVersionsToStagesMapTypeCopier.copy(versionIdsToStages);
        }

        public final String getOwningService() {
            return owningService;
        }

        @Override
        public final Builder owningService(String owningService) {
            this.owningService = owningService;
            return this;
        }

        public final void setOwningService(String owningService) {
            this.owningService = owningService;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public DescribeSecretResponse build() {
            return new DescribeSecretResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
