/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(PutResourcePolicyRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePolicy").getter(getter(PutResourcePolicyRequest::resourcePolicy))
            .setter(setter(Builder::resourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()).build();

    private static final SdkField<Boolean> BLOCK_PUBLIC_POLICY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BlockPublicPolicy").getter(getter(PutResourcePolicyRequest::blockPublicPolicy))
            .setter(setter(Builder::blockPublicPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD,
            RESOURCE_POLICY_FIELD, BLOCK_PUBLIC_POLICY_FIELD));

    private final String secretId;

    private final String resourcePolicy;

    private final Boolean blockPublicPolicy;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.resourcePolicy = builder.resourcePolicy;
        this.blockPublicPolicy = builder.blockPublicPolicy;
    }

    /**
     * <p>
     * Specifies the secret that you want to attach the resource-based policy to. You can specify either the ARN or the
     * friendly name of the secret.
     * </p>
     * <note>
     * <p>
     * If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial ARN
     * too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager adds at the
     * end of the ARN when you created the secret. A partial ARN match can work as long as it uniquely matches only one
     * secret. However, if your secret has a name that ends in a hyphen followed by six characters (before Secrets
     * Manager adds the hyphen and six characters to the ARN) and you try to use that as a partial ARN, then those
     * characters cause Secrets Manager to assume that you’re specifying a complete ARN. This confusion can cause
     * unexpected results. To avoid this situation, we recommend that you don’t create secret names ending with a hyphen
     * followed by six characters.
     * </p>
     * <p>
     * If you specify an incomplete ARN without the random suffix, and instead provide the 'friendly name', you
     * <i>must</i> not include the random suffix. If you do include the random suffix added by Secrets Manager, you
     * receive either a <i>ResourceNotFoundException</i> or an <i>AccessDeniedException</i> error, depending on your
     * permissions.
     * </p>
     * </note>
     * 
     * @return Specifies the secret that you want to attach the resource-based policy to. You can specify either the ARN
     *         or the friendly name of the secret.</p> <note>
     *         <p>
     *         If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial
     *         ARN too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager
     *         adds at the end of the ARN when you created the secret. A partial ARN match can work as long as it
     *         uniquely matches only one secret. However, if your secret has a name that ends in a hyphen followed by
     *         six characters (before Secrets Manager adds the hyphen and six characters to the ARN) and you try to use
     *         that as a partial ARN, then those characters cause Secrets Manager to assume that you’re specifying a
     *         complete ARN. This confusion can cause unexpected results. To avoid this situation, we recommend that you
     *         don’t create secret names ending with a hyphen followed by six characters.
     *         </p>
     *         <p>
     *         If you specify an incomplete ARN without the random suffix, and instead provide the 'friendly name', you
     *         <i>must</i> not include the random suffix. If you do include the random suffix added by Secrets Manager,
     *         you receive either a <i>ResourceNotFoundException</i> or an <i>AccessDeniedException</i> error, depending
     *         on your permissions.
     *         </p>
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * A JSON-formatted string that's constructed according to the grammar and syntax for an AWS resource-based policy.
     * The policy in the string identifies who can access or manage this secret and its versions. For information on how
     * to format a JSON parameter for the various command line tool environments, see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for
     * Parameters</a> in the <i>AWS CLI User Guide</i>.
     * </p>
     * 
     * @return A JSON-formatted string that's constructed according to the grammar and syntax for an AWS resource-based
     *         policy. The policy in the string identifies who can access or manage this secret and its versions. For
     *         information on how to format a JSON parameter for the various command line tool environments, see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
     *         JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
     */
    public String resourcePolicy() {
        return resourcePolicy;
    }

    /**
     * <p>
     * Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
     * </p>
     * 
     * @return Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your
     *         secret.
     */
    public Boolean blockPublicPolicy() {
        return blockPublicPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicPolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(resourcePolicy(), other.resourcePolicy())
                && Objects.equals(blockPublicPolicy(), other.blockPublicPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("SecretId", secretId()).add("ResourcePolicy", resourcePolicy())
                .add("BlockPublicPolicy", blockPublicPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        case "BlockPublicPolicy":
            return Optional.ofNullable(clazz.cast(blockPublicPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * Specifies the secret that you want to attach the resource-based policy to. You can specify either the ARN or
         * the friendly name of the secret.
         * </p>
         * <note>
         * <p>
         * If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial ARN
         * too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager adds at
         * the end of the ARN when you created the secret. A partial ARN match can work as long as it uniquely matches
         * only one secret. However, if your secret has a name that ends in a hyphen followed by six characters (before
         * Secrets Manager adds the hyphen and six characters to the ARN) and you try to use that as a partial ARN, then
         * those characters cause Secrets Manager to assume that you’re specifying a complete ARN. This confusion can
         * cause unexpected results. To avoid this situation, we recommend that you don’t create secret names ending
         * with a hyphen followed by six characters.
         * </p>
         * <p>
         * If you specify an incomplete ARN without the random suffix, and instead provide the 'friendly name', you
         * <i>must</i> not include the random suffix. If you do include the random suffix added by Secrets Manager, you
         * receive either a <i>ResourceNotFoundException</i> or an <i>AccessDeniedException</i> error, depending on your
         * permissions.
         * </p>
         * </note>
         * 
         * @param secretId
         *        Specifies the secret that you want to attach the resource-based policy to. You can specify either the
         *        ARN or the friendly name of the secret.</p> <note>
         *        <p>
         *        If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a
         *        partial ARN too—for example, if you don’t include the final hyphen and six random characters that
         *        Secrets Manager adds at the end of the ARN when you created the secret. A partial ARN match can work
         *        as long as it uniquely matches only one secret. However, if your secret has a name that ends in a
         *        hyphen followed by six characters (before Secrets Manager adds the hyphen and six characters to the
         *        ARN) and you try to use that as a partial ARN, then those characters cause Secrets Manager to assume
         *        that you’re specifying a complete ARN. This confusion can cause unexpected results. To avoid this
         *        situation, we recommend that you don’t create secret names ending with a hyphen followed by six
         *        characters.
         *        </p>
         *        <p>
         *        If you specify an incomplete ARN without the random suffix, and instead provide the 'friendly name',
         *        you <i>must</i> not include the random suffix. If you do include the random suffix added by Secrets
         *        Manager, you receive either a <i>ResourceNotFoundException</i> or an <i>AccessDeniedException</i>
         *        error, depending on your permissions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * A JSON-formatted string that's constructed according to the grammar and syntax for an AWS resource-based
         * policy. The policy in the string identifies who can access or manage this secret and its versions. For
         * information on how to format a JSON parameter for the various command line tool environments, see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a> in the <i>AWS CLI User Guide</i>.
         * </p>
         * 
         * @param resourcePolicy
         *        A JSON-formatted string that's constructed according to the grammar and syntax for an AWS
         *        resource-based policy. The policy in the string identifies who can access or manage this secret and
         *        its versions. For information on how to format a JSON parameter for the various command line tool
         *        environments, see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
         *        JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);

        /**
         * <p>
         * Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
         * </p>
         * 
         * @param blockPublicPolicy
         *        Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your
         *        secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicPolicy(Boolean blockPublicPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String resourcePolicy;

        private Boolean blockPublicPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            secretId(model.secretId);
            resourcePolicy(model.resourcePolicy);
            blockPublicPolicy(model.blockPublicPolicy);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        public final Boolean getBlockPublicPolicy() {
            return blockPublicPolicy;
        }

        @Override
        public final Builder blockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        public final void setBlockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
