/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateResourcePolicyResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<ValidateResourcePolicyResponse.Builder, ValidateResourcePolicyResponse> {
    private static final SdkField<Boolean> POLICY_VALIDATION_PASSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PolicyValidationPassed").getter(getter(ValidateResourcePolicyResponse::policyValidationPassed))
            .setter(setter(Builder::policyValidationPassed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyValidationPassed").build())
            .build();

    private static final SdkField<List<ValidationErrorsEntry>> VALIDATION_ERRORS_FIELD = SdkField
            .<List<ValidationErrorsEntry>> builder(MarshallingType.LIST)
            .memberName("ValidationErrors")
            .getter(getter(ValidateResourcePolicyResponse::validationErrors))
            .setter(setter(Builder::validationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationErrorsEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationErrorsEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POLICY_VALIDATION_PASSED_FIELD, VALIDATION_ERRORS_FIELD));

    private final Boolean policyValidationPassed;

    private final List<ValidationErrorsEntry> validationErrors;

    private ValidateResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyValidationPassed = builder.policyValidationPassed;
        this.validationErrors = builder.validationErrors;
    }

    /**
     * <p>
     * Returns a message stating that your Reource Policy passed validation.
     * </p>
     * 
     * @return Returns a message stating that your Reource Policy passed validation.
     */
    public Boolean policyValidationPassed() {
        return policyValidationPassed;
    }

    /**
     * Returns true if the ValidationErrors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValidationErrors() {
        return validationErrors != null && !(validationErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an error message if your policy doesn't pass validatation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns an error message if your policy doesn't pass validatation.
     */
    public List<ValidationErrorsEntry> validationErrors() {
        return validationErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyValidationPassed());
        hashCode = 31 * hashCode + Objects.hashCode(validationErrors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateResourcePolicyResponse)) {
            return false;
        }
        ValidateResourcePolicyResponse other = (ValidateResourcePolicyResponse) obj;
        return Objects.equals(policyValidationPassed(), other.policyValidationPassed())
                && Objects.equals(validationErrors(), other.validationErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ValidateResourcePolicyResponse").add("PolicyValidationPassed", policyValidationPassed())
                .add("ValidationErrors", validationErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyValidationPassed":
            return Optional.ofNullable(clazz.cast(policyValidationPassed()));
        case "ValidationErrors":
            return Optional.ofNullable(clazz.cast(validationErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateResourcePolicyResponse, T> g) {
        return obj -> g.apply((ValidateResourcePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidateResourcePolicyResponse> {
        /**
         * <p>
         * Returns a message stating that your Reource Policy passed validation.
         * </p>
         * 
         * @param policyValidationPassed
         *        Returns a message stating that your Reource Policy passed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyValidationPassed(Boolean policyValidationPassed);

        /**
         * <p>
         * Returns an error message if your policy doesn't pass validatation.
         * </p>
         * 
         * @param validationErrors
         *        Returns an error message if your policy doesn't pass validatation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(Collection<ValidationErrorsEntry> validationErrors);

        /**
         * <p>
         * Returns an error message if your policy doesn't pass validatation.
         * </p>
         * 
         * @param validationErrors
         *        Returns an error message if your policy doesn't pass validatation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(ValidationErrorsEntry... validationErrors);

        /**
         * <p>
         * Returns an error message if your policy doesn't pass validatation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationErrorsEntry>.Builder} avoiding
         * the need to create one manually via {@link List<ValidationErrorsEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationErrorsEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #validationErrors(List<ValidationErrorsEntry>)}.
         * 
         * @param validationErrors
         *        a consumer that will call methods on {@link List<ValidationErrorsEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationErrors(List<ValidationErrorsEntry>)
         */
        Builder validationErrors(Consumer<ValidationErrorsEntry.Builder>... validationErrors);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private Boolean policyValidationPassed;

        private List<ValidationErrorsEntry> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateResourcePolicyResponse model) {
            super(model);
            policyValidationPassed(model.policyValidationPassed);
            validationErrors(model.validationErrors);
        }

        public final Boolean getPolicyValidationPassed() {
            return policyValidationPassed;
        }

        @Override
        public final Builder policyValidationPassed(Boolean policyValidationPassed) {
            this.policyValidationPassed = policyValidationPassed;
            return this;
        }

        public final void setPolicyValidationPassed(Boolean policyValidationPassed) {
            this.policyValidationPassed = policyValidationPassed;
        }

        public final Collection<ValidationErrorsEntry.Builder> getValidationErrors() {
            return validationErrors != null ? validationErrors.stream().map(ValidationErrorsEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationErrorsEntry> validationErrors) {
            this.validationErrors = ValidationErrorsTypeCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationErrorsEntry... validationErrors) {
            validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationErrorsEntry.Builder>... validationErrors) {
            validationErrors(Stream.of(validationErrors).map(c -> ValidationErrorsEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationErrorsEntry.BuilderImpl> validationErrors) {
            this.validationErrors = ValidationErrorsTypeCopier.copyFromBuilder(validationErrors);
        }

        @Override
        public ValidateResourcePolicyResponse build() {
            return new ValidateResourcePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
