/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSecretValueResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<PutSecretValueResponse.Builder, PutSecretValueResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(PutSecretValueResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PutSecretValueResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(PutSecretValueResponse::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<List<String>> VERSION_STAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VersionStages")
            .getter(getter(PutSecretValueResponse::versionStages))
            .setter(setter(Builder::versionStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionStages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            VERSION_ID_FIELD, VERSION_STAGES_FIELD));

    private final String arn;

    private final String name;

    private final String versionId;

    private final List<String> versionStages;

    private PutSecretValueResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.versionId = builder.versionId;
        this.versionStages = builder.versionStages;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the secret for which you just created a version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the secret for which you just created a version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name of the secret for which you just created or updated a version.
     * </p>
     * 
     * @return The friendly name of the secret for which you just created or updated a version.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the version of the secret you just created or updated.
     * </p>
     * 
     * @return The unique identifier of the version of the secret you just created or updated.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * Returns true if the VersionStages property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVersionStages() {
        return versionStages != null && !(versionStages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of staging labels that are currently attached to this version of the secret. Staging labels are used to
     * track a version as it progresses through the secret rotation process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersionStages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of staging labels that are currently attached to this version of the secret. Staging labels are
     *         used to track a version as it progresses through the secret rotation process.
     */
    public final List<String> versionStages() {
        return versionStages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasVersionStages() ? versionStages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSecretValueResponse)) {
            return false;
        }
        PutSecretValueResponse other = (PutSecretValueResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(versionId(), other.versionId()) && hasVersionStages() == other.hasVersionStages()
                && Objects.equals(versionStages(), other.versionStages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSecretValueResponse").add("ARN", arn()).add("Name", name()).add("VersionId", versionId())
                .add("VersionStages", hasVersionStages() ? versionStages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "VersionStages":
            return Optional.ofNullable(clazz.cast(versionStages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSecretValueResponse, T> g) {
        return obj -> g.apply((PutSecretValueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSecretValueResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the secret for which you just created a version.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the secret for which you just created a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name of the secret for which you just created or updated a version.
         * </p>
         * 
         * @param name
         *        The friendly name of the secret for which you just created or updated a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the version of the secret you just created or updated.
         * </p>
         * 
         * @param versionId
         *        The unique identifier of the version of the secret you just created or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The list of staging labels that are currently attached to this version of the secret. Staging labels are used
         * to track a version as it progresses through the secret rotation process.
         * </p>
         * 
         * @param versionStages
         *        The list of staging labels that are currently attached to this version of the secret. Staging labels
         *        are used to track a version as it progresses through the secret rotation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionStages(Collection<String> versionStages);

        /**
         * <p>
         * The list of staging labels that are currently attached to this version of the secret. Staging labels are used
         * to track a version as it progresses through the secret rotation process.
         * </p>
         * 
         * @param versionStages
         *        The list of staging labels that are currently attached to this version of the secret. Staging labels
         *        are used to track a version as it progresses through the secret rotation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionStages(String... versionStages);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String versionId;

        private List<String> versionStages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSecretValueResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            versionId(model.versionId);
            versionStages(model.versionStages);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Collection<String> getVersionStages() {
            if (versionStages instanceof SdkAutoConstructList) {
                return null;
            }
            return versionStages;
        }

        @Override
        public final Builder versionStages(Collection<String> versionStages) {
            this.versionStages = SecretVersionStagesTypeCopier.copy(versionStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionStages(String... versionStages) {
            versionStages(Arrays.asList(versionStages));
            return this;
        }

        public final void setVersionStages(Collection<String> versionStages) {
            this.versionStages = SecretVersionStagesTypeCopier.copy(versionStages);
        }

        @Override
        public PutSecretValueResponse build() {
            return new PutSecretValueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
