/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagResourceRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<TagResourceRequest.Builder, TagResourceRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(TagResourceRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TagResourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD, TAGS_FIELD));

    private final String secretId;

    private final List<Tag> tags;

    private TagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier for the secret that you want to attach tags to. You can specify either the Amazon Resource Name
     * (ARN) or the friendly name of the secret.
     * </p>
     * <note>
     * <p>
     * If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial ARN
     * too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager adds at the
     * end of the ARN when you created the secret. A partial ARN match can work as long as it uniquely matches only one
     * secret. However, if your secret has a name that ends in a hyphen followed by six characters (before Secrets
     * Manager adds the hyphen and six characters to the ARN) and you try to use that as a partial ARN, then those
     * characters cause Secrets Manager to assume that you’re specifying a complete ARN. This confusion can cause
     * unexpected results. To avoid this situation, we recommend that you don’t create secret names ending with a hyphen
     * followed by six characters.
     * </p>
     * <p>
     * If you specify an incomplete ARN without the random suffix, and instead provide the 'friendly name', you
     * <i>must</i> not include the random suffix. If you do include the random suffix added by Secrets Manager, you
     * receive either a <i>ResourceNotFoundException</i> or an <i>AccessDeniedException</i> error, depending on your
     * permissions.
     * </p>
     * </note>
     * 
     * @return The identifier for the secret that you want to attach tags to. You can specify either the Amazon Resource
     *         Name (ARN) or the friendly name of the secret.</p> <note>
     *         <p>
     *         If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial
     *         ARN too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager
     *         adds at the end of the ARN when you created the secret. A partial ARN match can work as long as it
     *         uniquely matches only one secret. However, if your secret has a name that ends in a hyphen followed by
     *         six characters (before Secrets Manager adds the hyphen and six characters to the ARN) and you try to use
     *         that as a partial ARN, then those characters cause Secrets Manager to assume that you’re specifying a
     *         complete ARN. This confusion can cause unexpected results. To avoid this situation, we recommend that you
     *         don’t create secret names ending with a hyphen followed by six characters.
     *         </p>
     *         <p>
     *         If you specify an incomplete ARN without the random suffix, and instead provide the 'friendly name', you
     *         <i>must</i> not include the random suffix. If you do include the random suffix added by Secrets Manager,
     *         you receive either a <i>ResourceNotFoundException</i> or an <i>AccessDeniedException</i> error, depending
     *         on your permissions.
     *         </p>
     */
    public final String secretId() {
        return secretId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
     * <code>Value</code>.
     * </p>
     * <p>
     * This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter
     * for the various command line tool environments, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for
     * Parameters</a> in the <i>CLI User Guide</i>. For the CLI, you can also use the syntax:
     * <code>--Tags Key="Key1",Value="Value1" Key="Key2",Value="Value2"[,…]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
     *         <code>Value</code>.</p>
     *         <p>
     *         This parameter to the API requires a JSON text string argument. For information on how to format a JSON
     *         parameter for the various command line tool environments, see <a
     *         href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
     *         JSON for Parameters</a> in the <i>CLI User Guide</i>. For the CLI, you can also use the syntax:
     *         <code>--Tags Key="Key1",Value="Value1" Key="Key2",Value="Value2"[,…]</code>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagResourceRequest").add("SecretId", secretId()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagResourceRequest, T> g) {
        return obj -> g.apply((TagResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, TagResourceRequest> {
        /**
         * <p>
         * The identifier for the secret that you want to attach tags to. You can specify either the Amazon Resource
         * Name (ARN) or the friendly name of the secret.
         * </p>
         * <note>
         * <p>
         * If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial ARN
         * too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager adds at
         * the end of the ARN when you created the secret. A partial ARN match can work as long as it uniquely matches
         * only one secret. However, if your secret has a name that ends in a hyphen followed by six characters (before
         * Secrets Manager adds the hyphen and six characters to the ARN) and you try to use that as a partial ARN, then
         * those characters cause Secrets Manager to assume that you’re specifying a complete ARN. This confusion can
         * cause unexpected results. To avoid this situation, we recommend that you don’t create secret names ending
         * with a hyphen followed by six characters.
         * </p>
         * <p>
         * If you specify an incomplete ARN without the random suffix, and instead provide the 'friendly name', you
         * <i>must</i> not include the random suffix. If you do include the random suffix added by Secrets Manager, you
         * receive either a <i>ResourceNotFoundException</i> or an <i>AccessDeniedException</i> error, depending on your
         * permissions.
         * </p>
         * </note>
         * 
         * @param secretId
         *        The identifier for the secret that you want to attach tags to. You can specify either the Amazon
         *        Resource Name (ARN) or the friendly name of the secret.</p> <note>
         *        <p>
         *        If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a
         *        partial ARN too—for example, if you don’t include the final hyphen and six random characters that
         *        Secrets Manager adds at the end of the ARN when you created the secret. A partial ARN match can work
         *        as long as it uniquely matches only one secret. However, if your secret has a name that ends in a
         *        hyphen followed by six characters (before Secrets Manager adds the hyphen and six characters to the
         *        ARN) and you try to use that as a partial ARN, then those characters cause Secrets Manager to assume
         *        that you’re specifying a complete ARN. This confusion can cause unexpected results. To avoid this
         *        situation, we recommend that you don’t create secret names ending with a hyphen followed by six
         *        characters.
         *        </p>
         *        <p>
         *        If you specify an incomplete ARN without the random suffix, and instead provide the 'friendly name',
         *        you <i>must</i> not include the random suffix. If you do include the random suffix added by Secrets
         *        Manager, you receive either a <i>ResourceNotFoundException</i> or an <i>AccessDeniedException</i>
         *        error, depending on your permissions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         * <code>Value</code>.
         * </p>
         * <p>
         * This parameter to the API requires a JSON text string argument. For information on how to format a JSON
         * parameter for the various command line tool environments, see <a
         * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a> in the <i>CLI User Guide</i>. For the CLI, you can also use the syntax:
         * <code>--Tags Key="Key1",Value="Value1" Key="Key2",Value="Value2"[,…]</code>
         * </p>
         * 
         * @param tags
         *        The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         *        <code>Value</code>.</p>
         *        <p>
         *        This parameter to the API requires a JSON text string argument. For information on how to format a
         *        JSON parameter for the various command line tool environments, see <a
         *        href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json"
         *        >Using JSON for Parameters</a> in the <i>CLI User Guide</i>. For the CLI, you can also use the syntax:
         *        <code>--Tags Key="Key1",Value="Value1" Key="Key2",Value="Value2"[,…]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         * <code>Value</code>.
         * </p>
         * <p>
         * This parameter to the API requires a JSON text string argument. For information on how to format a JSON
         * parameter for the various command line tool environments, see <a
         * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a> in the <i>CLI User Guide</i>. For the CLI, you can also use the syntax:
         * <code>--Tags Key="Key1",Value="Value1" Key="Key2",Value="Value2"[,…]</code>
         * </p>
         * 
         * @param tags
         *        The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         *        <code>Value</code>.</p>
         *        <p>
         *        This parameter to the API requires a JSON text string argument. For information on how to format a
         *        JSON parameter for the various command line tool environments, see <a
         *        href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json"
         *        >Using JSON for Parameters</a> in the <i>CLI User Guide</i>. For the CLI, you can also use the syntax:
         *        <code>--Tags Key="Key1",Value="Value1" Key="Key2",Value="Value2"[,…]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a
         * <code>Value</code>.
         * </p>
         * <p>
         * This parameter to the API requires a JSON text string argument. For information on how to format a JSON
         * parameter for the various command line tool environments, see <a
         * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a> in the <i>CLI User Guide</i>. For the CLI, you can also use the syntax:
         * <code>--Tags Key="Key1",Value="Value1" Key="Key2",Value="Value2"[,…]</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagResourceRequest model) {
            super(model);
            secretId(model.secretId);
            tags(model.tags);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TagResourceRequest build() {
            return new TagResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
