/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSecretResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<CreateSecretResponse.Builder, CreateSecretResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(CreateSecretResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateSecretResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(CreateSecretResponse::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<List<ReplicationStatusType>> REPLICATION_STATUS_FIELD = SdkField
            .<List<ReplicationStatusType>> builder(MarshallingType.LIST)
            .memberName("ReplicationStatus")
            .getter(getter(CreateSecretResponse::replicationStatus))
            .setter(setter(Builder::replicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationStatusType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationStatusType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            VERSION_ID_FIELD, REPLICATION_STATUS_FIELD));

    private final String arn;

    private final String name;

    private final String versionId;

    private final List<ReplicationStatusType> replicationStatus;

    private CreateSecretResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.versionId = builder.versionId;
        this.replicationStatus = builder.replicationStatus;
    }

    /**
     * <p>
     * The ARN of the new secret. The ARN includes the name of the secret followed by six random characters. This
     * ensures that if you create a new secret with the same name as a deleted secret, then users with access to the old
     * secret don't get access to the new secret because the ARNs are different.
     * </p>
     * 
     * @return The ARN of the new secret. The ARN includes the name of the secret followed by six random characters.
     *         This ensures that if you create a new secret with the same name as a deleted secret, then users with
     *         access to the old secret don't get access to the new secret because the ARNs are different.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the new secret.
     * </p>
     * 
     * @return The name of the new secret.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier associated with the version of the new secret.
     * </p>
     * 
     * @return The unique identifier associated with the version of the new secret.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationStatus property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationStatus() {
        return replicationStatus != null && !(replicationStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the replicas of this secret and their status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Failed</code>, which indicates that the replica was not created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InSync</code>, which indicates that the replica was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationStatus} method.
     * </p>
     * 
     * @return A list of the replicas of this secret and their status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Failed</code>, which indicates that the replica was not created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InSync</code>, which indicates that the replica was created.
     *         </p>
     *         </li>
     */
    public final List<ReplicationStatusType> replicationStatus() {
        return replicationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationStatus() ? replicationStatus() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecretResponse)) {
            return false;
        }
        CreateSecretResponse other = (CreateSecretResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(versionId(), other.versionId()) && hasReplicationStatus() == other.hasReplicationStatus()
                && Objects.equals(replicationStatus(), other.replicationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSecretResponse").add("ARN", arn()).add("Name", name()).add("VersionId", versionId())
                .add("ReplicationStatus", hasReplicationStatus() ? replicationStatus() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "ReplicationStatus":
            return Optional.ofNullable(clazz.cast(replicationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSecretResponse, T> g) {
        return obj -> g.apply((CreateSecretResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSecretResponse> {
        /**
         * <p>
         * The ARN of the new secret. The ARN includes the name of the secret followed by six random characters. This
         * ensures that if you create a new secret with the same name as a deleted secret, then users with access to the
         * old secret don't get access to the new secret because the ARNs are different.
         * </p>
         * 
         * @param arn
         *        The ARN of the new secret. The ARN includes the name of the secret followed by six random characters.
         *        This ensures that if you create a new secret with the same name as a deleted secret, then users with
         *        access to the old secret don't get access to the new secret because the ARNs are different.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the new secret.
         * </p>
         * 
         * @param name
         *        The name of the new secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier associated with the version of the new secret.
         * </p>
         * 
         * @param versionId
         *        The unique identifier associated with the version of the new secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * A list of the replicas of this secret and their status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Failed</code>, which indicates that the replica was not created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InSync</code>, which indicates that the replica was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationStatus
         *        A list of the replicas of this secret and their status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Failed</code>, which indicates that the replica was not created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the
         *        replica.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InSync</code>, which indicates that the replica was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatus(Collection<ReplicationStatusType> replicationStatus);

        /**
         * <p>
         * A list of the replicas of this secret and their status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Failed</code>, which indicates that the replica was not created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InSync</code>, which indicates that the replica was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationStatus
         *        A list of the replicas of this secret and their status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Failed</code>, which indicates that the replica was not created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the
         *        replica.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InSync</code>, which indicates that the replica was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatus(ReplicationStatusType... replicationStatus);

        /**
         * <p>
         * A list of the replicas of this secret and their status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Failed</code>, which indicates that the replica was not created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InSync</code>, which indicates that the replica was created.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link List<ReplicationStatusType>.Builder}
         * avoiding the need to create one manually via {@link List<ReplicationStatusType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationStatusType>.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationStatus(List<ReplicationStatusType>)}.
         * 
         * @param replicationStatus
         *        a consumer that will call methods on {@link List<ReplicationStatusType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationStatus(List<ReplicationStatusType>)
         */
        Builder replicationStatus(Consumer<ReplicationStatusType.Builder>... replicationStatus);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String versionId;

        private List<ReplicationStatusType> replicationStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecretResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            versionId(model.versionId);
            replicationStatus(model.replicationStatus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        @Transient
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final List<ReplicationStatusType.Builder> getReplicationStatus() {
            List<ReplicationStatusType.Builder> result = ReplicationStatusListTypeCopier.copyToBuilder(this.replicationStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatus(Collection<ReplicationStatusType.BuilderImpl> replicationStatus) {
            this.replicationStatus = ReplicationStatusListTypeCopier.copyFromBuilder(replicationStatus);
        }

        @Override
        @Transient
        public final Builder replicationStatus(Collection<ReplicationStatusType> replicationStatus) {
            this.replicationStatus = ReplicationStatusListTypeCopier.copy(replicationStatus);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationStatus(ReplicationStatusType... replicationStatus) {
            replicationStatus(Arrays.asList(replicationStatus));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationStatus(Consumer<ReplicationStatusType.Builder>... replicationStatus) {
            replicationStatus(Stream.of(replicationStatus).map(c -> ReplicationStatusType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateSecretResponse build() {
            return new CreateSecretResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
