/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecretVersionIdsResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<ListSecretVersionIdsResponse.Builder, ListSecretVersionIdsResponse> {
    private static final SdkField<List<SecretVersionsListEntry>> VERSIONS_FIELD = SdkField
            .<List<SecretVersionsListEntry>> builder(MarshallingType.LIST)
            .memberName("Versions")
            .getter(getter(ListSecretVersionIdsResponse::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecretVersionsListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecretVersionsListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSecretVersionIdsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(ListSecretVersionIdsResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListSecretVersionIdsResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSIONS_FIELD,
            NEXT_TOKEN_FIELD, ARN_FIELD, NAME_FIELD));

    private final List<SecretVersionsListEntry> versions;

    private final String nextToken;

    private final String arn;

    private final String name;

    private ListSecretVersionIdsResponse(BuilderImpl builder) {
        super(builder);
        this.versions = builder.versions;
        this.nextToken = builder.nextToken;
        this.arn = builder.arn;
        this.name = builder.name;
    }

    /**
     * Returns true if the Versions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the currently available versions of the specified secret.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of the currently available versions of the specified secret.
     */
    public final List<SecretVersionsListEntry> versions() {
        return versions;
    }

    /**
     * <p>
     * If present in the response, this value indicates that there's more output available than included in the current
     * response. This can occur even when the response includes no values at all, such as when you ask for a filtered
     * view of a very long list. Use this value in the <code>NextToken</code> request parameter in a subsequent call to
     * the operation to continue processing and get the next part of the output. You should repeat this until the
     * <code>NextToken</code> response element comes back empty (as <code>null</code>).
     * </p>
     * 
     * @return If present in the response, this value indicates that there's more output available than included in the
     *         current response. This can occur even when the response includes no values at all, such as when you ask
     *         for a filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter
     *         in a subsequent call to the operation to continue processing and get the next part of the output. You
     *         should repeat this until the <code>NextToken</code> response element comes back empty (as
     *         <code>null</code>).
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the secret.
     * </p>
     * <note>
     * <p>
     * Secrets Manager automatically adds several random characters to the name at the end of the ARN when you initially
     * create a secret. This affects only the ARN and not the actual friendly name. This ensures that if you create a
     * new secret with the same name as an old secret that you previously deleted, then users with access to the old
     * secret <i>don't</i> automatically get access to the new secret because the ARNs are different.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) for the secret.</p> <note>
     *         <p>
     *         Secrets Manager automatically adds several random characters to the name at the end of the ARN when you
     *         initially create a secret. This affects only the ARN and not the actual friendly name. This ensures that
     *         if you create a new secret with the same name as an old secret that you previously deleted, then users
     *         with access to the old secret <i>don't</i> automatically get access to the new secret because the ARNs
     *         are different.
     *         </p>
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name of the secret.
     * </p>
     * 
     * @return The friendly name of the secret.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVersions() ? versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretVersionIdsResponse)) {
            return false;
        }
        ListSecretVersionIdsResponse other = (ListSecretVersionIdsResponse) obj;
        return hasVersions() == other.hasVersions() && Objects.equals(versions(), other.versions())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSecretVersionIdsResponse").add("Versions", hasVersions() ? versions() : null)
                .add("NextToken", nextToken()).add("ARN", arn()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecretVersionIdsResponse, T> g) {
        return obj -> g.apply((ListSecretVersionIdsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSecretVersionIdsResponse> {
        /**
         * <p>
         * The list of the currently available versions of the specified secret.
         * </p>
         * 
         * @param versions
         *        The list of the currently available versions of the specified secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<SecretVersionsListEntry> versions);

        /**
         * <p>
         * The list of the currently available versions of the specified secret.
         * </p>
         * 
         * @param versions
         *        The list of the currently available versions of the specified secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(SecretVersionsListEntry... versions);

        /**
         * <p>
         * The list of the currently available versions of the specified secret.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecretVersionsListEntry>.Builder} avoiding
         * the need to create one manually via {@link List<SecretVersionsListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecretVersionsListEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #versions(List<SecretVersionsListEntry>)}.
         * 
         * @param versions
         *        a consumer that will call methods on {@link List<SecretVersionsListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versions(List<SecretVersionsListEntry>)
         */
        Builder versions(Consumer<SecretVersionsListEntry.Builder>... versions);

        /**
         * <p>
         * If present in the response, this value indicates that there's more output available than included in the
         * current response. This can occur even when the response includes no values at all, such as when you ask for a
         * filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a
         * subsequent call to the operation to continue processing and get the next part of the output. You should
         * repeat this until the <code>NextToken</code> response element comes back empty (as <code>null</code>).
         * </p>
         * 
         * @param nextToken
         *        If present in the response, this value indicates that there's more output available than included in
         *        the current response. This can occur even when the response includes no values at all, such as when
         *        you ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request
         *        parameter in a subsequent call to the operation to continue processing and get the next part of the
         *        output. You should repeat this until the <code>NextToken</code> response element comes back empty (as
         *        <code>null</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the secret.
         * </p>
         * <note>
         * <p>
         * Secrets Manager automatically adds several random characters to the name at the end of the ARN when you
         * initially create a secret. This affects only the ARN and not the actual friendly name. This ensures that if
         * you create a new secret with the same name as an old secret that you previously deleted, then users with
         * access to the old secret <i>don't</i> automatically get access to the new secret because the ARNs are
         * different.
         * </p>
         * </note>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the secret.</p> <note>
         *        <p>
         *        Secrets Manager automatically adds several random characters to the name at the end of the ARN when
         *        you initially create a secret. This affects only the ARN and not the actual friendly name. This
         *        ensures that if you create a new secret with the same name as an old secret that you previously
         *        deleted, then users with access to the old secret <i>don't</i> automatically get access to the new
         *        secret because the ARNs are different.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name of the secret.
         * </p>
         * 
         * @param name
         *        The friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private List<SecretVersionsListEntry> versions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String arn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecretVersionIdsResponse model) {
            super(model);
            versions(model.versions);
            nextToken(model.nextToken);
            arn(model.arn);
            name(model.name);
        }

        public final List<SecretVersionsListEntry.Builder> getVersions() {
            List<SecretVersionsListEntry.Builder> result = SecretVersionsListTypeCopier.copyToBuilder(this.versions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVersions(Collection<SecretVersionsListEntry.BuilderImpl> versions) {
            this.versions = SecretVersionsListTypeCopier.copyFromBuilder(versions);
        }

        @Override
        @Transient
        public final Builder versions(Collection<SecretVersionsListEntry> versions) {
            this.versions = SecretVersionsListTypeCopier.copy(versions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(SecretVersionsListEntry... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(Consumer<SecretVersionsListEntry.Builder>... versions) {
            versions(Stream.of(versions).map(c -> SecretVersionsListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ListSecretVersionIdsResponse build() {
            return new ListSecretVersionIdsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
