/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines the rotation configuration for the secret.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotationRulesType implements SdkPojo, Serializable,
        ToCopyableBuilder<RotationRulesType.Builder, RotationRulesType> {
    private static final SdkField<Long> AUTOMATICALLY_AFTER_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AutomaticallyAfterDays").getter(getter(RotationRulesType::automaticallyAfterDays))
            .setter(setter(Builder::automaticallyAfterDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticallyAfterDays").build())
            .build();

    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Duration").getter(getter(RotationRulesType::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(RotationRulesType::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATICALLY_AFTER_DAYS_FIELD, DURATION_FIELD, SCHEDULE_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long automaticallyAfterDays;

    private final String duration;

    private final String scheduleExpression;

    private RotationRulesType(BuilderImpl builder) {
        this.automaticallyAfterDays = builder.automaticallyAfterDays;
        this.duration = builder.duration;
        this.scheduleExpression = builder.scheduleExpression;
    }

    /**
     * <p>
     * The number of days between automatic scheduled rotations of the secret. You can use this value to check that your
     * secret meets your compliance guidelines for how often secrets must be rotated.
     * </p>
     * <p>
     * In <code>DescribeSecret</code> and <code>ListSecrets</code>, this value is calculated from the rotation schedule
     * after every successful rotation. In <code>RotateSecret</code>, you can set the rotation schedule in
     * <code>RotationRules</code> with <code>AutomaticallyAfterDays</code> or <code>ScheduleExpression</code>, but not
     * both. To set a rotation schedule in hours, use <code>ScheduleExpression</code>.
     * </p>
     * 
     * @return The number of days between automatic scheduled rotations of the secret. You can use this value to check
     *         that your secret meets your compliance guidelines for how often secrets must be rotated.</p>
     *         <p>
     *         In <code>DescribeSecret</code> and <code>ListSecrets</code>, this value is calculated from the rotation
     *         schedule after every successful rotation. In <code>RotateSecret</code>, you can set the rotation schedule
     *         in <code>RotationRules</code> with <code>AutomaticallyAfterDays</code> or <code>ScheduleExpression</code>
     *         , but not both. To set a rotation schedule in hours, use <code>ScheduleExpression</code>.
     */
    public final Long automaticallyAfterDays() {
        return automaticallyAfterDays;
    }

    /**
     * <p>
     * The length of the rotation window in hours, for example <code>3h</code> for a three hour window. Secrets Manager
     * rotates your secret at any time during this window. The window must not extend into the next rotation window or
     * the next UTC day. The window starts according to the <code>ScheduleExpression</code>. If you don't specify a
     * <code>Duration</code>, for a <code>ScheduleExpression</code> in hours, the window automatically closes after one
     * hour. For a <code>ScheduleExpression</code> in days, the window automatically closes at the end of the UTC day.
     * For more information, including examples, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule
     * expressions in Secrets Manager rotation</a> in the <i>Secrets Manager Users Guide</i>.
     * </p>
     * 
     * @return The length of the rotation window in hours, for example <code>3h</code> for a three hour window. Secrets
     *         Manager rotates your secret at any time during this window. The window must not extend into the next
     *         rotation window or the next UTC day. The window starts according to the <code>ScheduleExpression</code>.
     *         If you don't specify a <code>Duration</code>, for a <code>ScheduleExpression</code> in hours, the window
     *         automatically closes after one hour. For a <code>ScheduleExpression</code> in days, the window
     *         automatically closes at the end of the UTC day. For more information, including examples, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule
     *         expressions in Secrets Manager rotation</a> in the <i>Secrets Manager Users Guide</i>.
     */
    public final String duration() {
        return duration;
    }

    /**
     * <p>
     * A <code>cron()</code> or <code>rate()</code> expression that defines the schedule for rotating your secret.
     * Secrets Manager rotation schedules use UTC time zone. Secrets Manager rotates your secret any time during a
     * rotation window.
     * </p>
     * <p>
     * Secrets Manager <code>rate()</code> expressions represent the interval in hours or days that you want to rotate
     * your secret, for example <code>rate(12 hours)</code> or <code>rate(10 days)</code>. You can rotate a secret as
     * often as every four hours. If you use a <code>rate()</code> expression, the rotation window starts at midnight.
     * For a rate in hours, the default rotation window closes after one hour. For a rate in days, the default rotation
     * window closes at the end of the day. You can set the <code>Duration</code> to change the rotation window. The
     * rotation window must not extend into the next UTC day or into the next rotation window.
     * </p>
     * <p>
     * You can use a <code>cron()</code> expression to create a rotation schedule that is more detailed than a rotation
     * interval. For more information, including examples, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule
     * expressions in Secrets Manager rotation</a> in the <i>Secrets Manager Users Guide</i>. For a cron expression that
     * represents a schedule in hours, the default rotation window closes after one hour. For a cron expression that
     * represents a schedule in days, the default rotation window closes at the end of the day. You can set the
     * <code>Duration</code> to change the rotation window. The rotation window must not extend into the next UTC day or
     * into the next rotation window.
     * </p>
     * 
     * @return A <code>cron()</code> or <code>rate()</code> expression that defines the schedule for rotating your
     *         secret. Secrets Manager rotation schedules use UTC time zone. Secrets Manager rotates your secret any
     *         time during a rotation window.</p>
     *         <p>
     *         Secrets Manager <code>rate()</code> expressions represent the interval in hours or days that you want to
     *         rotate your secret, for example <code>rate(12 hours)</code> or <code>rate(10 days)</code>. You can rotate
     *         a secret as often as every four hours. If you use a <code>rate()</code> expression, the rotation window
     *         starts at midnight. For a rate in hours, the default rotation window closes after one hour. For a rate in
     *         days, the default rotation window closes at the end of the day. You can set the <code>Duration</code> to
     *         change the rotation window. The rotation window must not extend into the next UTC day or into the next
     *         rotation window.
     *         </p>
     *         <p>
     *         You can use a <code>cron()</code> expression to create a rotation schedule that is more detailed than a
     *         rotation interval. For more information, including examples, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule
     *         expressions in Secrets Manager rotation</a> in the <i>Secrets Manager Users Guide</i>. For a cron
     *         expression that represents a schedule in hours, the default rotation window closes after one hour. For a
     *         cron expression that represents a schedule in days, the default rotation window closes at the end of the
     *         day. You can set the <code>Duration</code> to change the rotation window. The rotation window must not
     *         extend into the next UTC day or into the next rotation window.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticallyAfterDays());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationRulesType)) {
            return false;
        }
        RotationRulesType other = (RotationRulesType) obj;
        return Objects.equals(automaticallyAfterDays(), other.automaticallyAfterDays())
                && Objects.equals(duration(), other.duration())
                && Objects.equals(scheduleExpression(), other.scheduleExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RotationRulesType").add("AutomaticallyAfterDays", automaticallyAfterDays())
                .add("Duration", duration()).add("ScheduleExpression", scheduleExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticallyAfterDays":
            return Optional.ofNullable(clazz.cast(automaticallyAfterDays()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RotationRulesType, T> g) {
        return obj -> g.apply((RotationRulesType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RotationRulesType> {
        /**
         * <p>
         * The number of days between automatic scheduled rotations of the secret. You can use this value to check that
         * your secret meets your compliance guidelines for how often secrets must be rotated.
         * </p>
         * <p>
         * In <code>DescribeSecret</code> and <code>ListSecrets</code>, this value is calculated from the rotation
         * schedule after every successful rotation. In <code>RotateSecret</code>, you can set the rotation schedule in
         * <code>RotationRules</code> with <code>AutomaticallyAfterDays</code> or <code>ScheduleExpression</code>, but
         * not both. To set a rotation schedule in hours, use <code>ScheduleExpression</code>.
         * </p>
         * 
         * @param automaticallyAfterDays
         *        The number of days between automatic scheduled rotations of the secret. You can use this value to
         *        check that your secret meets your compliance guidelines for how often secrets must be rotated.</p>
         *        <p>
         *        In <code>DescribeSecret</code> and <code>ListSecrets</code>, this value is calculated from the
         *        rotation schedule after every successful rotation. In <code>RotateSecret</code>, you can set the
         *        rotation schedule in <code>RotationRules</code> with <code>AutomaticallyAfterDays</code> or
         *        <code>ScheduleExpression</code>, but not both. To set a rotation schedule in hours, use
         *        <code>ScheduleExpression</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticallyAfterDays(Long automaticallyAfterDays);

        /**
         * <p>
         * The length of the rotation window in hours, for example <code>3h</code> for a three hour window. Secrets
         * Manager rotates your secret at any time during this window. The window must not extend into the next rotation
         * window or the next UTC day. The window starts according to the <code>ScheduleExpression</code>. If you don't
         * specify a <code>Duration</code>, for a <code>ScheduleExpression</code> in hours, the window automatically
         * closes after one hour. For a <code>ScheduleExpression</code> in days, the window automatically closes at the
         * end of the UTC day. For more information, including examples, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule
         * expressions in Secrets Manager rotation</a> in the <i>Secrets Manager Users Guide</i>.
         * </p>
         * 
         * @param duration
         *        The length of the rotation window in hours, for example <code>3h</code> for a three hour window.
         *        Secrets Manager rotates your secret at any time during this window. The window must not extend into
         *        the next rotation window or the next UTC day. The window starts according to the
         *        <code>ScheduleExpression</code>. If you don't specify a <code>Duration</code>, for a
         *        <code>ScheduleExpression</code> in hours, the window automatically closes after one hour. For a
         *        <code>ScheduleExpression</code> in days, the window automatically closes at the end of the UTC day.
         *        For more information, including examples, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html"
         *        >Schedule expressions in Secrets Manager rotation</a> in the <i>Secrets Manager Users Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);

        /**
         * <p>
         * A <code>cron()</code> or <code>rate()</code> expression that defines the schedule for rotating your secret.
         * Secrets Manager rotation schedules use UTC time zone. Secrets Manager rotates your secret any time during a
         * rotation window.
         * </p>
         * <p>
         * Secrets Manager <code>rate()</code> expressions represent the interval in hours or days that you want to
         * rotate your secret, for example <code>rate(12 hours)</code> or <code>rate(10 days)</code>. You can rotate a
         * secret as often as every four hours. If you use a <code>rate()</code> expression, the rotation window starts
         * at midnight. For a rate in hours, the default rotation window closes after one hour. For a rate in days, the
         * default rotation window closes at the end of the day. You can set the <code>Duration</code> to change the
         * rotation window. The rotation window must not extend into the next UTC day or into the next rotation window.
         * </p>
         * <p>
         * You can use a <code>cron()</code> expression to create a rotation schedule that is more detailed than a
         * rotation interval. For more information, including examples, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule
         * expressions in Secrets Manager rotation</a> in the <i>Secrets Manager Users Guide</i>. For a cron expression
         * that represents a schedule in hours, the default rotation window closes after one hour. For a cron expression
         * that represents a schedule in days, the default rotation window closes at the end of the day. You can set the
         * <code>Duration</code> to change the rotation window. The rotation window must not extend into the next UTC
         * day or into the next rotation window.
         * </p>
         * 
         * @param scheduleExpression
         *        A <code>cron()</code> or <code>rate()</code> expression that defines the schedule for rotating your
         *        secret. Secrets Manager rotation schedules use UTC time zone. Secrets Manager rotates your secret any
         *        time during a rotation window.</p>
         *        <p>
         *        Secrets Manager <code>rate()</code> expressions represent the interval in hours or days that you want
         *        to rotate your secret, for example <code>rate(12 hours)</code> or <code>rate(10 days)</code>. You can
         *        rotate a secret as often as every four hours. If you use a <code>rate()</code> expression, the
         *        rotation window starts at midnight. For a rate in hours, the default rotation window closes after one
         *        hour. For a rate in days, the default rotation window closes at the end of the day. You can set the
         *        <code>Duration</code> to change the rotation window. The rotation window must not extend into the next
         *        UTC day or into the next rotation window.
         *        </p>
         *        <p>
         *        You can use a <code>cron()</code> expression to create a rotation schedule that is more detailed than
         *        a rotation interval. For more information, including examples, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html"
         *        >Schedule expressions in Secrets Manager rotation</a> in the <i>Secrets Manager Users Guide</i>. For a
         *        cron expression that represents a schedule in hours, the default rotation window closes after one
         *        hour. For a cron expression that represents a schedule in days, the default rotation window closes at
         *        the end of the day. You can set the <code>Duration</code> to change the rotation window. The rotation
         *        window must not extend into the next UTC day or into the next rotation window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);
    }

    static final class BuilderImpl implements Builder {
        private Long automaticallyAfterDays;

        private String duration;

        private String scheduleExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationRulesType model) {
            automaticallyAfterDays(model.automaticallyAfterDays);
            duration(model.duration);
            scheduleExpression(model.scheduleExpression);
        }

        public final Long getAutomaticallyAfterDays() {
            return automaticallyAfterDays;
        }

        public final void setAutomaticallyAfterDays(Long automaticallyAfterDays) {
            this.automaticallyAfterDays = automaticallyAfterDays;
        }

        @Override
        public final Builder automaticallyAfterDays(Long automaticallyAfterDays) {
            this.automaticallyAfterDays = automaticallyAfterDays;
            return this;
        }

        public final String getDuration() {
            return duration;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        @Override
        public RotationRulesType build() {
            return new RotationRulesType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
