/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.CancelRotateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.CancelRotateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.DecryptionFailureException;
import software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DescribeSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.EncryptionFailureException;
import software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordResponse;
import software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.InternalServiceErrorException;
import software.amazon.awssdk.services.secretsmanager.model.InvalidNextTokenException;
import software.amazon.awssdk.services.secretsmanager.model.InvalidParameterException;
import software.amazon.awssdk.services.secretsmanager.model.InvalidRequestException;
import software.amazon.awssdk.services.secretsmanager.model.LimitExceededException;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse;
import software.amazon.awssdk.services.secretsmanager.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.secretsmanager.model.PreconditionNotMetException;
import software.amazon.awssdk.services.secretsmanager.model.PublicPolicyException;
import software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationRequest;
import software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationResponse;
import software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceExistsException;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.RestoreSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.RotateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;
import software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaRequest;
import software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaResponse;
import software.amazon.awssdk.services.secretsmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.secretsmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.secretsmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.secretsmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageRequest;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageResponse;
import software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyRequest;
import software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyResponse;
import software.amazon.awssdk.services.secretsmanager.paginators.BatchGetSecretValueIterable;
import software.amazon.awssdk.services.secretsmanager.paginators.ListSecretVersionIdsIterable;
import software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable;

/**
 * Service client for accessing AWS Secrets Manager. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Web Services Secrets Manager</fullname>
 * <p>
 * Amazon Web Services Secrets Manager provides a service to enable you to store, manage, and retrieve, secrets.
 * </p>
 * <p>
 * This guide provides descriptions of the Secrets Manager API. For more information about using this service, see the
 * <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/introduction.html">Amazon Web Services Secrets
 * Manager User Guide</a>.
 * </p>
 * <p>
 * <b>API Version</b>
 * </p>
 * <p>
 * This version of the Secrets Manager API Reference documents the Secrets Manager API version 2017-10-17.
 * </p>
 * <p>
 * For a list of endpoints, see <a
 * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/asm_access.html#endpoints">Amazon Web Services
 * Secrets Manager endpoints</a>.
 * </p>
 * <p>
 * <b>Support and Feedback for Amazon Web Services Secrets Manager</b>
 * </p>
 * <p>
 * We welcome your feedback. Send your comments to <a
 * href="mailto:awssecretsmanager-feedback@amazon.com">awssecretsmanager-feedback@amazon.com</a>, or post your feedback
 * and questions in the <a href="http://forums.aws.amazon.com/forum.jspa?forumID=296">Amazon Web Services Secrets
 * Manager Discussion Forum</a>. For more information about the Amazon Web Services Discussion Forums, see <a
 * href="http://forums.aws.amazon.com/help.jspa">Forums Help</a>.
 * </p>
 * <p>
 * <b>Logging API Requests</b>
 * </p>
 * <p>
 * Amazon Web Services Secrets Manager supports Amazon Web Services CloudTrail, a service that records Amazon Web
 * Services API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. By using
 * information that's collected by Amazon Web Services CloudTrail, you can determine the requests successfully made to
 * Secrets Manager, who made the request, when it was made, and so on. For more about Amazon Web Services Secrets
 * Manager and support for Amazon Web Services CloudTrail, see <a
 * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/monitoring.html#monitoring_cloudtrail">Logging
 * Amazon Web Services Secrets Manager Events with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services
 * Secrets Manager User Guide</i>. To learn more about CloudTrail, including enabling it and find your log files, see
 * the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">Amazon
 * Web Services CloudTrail User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SecretsManagerClient extends AwsClient {
    String SERVICE_NAME = "secretsmanager";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "secretsmanager";

    /**
     * <p>
     * Retrieves the contents of the encrypted fields <code>SecretString</code> or <code>SecretBinary</code> for up to
     * 20 secrets. To retrieve a single secret, call <a>GetSecretValue</a>.
     * </p>
     * <p>
     * To choose which secrets to retrieve, you can specify a list of secrets by name or ARN, or you can use filters. If
     * Secrets Manager encounters errors such as <code>AccessDeniedException</code> while attempting to retrieve any of
     * the secrets, you can see the errors in <code>Errors</code> in the response.
     * </p>
     * <p>
     * Secrets Manager generates CloudTrail <code>GetSecretValue</code> log entries for each secret you request when you
     * call this action. Do not include sensitive information in request parameters because it might be logged. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:BatchGetSecretValue</code>, and you must have
     * <code>secretsmanager:GetSecretValue</code> for each secret. If you use filters, you must also have
     * <code>secretsmanager:ListSecrets</code>. If the secrets are encrypted using customer-managed keys instead of the
     * Amazon Web Services managed key <code>aws/secretsmanager</code>, then you also need <code>kms:Decrypt</code>
     * permissions for the keys. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param batchGetSecretValueRequest
     * @return Result of the BatchGetSecretValue operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.BatchGetSecretValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/BatchGetSecretValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetSecretValueResponse batchGetSecretValue(BatchGetSecretValueRequest batchGetSecretValueRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, DecryptionFailureException,
            InternalServiceErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the contents of the encrypted fields <code>SecretString</code> or <code>SecretBinary</code> for up to
     * 20 secrets. To retrieve a single secret, call <a>GetSecretValue</a>.
     * </p>
     * <p>
     * To choose which secrets to retrieve, you can specify a list of secrets by name or ARN, or you can use filters. If
     * Secrets Manager encounters errors such as <code>AccessDeniedException</code> while attempting to retrieve any of
     * the secrets, you can see the errors in <code>Errors</code> in the response.
     * </p>
     * <p>
     * Secrets Manager generates CloudTrail <code>GetSecretValue</code> log entries for each secret you request when you
     * call this action. Do not include sensitive information in request parameters because it might be logged. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:BatchGetSecretValue</code>, and you must have
     * <code>secretsmanager:GetSecretValue</code> for each secret. If you use filters, you must also have
     * <code>secretsmanager:ListSecrets</code>. If the secrets are encrypted using customer-managed keys instead of the
     * Amazon Web Services managed key <code>aws/secretsmanager</code>, then you also need <code>kms:Decrypt</code>
     * permissions for the keys. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetSecretValueRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetSecretValueRequest#builder()}
     * </p>
     *
     * @param batchGetSecretValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest.Builder} to create
     *        a request.
     * @return Result of the BatchGetSecretValue operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.BatchGetSecretValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/BatchGetSecretValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetSecretValueResponse batchGetSecretValue(
            Consumer<BatchGetSecretValueRequest.Builder> batchGetSecretValueRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, DecryptionFailureException, InternalServiceErrorException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SecretsManagerException {
        return batchGetSecretValue(BatchGetSecretValueRequest.builder().applyMutation(batchGetSecretValueRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #batchGetSecretValue(software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.BatchGetSecretValueIterable responses = client.batchGetSecretValuePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.secretsmanager.paginators.BatchGetSecretValueIterable responses = client
     *             .batchGetSecretValuePaginator(request);
     *     for (software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.BatchGetSecretValueIterable responses = client.batchGetSecretValuePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetSecretValue(software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest)}
     * operation.</b>
     * </p>
     *
     * @param batchGetSecretValueRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.BatchGetSecretValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/BatchGetSecretValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetSecretValueIterable batchGetSecretValuePaginator(BatchGetSecretValueRequest batchGetSecretValueRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, DecryptionFailureException,
            InternalServiceErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        return new BatchGetSecretValueIterable(this, batchGetSecretValueRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #batchGetSecretValue(software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.BatchGetSecretValueIterable responses = client.batchGetSecretValuePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.secretsmanager.paginators.BatchGetSecretValueIterable responses = client
     *             .batchGetSecretValuePaginator(request);
     *     for (software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.BatchGetSecretValueIterable responses = client.batchGetSecretValuePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetSecretValue(software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetSecretValueRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetSecretValueRequest#builder()}
     * </p>
     *
     * @param batchGetSecretValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.BatchGetSecretValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/BatchGetSecretValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetSecretValueIterable batchGetSecretValuePaginator(
            Consumer<BatchGetSecretValueRequest.Builder> batchGetSecretValueRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, DecryptionFailureException, InternalServiceErrorException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SecretsManagerException {
        return batchGetSecretValuePaginator(BatchGetSecretValueRequest.builder().applyMutation(batchGetSecretValueRequest)
                .build());
    }

    /**
     * <p>
     * Turns off automatic rotation, and if a rotation is currently in progress, cancels the rotation.
     * </p>
     * <p>
     * If you cancel a rotation in progress, it can leave the <code>VersionStage</code> labels in an unexpected state.
     * You might need to remove the staging label <code>AWSPENDING</code> from the partially created version. You also
     * need to determine whether to roll back to the previous version of the secret by moving the staging label
     * <code>AWSCURRENT</code> to the version that has <code>AWSPENDING</code>. To determine which version has a
     * specific staging label, call <a>ListSecretVersionIds</a>. Then use <a>UpdateSecretVersionStage</a> to change
     * staging labels. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation
     * works</a>.
     * </p>
     * <p>
     * To turn on automatic rotation again, call <a>RotateSecret</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:CancelRotateSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param cancelRotateSecretRequest
     * @return Result of the CancelRotateSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.CancelRotateSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CancelRotateSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelRotateSecretResponse cancelRotateSecret(CancelRotateSecretRequest cancelRotateSecretRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, InvalidRequestException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Turns off automatic rotation, and if a rotation is currently in progress, cancels the rotation.
     * </p>
     * <p>
     * If you cancel a rotation in progress, it can leave the <code>VersionStage</code> labels in an unexpected state.
     * You might need to remove the staging label <code>AWSPENDING</code> from the partially created version. You also
     * need to determine whether to roll back to the previous version of the secret by moving the staging label
     * <code>AWSCURRENT</code> to the version that has <code>AWSPENDING</code>. To determine which version has a
     * specific staging label, call <a>ListSecretVersionIds</a>. Then use <a>UpdateSecretVersionStage</a> to change
     * staging labels. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation
     * works</a>.
     * </p>
     * <p>
     * To turn on automatic rotation again, call <a>RotateSecret</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:CancelRotateSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelRotateSecretRequest.Builder} avoiding the
     * need to create one manually via {@link CancelRotateSecretRequest#builder()}
     * </p>
     *
     * @param cancelRotateSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.CancelRotateSecretRequest.Builder} to create a
     *        request.
     * @return Result of the CancelRotateSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.CancelRotateSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CancelRotateSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelRotateSecretResponse cancelRotateSecret(Consumer<CancelRotateSecretRequest.Builder> cancelRotateSecretRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, InvalidRequestException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return cancelRotateSecret(CancelRotateSecretRequest.builder().applyMutation(cancelRotateSecretRequest).build());
    }

    /**
     * <p>
     * Creates a new secret. A <i>secret</i> can be a password, a set of credentials such as a user name and password,
     * an OAuth token, or other secret information that you store in an encrypted form in Secrets Manager. The secret
     * also includes the connection information to access a database or other service, which Secrets Manager doesn't
     * encrypt. A secret in Secrets Manager consists of both the protected secret data and the important information
     * needed to manage the secret.
     * </p>
     * <p>
     * For secrets that use <i>managed rotation</i>, you need to create the secret through the managing service. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets Manager
     * secrets managed by other Amazon Web Services services</a>.
     * </p>
     * <p>
     * For information about creating a secret in the console, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_create-basic-secret.html">Create a
     * secret</a>.
     * </p>
     * <p>
     * To create a secret, you can provide the secret value to be encrypted in either the <code>SecretString</code>
     * parameter or the <code>SecretBinary</code> parameter, but not both. If you include <code>SecretString</code> or
     * <code>SecretBinary</code> then Secrets Manager creates an initial secret version and automatically attaches the
     * staging label <code>AWSCURRENT</code> to it.
     * </p>
     * <p>
     * For database credentials you want to rotate, for Secrets Manager to be able to rotate the secret, you must make
     * sure the JSON you store in the <code>SecretString</code> matches the <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_secret_json_structure.html">JSON
     * structure of a database secret</a>.
     * </p>
     * <p>
     * If you don't specify an KMS encryption key, Secrets Manager uses the Amazon Web Services managed key
     * <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager creates
     * it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use
     * <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result in a one-time significant
     * delay in returning the result.
     * </p>
     * <p>
     * If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't
     * use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS
     * key.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters except <code>SecretBinary</code> or <code>SecretString</code> because it might be logged.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:CreateSecret</code>. If you include tags in the secret, you
     * also need <code>secretsmanager:TagResource</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <p>
     * To encrypt the secret with a KMS key other than <code>aws/secretsmanager</code>, you need
     * <code>kms:GenerateDataKey</code> and <code>kms:Decrypt</code> permission to the key.
     * </p>
     *
     * @param createSecretRequest
     * @return Result of the CreateSecret operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         The request failed because it would exceed one of the Secrets Manager quotas.
     * @throws EncryptionFailureException
     *         Secrets Manager can't encrypt the protected secret text using the provided KMS key. Check that the KMS
     *         key is available, enabled, and not in an invalid state. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
     *         key</a>.
     * @throws ResourceExistsException
     *         A resource with the ID you requested already exists.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws MalformedPolicyDocumentException
     *         The resource policy has syntax errors.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws PreconditionNotMetException
     *         The request failed because you did not complete all the prerequisite steps.
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.CreateSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSecretResponse createSecret(CreateSecretRequest createSecretRequest) throws InvalidParameterException,
            InvalidRequestException, LimitExceededException, EncryptionFailureException, ResourceExistsException,
            ResourceNotFoundException, MalformedPolicyDocumentException, InternalServiceErrorException,
            PreconditionNotMetException, DecryptionFailureException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new secret. A <i>secret</i> can be a password, a set of credentials such as a user name and password,
     * an OAuth token, or other secret information that you store in an encrypted form in Secrets Manager. The secret
     * also includes the connection information to access a database or other service, which Secrets Manager doesn't
     * encrypt. A secret in Secrets Manager consists of both the protected secret data and the important information
     * needed to manage the secret.
     * </p>
     * <p>
     * For secrets that use <i>managed rotation</i>, you need to create the secret through the managing service. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets Manager
     * secrets managed by other Amazon Web Services services</a>.
     * </p>
     * <p>
     * For information about creating a secret in the console, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_create-basic-secret.html">Create a
     * secret</a>.
     * </p>
     * <p>
     * To create a secret, you can provide the secret value to be encrypted in either the <code>SecretString</code>
     * parameter or the <code>SecretBinary</code> parameter, but not both. If you include <code>SecretString</code> or
     * <code>SecretBinary</code> then Secrets Manager creates an initial secret version and automatically attaches the
     * staging label <code>AWSCURRENT</code> to it.
     * </p>
     * <p>
     * For database credentials you want to rotate, for Secrets Manager to be able to rotate the secret, you must make
     * sure the JSON you store in the <code>SecretString</code> matches the <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_secret_json_structure.html">JSON
     * structure of a database secret</a>.
     * </p>
     * <p>
     * If you don't specify an KMS encryption key, Secrets Manager uses the Amazon Web Services managed key
     * <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager creates
     * it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use
     * <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result in a one-time significant
     * delay in returning the result.
     * </p>
     * <p>
     * If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't
     * use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS
     * key.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters except <code>SecretBinary</code> or <code>SecretString</code> because it might be logged.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:CreateSecret</code>. If you include tags in the secret, you
     * also need <code>secretsmanager:TagResource</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <p>
     * To encrypt the secret with a KMS key other than <code>aws/secretsmanager</code>, you need
     * <code>kms:GenerateDataKey</code> and <code>kms:Decrypt</code> permission to the key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecretRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSecretRequest#builder()}
     * </p>
     *
     * @param createSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSecret operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         The request failed because it would exceed one of the Secrets Manager quotas.
     * @throws EncryptionFailureException
     *         Secrets Manager can't encrypt the protected secret text using the provided KMS key. Check that the KMS
     *         key is available, enabled, and not in an invalid state. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
     *         key</a>.
     * @throws ResourceExistsException
     *         A resource with the ID you requested already exists.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws MalformedPolicyDocumentException
     *         The resource policy has syntax errors.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws PreconditionNotMetException
     *         The request failed because you did not complete all the prerequisite steps.
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.CreateSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSecretResponse createSecret(Consumer<CreateSecretRequest.Builder> createSecretRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, EncryptionFailureException,
            ResourceExistsException, ResourceNotFoundException, MalformedPolicyDocumentException, InternalServiceErrorException,
            PreconditionNotMetException, DecryptionFailureException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        return createSecret(CreateSecretRequest.builder().applyMutation(createSecretRequest).build());
    }

    /**
     * <p>
     * Deletes the resource-based permission policy attached to the secret. To attach a policy to a secret, use
     * <a>PutResourcePolicy</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:DeleteResourcePolicy</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ResourceNotFoundException, InternalServiceErrorException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource-based permission policy attached to the secret. To attach a policy to a secret, use
     * <a>PutResourcePolicy</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:DeleteResourcePolicy</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws ResourceNotFoundException,
            InternalServiceErrorException, InvalidRequestException, InvalidParameterException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a secret and all of its versions. You can specify a recovery window during which you can restore the
     * secret. The minimum recovery window is 7 days. The default recovery window is 30 days. Secrets Manager attaches a
     * <code>DeletionDate</code> stamp to the secret that specifies the end of the recovery window. At the end of the
     * recovery window, Secrets Manager deletes the secret permanently.
     * </p>
     * <p>
     * You can't delete a primary secret that is replicated to other Regions. You must first delete the replicas using
     * <a>RemoveRegionsFromReplication</a>, and then delete the primary secret. When you delete a replica, it is deleted
     * immediately.
     * </p>
     * <p>
     * You can't directly delete a version of a secret. Instead, you remove all staging labels from the version using
     * <a>UpdateSecretVersionStage</a>. This marks the version as deprecated, and then Secrets Manager can automatically
     * delete the version in the background.
     * </p>
     * <p>
     * To determine whether an application still uses a secret, you can create an Amazon CloudWatch alarm to alert you
     * to any attempts to access a secret during the recovery window. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/monitoring_cloudwatch_deleted-secrets.html">
     * Monitor secrets scheduled for deletion</a>.
     * </p>
     * <p>
     * Secrets Manager performs the permanent secret deletion at the end of the waiting period as a background task with
     * low priority. There is no guarantee of a specific time after the recovery window for the permanent delete to
     * occur.
     * </p>
     * <p>
     * At any time before recovery window ends, you can use <a>RestoreSecret</a> to remove the <code>DeletionDate</code>
     * and cancel the deletion of the secret.
     * </p>
     * <p>
     * When a secret is scheduled for deletion, you cannot retrieve the secret value. You must first cancel the deletion
     * with <a>RestoreSecret</a> and then you can retrieve the secret.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:DeleteSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param deleteSecretRequest
     * @return Result of the DeleteSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.DeleteSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSecretResponse deleteSecret(DeleteSecretRequest deleteSecretRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a secret and all of its versions. You can specify a recovery window during which you can restore the
     * secret. The minimum recovery window is 7 days. The default recovery window is 30 days. Secrets Manager attaches a
     * <code>DeletionDate</code> stamp to the secret that specifies the end of the recovery window. At the end of the
     * recovery window, Secrets Manager deletes the secret permanently.
     * </p>
     * <p>
     * You can't delete a primary secret that is replicated to other Regions. You must first delete the replicas using
     * <a>RemoveRegionsFromReplication</a>, and then delete the primary secret. When you delete a replica, it is deleted
     * immediately.
     * </p>
     * <p>
     * You can't directly delete a version of a secret. Instead, you remove all staging labels from the version using
     * <a>UpdateSecretVersionStage</a>. This marks the version as deprecated, and then Secrets Manager can automatically
     * delete the version in the background.
     * </p>
     * <p>
     * To determine whether an application still uses a secret, you can create an Amazon CloudWatch alarm to alert you
     * to any attempts to access a secret during the recovery window. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/monitoring_cloudwatch_deleted-secrets.html">
     * Monitor secrets scheduled for deletion</a>.
     * </p>
     * <p>
     * Secrets Manager performs the permanent secret deletion at the end of the waiting period as a background task with
     * low priority. There is no guarantee of a specific time after the recovery window for the permanent delete to
     * occur.
     * </p>
     * <p>
     * At any time before recovery window ends, you can use <a>RestoreSecret</a> to remove the <code>DeletionDate</code>
     * and cancel the deletion of the secret.
     * </p>
     * <p>
     * When a secret is scheduled for deletion, you cannot retrieve the secret value. You must first cancel the deletion
     * with <a>RestoreSecret</a> and then you can retrieve the secret.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:DeleteSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecretRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSecretRequest#builder()}
     * </p>
     *
     * @param deleteSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.DeleteSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSecretResponse deleteSecret(Consumer<DeleteSecretRequest.Builder> deleteSecretRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return deleteSecret(DeleteSecretRequest.builder().applyMutation(deleteSecretRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a secret. It does not include the encrypted secret value. Secrets Manager only returns
     * fields that have a value in the response.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:DescribeSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param describeSecretRequest
     * @return Result of the DescribeSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.DescribeSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DescribeSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSecretResponse describeSecret(DescribeSecretRequest describeSecretRequest) throws ResourceNotFoundException,
            InternalServiceErrorException, InvalidParameterException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a secret. It does not include the encrypted secret value. Secrets Manager only returns
     * fields that have a value in the response.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:DescribeSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecretRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSecretRequest#builder()}
     * </p>
     *
     * @param describeSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.DescribeSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DescribeSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSecretResponse describeSecret(Consumer<DescribeSecretRequest.Builder> describeSecretRequest)
            throws ResourceNotFoundException, InternalServiceErrorException, InvalidParameterException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return describeSecret(DescribeSecretRequest.builder().applyMutation(describeSecretRequest).build());
    }

    /**
     * <p>
     * Generates a random password. We recommend that you specify the maximum length and include every character type
     * that the system you are generating a password for can support. By default, Secrets Manager uses uppercase and
     * lowercase letters, numbers, and the following characters in passwords:
     * <code>!\"#&#36%&amp;'()*+,-./:;&lt;=&gt;?@[\\]^_`{|}~</code>
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:GetRandomPassword</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param getRandomPasswordRequest
     * @return Result of the GetRandomPassword operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.GetRandomPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetRandomPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRandomPasswordResponse getRandomPassword(GetRandomPasswordRequest getRandomPasswordRequest)
            throws InvalidParameterException, InvalidRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a random password. We recommend that you specify the maximum length and include every character type
     * that the system you are generating a password for can support. By default, Secrets Manager uses uppercase and
     * lowercase letters, numbers, and the following characters in passwords:
     * <code>!\"#&#36%&amp;'()*+,-./:;&lt;=&gt;?@[\\]^_`{|}~</code>
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:GetRandomPassword</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRandomPasswordRequest.Builder} avoiding the need
     * to create one manually via {@link GetRandomPasswordRequest#builder()}
     * </p>
     *
     * @param getRandomPasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest.Builder} to create a
     *        request.
     * @return Result of the GetRandomPassword operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.GetRandomPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetRandomPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRandomPasswordResponse getRandomPassword(Consumer<GetRandomPasswordRequest.Builder> getRandomPasswordRequest)
            throws InvalidParameterException, InvalidRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return getRandomPassword(GetRandomPasswordRequest.builder().applyMutation(getRandomPasswordRequest).build());
    }

    /**
     * <p>
     * Generates a random password. We recommend that you specify the maximum length and include every character type
     * that the system you are generating a password for can support. By default, Secrets Manager uses uppercase and
     * lowercase letters, numbers, and the following characters in passwords:
     * <code>!\"#&#36%&amp;'()*+,-./:;&lt;=&gt;?@[\\]^_`{|}~</code>
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:GetRandomPassword</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @return Result of the GetRandomPassword operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.GetRandomPassword
     * @see #getRandomPassword(GetRandomPasswordRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetRandomPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRandomPasswordResponse getRandomPassword() throws InvalidParameterException, InvalidRequestException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, SecretsManagerException {
        return getRandomPassword(GetRandomPasswordRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the secret. For more information about
     * permissions policies attached to a secret, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-policies.html"
     * >Permissions policies attached to a secret</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:GetResourcePolicy</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws ResourceNotFoundException, InternalServiceErrorException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the secret. For more information about
     * permissions policies attached to a secret, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-policies.html"
     * >Permissions policies attached to a secret</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:GetResourcePolicy</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws ResourceNotFoundException, InternalServiceErrorException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the contents of the encrypted fields <code>SecretString</code> or <code>SecretBinary</code> from the
     * specified version of a secret, whichever contains content.
     * </p>
     * <p>
     * To retrieve the values for a group of secrets, call <a>BatchGetSecretValue</a>.
     * </p>
     * <p>
     * We recommend that you cache your secret values by using client-side caching. Caching secrets improves speed and
     * reduces your costs. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets.html">Cache secrets for your
     * applications</a>.
     * </p>
     * <p>
     * To retrieve the previous version of a secret, use <code>VersionStage</code> and specify AWSPREVIOUS. To revert to
     * the previous version of a secret, call <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/secretsmanager/update-secret-version-stage.html"
     * >UpdateSecretVersionStage</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:GetSecretValue</code>. If the secret is encrypted using a
     * customer-managed key instead of the Amazon Web Services managed key <code>aws/secretsmanager</code>, then you
     * also need <code>kms:Decrypt</code> permissions for that key. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param getSecretValueRequest
     * @return Result of the GetSecretValue operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.GetSecretValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetSecretValue" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSecretValueResponse getSecretValue(GetSecretValueRequest getSecretValueRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, DecryptionFailureException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the contents of the encrypted fields <code>SecretString</code> or <code>SecretBinary</code> from the
     * specified version of a secret, whichever contains content.
     * </p>
     * <p>
     * To retrieve the values for a group of secrets, call <a>BatchGetSecretValue</a>.
     * </p>
     * <p>
     * We recommend that you cache your secret values by using client-side caching. Caching secrets improves speed and
     * reduces your costs. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets.html">Cache secrets for your
     * applications</a>.
     * </p>
     * <p>
     * To retrieve the previous version of a secret, use <code>VersionStage</code> and specify AWSPREVIOUS. To revert to
     * the previous version of a secret, call <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/secretsmanager/update-secret-version-stage.html"
     * >UpdateSecretVersionStage</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:GetSecretValue</code>. If the secret is encrypted using a
     * customer-managed key instead of the Amazon Web Services managed key <code>aws/secretsmanager</code>, then you
     * also need <code>kms:Decrypt</code> permissions for that key. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecretValueRequest.Builder} avoiding the need to
     * create one manually via {@link GetSecretValueRequest#builder()}
     * </p>
     *
     * @param getSecretValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest.Builder} to create a
     *        request.
     * @return Result of the GetSecretValue operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.GetSecretValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetSecretValue" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSecretValueResponse getSecretValue(Consumer<GetSecretValueRequest.Builder> getSecretValueRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, DecryptionFailureException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, SecretsManagerException {
        return getSecretValue(GetSecretValueRequest.builder().applyMutation(getSecretValueRequest).build());
    }

    /**
     * <p>
     * Lists the versions of a secret. Secrets Manager uses staging labels to indicate the different versions of a
     * secret. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version"> Secrets
     * Manager concepts: Versions</a>.
     * </p>
     * <p>
     * To list the secrets in the account, use <a>ListSecrets</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ListSecretVersionIds</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param listSecretVersionIdsRequest
     * @return Result of the ListSecretVersionIds operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecretVersionIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecretVersionIds"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecretVersionIdsResponse listSecretVersionIds(ListSecretVersionIdsRequest listSecretVersionIdsRequest)
            throws InvalidNextTokenException, ResourceNotFoundException, InternalServiceErrorException,
            InvalidParameterException, AwsServiceException, SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of a secret. Secrets Manager uses staging labels to indicate the different versions of a
     * secret. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version"> Secrets
     * Manager concepts: Versions</a>.
     * </p>
     * <p>
     * To list the secrets in the account, use <a>ListSecrets</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ListSecretVersionIds</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecretVersionIdsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecretVersionIdsRequest#builder()}
     * </p>
     *
     * @param listSecretVersionIdsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest.Builder} to create
     *        a request.
     * @return Result of the ListSecretVersionIds operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecretVersionIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecretVersionIds"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecretVersionIdsResponse listSecretVersionIds(
            Consumer<ListSecretVersionIdsRequest.Builder> listSecretVersionIdsRequest) throws InvalidNextTokenException,
            ResourceNotFoundException, InternalServiceErrorException, InvalidParameterException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return listSecretVersionIds(ListSecretVersionIdsRequest.builder().applyMutation(listSecretVersionIdsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecretVersionIds(software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretVersionIdsIterable responses = client.listSecretVersionIdsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.secretsmanager.paginators.ListSecretVersionIdsIterable responses = client
     *             .listSecretVersionIdsPaginator(request);
     *     for (software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretVersionIdsIterable responses = client.listSecretVersionIdsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecretVersionIds(software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecretVersionIdsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecretVersionIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecretVersionIds"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecretVersionIdsIterable listSecretVersionIdsPaginator(ListSecretVersionIdsRequest listSecretVersionIdsRequest)
            throws InvalidNextTokenException, ResourceNotFoundException, InternalServiceErrorException,
            InvalidParameterException, AwsServiceException, SdkClientException, SecretsManagerException {
        return new ListSecretVersionIdsIterable(this, listSecretVersionIdsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecretVersionIds(software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretVersionIdsIterable responses = client.listSecretVersionIdsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.secretsmanager.paginators.ListSecretVersionIdsIterable responses = client
     *             .listSecretVersionIdsPaginator(request);
     *     for (software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretVersionIdsIterable responses = client.listSecretVersionIdsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecretVersionIds(software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecretVersionIdsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecretVersionIdsRequest#builder()}
     * </p>
     *
     * @param listSecretVersionIdsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecretVersionIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecretVersionIds"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecretVersionIdsIterable listSecretVersionIdsPaginator(
            Consumer<ListSecretVersionIdsRequest.Builder> listSecretVersionIdsRequest) throws InvalidNextTokenException,
            ResourceNotFoundException, InternalServiceErrorException, InvalidParameterException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return listSecretVersionIdsPaginator(ListSecretVersionIdsRequest.builder().applyMutation(listSecretVersionIdsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the secrets that are stored by Secrets Manager in the Amazon Web Services account, not including secrets
     * that are marked for deletion. To see secrets marked for deletion, use the Secrets Manager console.
     * </p>
     * <p>
     * ListSecrets is eventually consistent, however it might not reflect changes from the last five minutes. To get the
     * latest information for a specific secret, use <a>DescribeSecret</a>.
     * </p>
     * <p>
     * To list the versions of a secret, use <a>ListSecretVersionIds</a>.
     * </p>
     * <p>
     * To retrieve the values for the secrets, call <a>BatchGetSecretValue</a> or <a>GetSecretValue</a>.
     * </p>
     * <p>
     * For information about finding secrets in the console, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_search-secret.html">Find secrets in
     * Secrets Manager</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ListSecrets</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param listSecretsRequest
     * @return Result of the ListSecrets operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecretsResponse listSecrets(ListSecretsRequest listSecretsRequest) throws InvalidParameterException,
            InvalidRequestException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the secrets that are stored by Secrets Manager in the Amazon Web Services account, not including secrets
     * that are marked for deletion. To see secrets marked for deletion, use the Secrets Manager console.
     * </p>
     * <p>
     * ListSecrets is eventually consistent, however it might not reflect changes from the last five minutes. To get the
     * latest information for a specific secret, use <a>DescribeSecret</a>.
     * </p>
     * <p>
     * To list the versions of a secret, use <a>ListSecretVersionIds</a>.
     * </p>
     * <p>
     * To retrieve the values for the secrets, call <a>BatchGetSecretValue</a> or <a>GetSecretValue</a>.
     * </p>
     * <p>
     * For information about finding secrets in the console, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_search-secret.html">Find secrets in
     * Secrets Manager</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ListSecrets</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecretsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSecretsRequest#builder()}
     * </p>
     *
     * @param listSecretsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSecrets operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecretsResponse listSecrets(Consumer<ListSecretsRequest.Builder> listSecretsRequest)
            throws InvalidParameterException, InvalidRequestException, InvalidNextTokenException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return listSecrets(ListSecretsRequest.builder().applyMutation(listSecretsRequest).build());
    }

    /**
     * <p>
     * Lists the secrets that are stored by Secrets Manager in the Amazon Web Services account, not including secrets
     * that are marked for deletion. To see secrets marked for deletion, use the Secrets Manager console.
     * </p>
     * <p>
     * ListSecrets is eventually consistent, however it might not reflect changes from the last five minutes. To get the
     * latest information for a specific secret, use <a>DescribeSecret</a>.
     * </p>
     * <p>
     * To list the versions of a secret, use <a>ListSecretVersionIds</a>.
     * </p>
     * <p>
     * To retrieve the values for the secrets, call <a>BatchGetSecretValue</a> or <a>GetSecretValue</a>.
     * </p>
     * <p>
     * For information about finding secrets in the console, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_search-secret.html">Find secrets in
     * Secrets Manager</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ListSecrets</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @return Result of the ListSecrets operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecrets
     * @see #listSecrets(ListSecretsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecretsResponse listSecrets() throws InvalidParameterException, InvalidRequestException,
            InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        return listSecrets(ListSecretsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecrets(software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client.listSecretsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client
     *             .listSecretsPaginator(request);
     *     for (software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client.listSecretsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecrets(software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecrets
     * @see #listSecretsPaginator(ListSecretsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecretsIterable listSecretsPaginator() throws InvalidParameterException, InvalidRequestException,
            InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        return listSecretsPaginator(ListSecretsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecrets(software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client.listSecretsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client
     *             .listSecretsPaginator(request);
     *     for (software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client.listSecretsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecrets(software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest)} operation.</b>
     * </p>
     *
     * @param listSecretsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecretsIterable listSecretsPaginator(ListSecretsRequest listSecretsRequest) throws InvalidParameterException,
            InvalidRequestException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return new ListSecretsIterable(this, listSecretsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecrets(software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client.listSecretsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client
     *             .listSecretsPaginator(request);
     *     for (software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.secretsmanager.paginators.ListSecretsIterable responses = client.listSecretsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecrets(software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecretsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSecretsRequest#builder()}
     * </p>
     *
     * @param listSecretsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ListSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecretsIterable listSecretsPaginator(Consumer<ListSecretsRequest.Builder> listSecretsRequest)
            throws InvalidParameterException, InvalidRequestException, InvalidNextTokenException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return listSecretsPaginator(ListSecretsRequest.builder().applyMutation(listSecretsRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a secret. A resource-based policy is optional. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control for Secrets Manager</a>
     * </p>
     * <p>
     * For information about attaching a policy in the console, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html"
     * >Attach a permissions policy to a secret</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:PutResourcePolicy</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws MalformedPolicyDocumentException
     *         The resource policy has syntax errors.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws PublicPolicyException
     *         The <code>BlockPublicPolicy</code> parameter is set to true, and the resource policy did not prevent
     *         broad access to the secret.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws MalformedPolicyDocumentException, ResourceNotFoundException, InvalidParameterException,
            InternalServiceErrorException, InvalidRequestException, PublicPolicyException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a secret. A resource-based policy is optional. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control for Secrets Manager</a>
     * </p>
     * <p>
     * For information about attaching a policy in the console, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html"
     * >Attach a permissions policy to a secret</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:PutResourcePolicy</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws MalformedPolicyDocumentException
     *         The resource policy has syntax errors.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws PublicPolicyException
     *         The <code>BlockPublicPolicy</code> parameter is set to true, and the resource policy did not prevent
     *         broad access to the secret.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws MalformedPolicyDocumentException, ResourceNotFoundException, InvalidParameterException,
            InternalServiceErrorException, InvalidRequestException, PublicPolicyException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new version with a new encrypted secret value and attaches it to the secret. The version can contain a
     * new <code>SecretString</code> value or a new <code>SecretBinary</code> value.
     * </p>
     * <p>
     * We recommend you avoid calling <code>PutSecretValue</code> at a sustained rate of more than once every 10
     * minutes. When you update the secret value, Secrets Manager creates a new version of the secret. Secrets Manager
     * removes outdated versions when there are more than 100, but it does not remove versions created less than 24
     * hours ago. If you call <code>PutSecretValue</code> more than once every 10 minutes, you create more versions than
     * Secrets Manager removes, and you will reach the quota for secret versions.
     * </p>
     * <p>
     * You can specify the staging labels to attach to the new version in <code>VersionStages</code>. If you don't
     * include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label
     * <code>AWSCURRENT</code> to this version. If this operation creates the first version for the secret, then Secrets
     * Manager automatically attaches the staging label <code>AWSCURRENT</code> to it. If this operation moves the
     * staging label <code>AWSCURRENT</code> from another version to this version, then Secrets Manager also
     * automatically moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was
     * removed from.
     * </p>
     * <p>
     * This operation is idempotent. If you call this operation with a <code>ClientRequestToken</code> that matches an
     * existing version's VersionId, and you specify the same secret data, the operation succeeds but does nothing.
     * However, if the secret data is different, then the operation fails because you can't modify an existing version;
     * you can only create new ones.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters except <code>SecretBinary</code> or <code>SecretString</code> because it might be logged.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:PutSecretValue</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param putSecretValueRequest
     * @return Result of the PutSecretValue operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         The request failed because it would exceed one of the Secrets Manager quotas.
     * @throws EncryptionFailureException
     *         Secrets Manager can't encrypt the protected secret text using the provided KMS key. Check that the KMS
     *         key is available, enabled, and not in an invalid state. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
     *         key</a>.
     * @throws ResourceExistsException
     *         A resource with the ID you requested already exists.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.PutSecretValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutSecretValue" target="_top">AWS
     *      API Documentation</a>
     */
    default PutSecretValueResponse putSecretValue(PutSecretValueRequest putSecretValueRequest) throws InvalidParameterException,
            InvalidRequestException, LimitExceededException, EncryptionFailureException, ResourceExistsException,
            ResourceNotFoundException, InternalServiceErrorException, DecryptionFailureException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version with a new encrypted secret value and attaches it to the secret. The version can contain a
     * new <code>SecretString</code> value or a new <code>SecretBinary</code> value.
     * </p>
     * <p>
     * We recommend you avoid calling <code>PutSecretValue</code> at a sustained rate of more than once every 10
     * minutes. When you update the secret value, Secrets Manager creates a new version of the secret. Secrets Manager
     * removes outdated versions when there are more than 100, but it does not remove versions created less than 24
     * hours ago. If you call <code>PutSecretValue</code> more than once every 10 minutes, you create more versions than
     * Secrets Manager removes, and you will reach the quota for secret versions.
     * </p>
     * <p>
     * You can specify the staging labels to attach to the new version in <code>VersionStages</code>. If you don't
     * include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label
     * <code>AWSCURRENT</code> to this version. If this operation creates the first version for the secret, then Secrets
     * Manager automatically attaches the staging label <code>AWSCURRENT</code> to it. If this operation moves the
     * staging label <code>AWSCURRENT</code> from another version to this version, then Secrets Manager also
     * automatically moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was
     * removed from.
     * </p>
     * <p>
     * This operation is idempotent. If you call this operation with a <code>ClientRequestToken</code> that matches an
     * existing version's VersionId, and you specify the same secret data, the operation succeeds but does nothing.
     * However, if the secret data is different, then the operation fails because you can't modify an existing version;
     * you can only create new ones.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters except <code>SecretBinary</code> or <code>SecretString</code> because it might be logged.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:PutSecretValue</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSecretValueRequest.Builder} avoiding the need to
     * create one manually via {@link PutSecretValueRequest#builder()}
     * </p>
     *
     * @param putSecretValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest.Builder} to create a
     *        request.
     * @return Result of the PutSecretValue operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         The request failed because it would exceed one of the Secrets Manager quotas.
     * @throws EncryptionFailureException
     *         Secrets Manager can't encrypt the protected secret text using the provided KMS key. Check that the KMS
     *         key is available, enabled, and not in an invalid state. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
     *         key</a>.
     * @throws ResourceExistsException
     *         A resource with the ID you requested already exists.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.PutSecretValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutSecretValue" target="_top">AWS
     *      API Documentation</a>
     */
    default PutSecretValueResponse putSecretValue(Consumer<PutSecretValueRequest.Builder> putSecretValueRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, EncryptionFailureException,
            ResourceExistsException, ResourceNotFoundException, InternalServiceErrorException, DecryptionFailureException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return putSecretValue(PutSecretValueRequest.builder().applyMutation(putSecretValueRequest).build());
    }

    /**
     * <p>
     * For a secret that is replicated to other Regions, deletes the secret replicas from the Regions you specify.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:RemoveRegionsFromReplication</code>. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param removeRegionsFromReplicationRequest
     * @return Result of the RemoveRegionsFromReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.RemoveRegionsFromReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RemoveRegionsFromReplication"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveRegionsFromReplicationResponse removeRegionsFromReplication(
            RemoveRegionsFromReplicationRequest removeRegionsFromReplicationRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a secret that is replicated to other Regions, deletes the secret replicas from the Regions you specify.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:RemoveRegionsFromReplication</code>. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveRegionsFromReplicationRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveRegionsFromReplicationRequest#builder()}
     * </p>
     *
     * @param removeRegionsFromReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationRequest.Builder}
     *        to create a request.
     * @return Result of the RemoveRegionsFromReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.RemoveRegionsFromReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RemoveRegionsFromReplication"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveRegionsFromReplicationResponse removeRegionsFromReplication(
            Consumer<RemoveRegionsFromReplicationRequest.Builder> removeRegionsFromReplicationRequest)
            throws ResourceNotFoundException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return removeRegionsFromReplication(RemoveRegionsFromReplicationRequest.builder()
                .applyMutation(removeRegionsFromReplicationRequest).build());
    }

    /**
     * <p>
     * Replicates the secret to a new Regions. See <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create-manage-multi-region-secrets.html"
     * >Multi-Region secrets</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ReplicateSecretToRegions</code>. If the primary secret is
     * encrypted with a KMS key other than <code>aws/secretsmanager</code>, you also need <code>kms:Decrypt</code>
     * permission to the key. To encrypt the replicated secret with a KMS key other than <code>aws/secretsmanager</code>
     * , you need <code>kms:GenerateDataKey</code> and <code>kms:Encrypt</code> to the key. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param replicateSecretToRegionsRequest
     * @return Result of the ReplicateSecretToRegions operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ReplicateSecretToRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ReplicateSecretToRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default ReplicateSecretToRegionsResponse replicateSecretToRegions(
            ReplicateSecretToRegionsRequest replicateSecretToRegionsRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replicates the secret to a new Regions. See <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create-manage-multi-region-secrets.html"
     * >Multi-Region secrets</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ReplicateSecretToRegions</code>. If the primary secret is
     * encrypted with a KMS key other than <code>aws/secretsmanager</code>, you also need <code>kms:Decrypt</code>
     * permission to the key. To encrypt the replicated secret with a KMS key other than <code>aws/secretsmanager</code>
     * , you need <code>kms:GenerateDataKey</code> and <code>kms:Encrypt</code> to the key. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReplicateSecretToRegionsRequest.Builder} avoiding
     * the need to create one manually via {@link ReplicateSecretToRegionsRequest#builder()}
     * </p>
     *
     * @param replicateSecretToRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsRequest.Builder} to
     *        create a request.
     * @return Result of the ReplicateSecretToRegions operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ReplicateSecretToRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ReplicateSecretToRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default ReplicateSecretToRegionsResponse replicateSecretToRegions(
            Consumer<ReplicateSecretToRegionsRequest.Builder> replicateSecretToRegionsRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return replicateSecretToRegions(ReplicateSecretToRegionsRequest.builder().applyMutation(replicateSecretToRegionsRequest)
                .build());
    }

    /**
     * <p>
     * Cancels the scheduled deletion of a secret by removing the <code>DeletedDate</code> time stamp. You can access a
     * secret again after it has been restored.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:RestoreSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param restoreSecretRequest
     * @return Result of the RestoreSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.RestoreSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RestoreSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default RestoreSecretResponse restoreSecret(RestoreSecretRequest restoreSecretRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the scheduled deletion of a secret by removing the <code>DeletedDate</code> time stamp. You can access a
     * secret again after it has been restored.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:RestoreSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreSecretRequest.Builder} avoiding the need to
     * create one manually via {@link RestoreSecretRequest#builder()}
     * </p>
     *
     * @param restoreSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest.Builder} to create a
     *        request.
     * @return Result of the RestoreSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.RestoreSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RestoreSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default RestoreSecretResponse restoreSecret(Consumer<RestoreSecretRequest.Builder> restoreSecretRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return restoreSecret(RestoreSecretRequest.builder().applyMutation(restoreSecretRequest).build());
    }

    /**
     * <p>
     * Configures and starts the asynchronous process of rotating the secret. For information about rotation, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html">Rotate secrets</a> in
     * the <i>Secrets Manager User Guide</i>. If you include the configuration parameters, the operation sets the values
     * for the secret and then immediately starts a rotation. If you don't include the configuration parameters, the
     * operation starts a rotation with the values already stored in the secret.
     * </p>
     * <p>
     * When rotation is successful, the <code>AWSPENDING</code> staging label might be attached to the same version as
     * the <code>AWSCURRENT</code> version, or it might not be attached to any version. If the <code>AWSPENDING</code>
     * staging label is present but not attached to the same version as <code>AWSCURRENT</code>, then any later
     * invocation of <code>RotateSecret</code> assumes that a previous rotation request is still in progress and returns
     * an error. When rotation is unsuccessful, the <code>AWSPENDING</code> staging label might be attached to an empty
     * secret version. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot_rotation.html">Troubleshoot
     * rotation</a> in the <i>Secrets Manager User Guide</i>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:RotateSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>. You also need <code>lambda:InvokeFunction</code> permissions on the rotation
     * function. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets-required-permissions-function.html"
     * > Permissions for rotation</a>.
     * </p>
     *
     * @param rotateSecretRequest
     * @return Result of the RotateSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.RotateSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RotateSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default RotateSecretResponse rotateSecret(RotateSecretRequest rotateSecretRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServiceErrorException, InvalidRequestException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures and starts the asynchronous process of rotating the secret. For information about rotation, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html">Rotate secrets</a> in
     * the <i>Secrets Manager User Guide</i>. If you include the configuration parameters, the operation sets the values
     * for the secret and then immediately starts a rotation. If you don't include the configuration parameters, the
     * operation starts a rotation with the values already stored in the secret.
     * </p>
     * <p>
     * When rotation is successful, the <code>AWSPENDING</code> staging label might be attached to the same version as
     * the <code>AWSCURRENT</code> version, or it might not be attached to any version. If the <code>AWSPENDING</code>
     * staging label is present but not attached to the same version as <code>AWSCURRENT</code>, then any later
     * invocation of <code>RotateSecret</code> assumes that a previous rotation request is still in progress and returns
     * an error. When rotation is unsuccessful, the <code>AWSPENDING</code> staging label might be attached to an empty
     * secret version. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot_rotation.html">Troubleshoot
     * rotation</a> in the <i>Secrets Manager User Guide</i>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:RotateSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>. You also need <code>lambda:InvokeFunction</code> permissions on the rotation
     * function. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets-required-permissions-function.html"
     * > Permissions for rotation</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RotateSecretRequest.Builder} avoiding the need to
     * create one manually via {@link RotateSecretRequest#builder()}
     * </p>
     *
     * @param rotateSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest.Builder} to create a
     *        request.
     * @return Result of the RotateSecret operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.RotateSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RotateSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default RotateSecretResponse rotateSecret(Consumer<RotateSecretRequest.Builder> rotateSecretRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, InvalidRequestException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return rotateSecret(RotateSecretRequest.builder().applyMutation(rotateSecretRequest).build());
    }

    /**
     * <p>
     * Removes the link between the replica secret and the primary secret and promotes the replica to a primary secret
     * in the replica Region.
     * </p>
     * <p>
     * You must call this operation from the Region in which you want to promote the replica to a primary secret.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:StopReplicationToReplica</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param stopReplicationToReplicaRequest
     * @return Result of the StopReplicationToReplica operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.StopReplicationToReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/StopReplicationToReplica"
     *      target="_top">AWS API Documentation</a>
     */
    default StopReplicationToReplicaResponse stopReplicationToReplica(
            StopReplicationToReplicaRequest stopReplicationToReplicaRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the link between the replica secret and the primary secret and promotes the replica to a primary secret
     * in the replica Region.
     * </p>
     * <p>
     * You must call this operation from the Region in which you want to promote the replica to a primary secret.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:StopReplicationToReplica</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationToReplicaRequest.Builder} avoiding
     * the need to create one manually via {@link StopReplicationToReplicaRequest#builder()}
     * </p>
     *
     * @param stopReplicationToReplicaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaRequest.Builder} to
     *        create a request.
     * @return Result of the StopReplicationToReplica operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.StopReplicationToReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/StopReplicationToReplica"
     *      target="_top">AWS API Documentation</a>
     */
    default StopReplicationToReplicaResponse stopReplicationToReplica(
            Consumer<StopReplicationToReplicaRequest.Builder> stopReplicationToReplicaRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        return stopReplicationToReplica(StopReplicationToReplicaRequest.builder().applyMutation(stopReplicationToReplicaRequest)
                .build());
    }

    /**
     * <p>
     * Attaches tags to a secret. Tags consist of a key name and a value. Tags are part of the secret's metadata. They
     * are not associated with specific versions of the secret. This operation appends tags to the existing list of
     * tags.
     * </p>
     * <p>
     * For tag quotas and naming restrictions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/arg.html#taged-reference-quotas">Service quotas for
     * Tagging</a> in the <i>Amazon Web Services General Reference guide</i>.
     * </p>
     * <important>
     * <p>
     * If you use tags as part of your security strategy, then adding or removing a tag can change permissions. If
     * successfully completing this operation would result in you losing your permissions for this secret, then the
     * operation is blocked and returns an Access Denied error.
     * </p>
     * </important>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:TagResource</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches tags to a secret. Tags consist of a key name and a value. Tags are part of the secret's metadata. They
     * are not associated with specific versions of the secret. This operation appends tags to the existing list of
     * tags.
     * </p>
     * <p>
     * For tag quotas and naming restrictions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/arg.html#taged-reference-quotas">Service quotas for
     * Tagging</a> in the <i>Amazon Web Services General Reference guide</i>.
     * </p>
     * <important>
     * <p>
     * If you use tags as part of your security strategy, then adding or removing a tag can change permissions. If
     * successfully completing this operation would result in you losing your permissions for this secret, then the
     * operation is blocked and returns an Access Denied error.
     * </p>
     * </important>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:TagResource</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes specific tags from a secret.
     * </p>
     * <p>
     * This operation is idempotent. If a requested tag is not attached to the secret, no error is returned and the
     * secret metadata is unchanged.
     * </p>
     * <important>
     * <p>
     * If you use tags as part of your security strategy, then removing a tag can change permissions. If successfully
     * completing this operation would result in you losing your permissions for this secret, then the operation is
     * blocked and returns an Access Denied error.
     * </p>
     * </important>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:UntagResource</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specific tags from a secret.
     * </p>
     * <p>
     * This operation is idempotent. If a requested tag is not attached to the secret, no error is returned and the
     * secret metadata is unchanged.
     * </p>
     * <important>
     * <p>
     * If you use tags as part of your security strategy, then removing a tag can change permissions. If successfully
     * completing this operation would result in you losing your permissions for this secret, then the operation is
     * blocked and returns an Access Denied error.
     * </p>
     * </important>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:UntagResource</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the details of a secret, including metadata and the secret value. To change the secret value, you can
     * also use <a>PutSecretValue</a>.
     * </p>
     * <p>
     * To change the rotation configuration of a secret, use <a>RotateSecret</a> instead.
     * </p>
     * <p>
     * To change a secret so that it is managed by another service, you need to recreate the secret in that service. See
     * <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets Manager
     * secrets managed by other Amazon Web Services services</a>.
     * </p>
     * <p>
     * We recommend you avoid calling <code>UpdateSecret</code> at a sustained rate of more than once every 10 minutes.
     * When you call <code>UpdateSecret</code> to update the secret value, Secrets Manager creates a new version of the
     * secret. Secrets Manager removes outdated versions when there are more than 100, but it does not remove versions
     * created less than 24 hours ago. If you update the secret value more than once every 10 minutes, you create more
     * versions than Secrets Manager removes, and you will reach the quota for secret versions.
     * </p>
     * <p>
     * If you include <code>SecretString</code> or <code>SecretBinary</code> to create a new secret version, Secrets
     * Manager automatically moves the staging label <code>AWSCURRENT</code> to the new version. Then it attaches the
     * label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.
     * </p>
     * <p>
     * If you call this operation with a <code>ClientRequestToken</code> that matches an existing version's
     * <code>VersionId</code>, the operation results in an error. You can't modify an existing version, you can only
     * create a new version. To remove a version, remove all staging labels from it. See
     * <a>UpdateSecretVersionStage</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters except <code>SecretBinary</code> or <code>SecretString</code> because it might be logged.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:UpdateSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>. If you use a customer managed key, you must also have
     * <code>kms:GenerateDataKey</code>, <code>kms:Encrypt</code>, and <code>kms:Decrypt</code> permissions on the key.
     * If you change the KMS key and you don't have <code>kms:Encrypt</code> permission to the new key, Secrets Manager
     * does not re-ecrypt existing secret versions with the new key. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/security-encryption.html"> Secret encryption
     * and decryption</a>.
     * </p>
     *
     * @param updateSecretRequest
     * @return Result of the UpdateSecret operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         The request failed because it would exceed one of the Secrets Manager quotas.
     * @throws EncryptionFailureException
     *         Secrets Manager can't encrypt the protected secret text using the provided KMS key. Check that the KMS
     *         key is available, enabled, and not in an invalid state. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
     *         key</a>.
     * @throws ResourceExistsException
     *         A resource with the ID you requested already exists.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws MalformedPolicyDocumentException
     *         The resource policy has syntax errors.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws PreconditionNotMetException
     *         The request failed because you did not complete all the prerequisite steps.
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.UpdateSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSecretResponse updateSecret(UpdateSecretRequest updateSecretRequest) throws InvalidParameterException,
            InvalidRequestException, LimitExceededException, EncryptionFailureException, ResourceExistsException,
            ResourceNotFoundException, MalformedPolicyDocumentException, InternalServiceErrorException,
            PreconditionNotMetException, DecryptionFailureException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the details of a secret, including metadata and the secret value. To change the secret value, you can
     * also use <a>PutSecretValue</a>.
     * </p>
     * <p>
     * To change the rotation configuration of a secret, use <a>RotateSecret</a> instead.
     * </p>
     * <p>
     * To change a secret so that it is managed by another service, you need to recreate the secret in that service. See
     * <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets Manager
     * secrets managed by other Amazon Web Services services</a>.
     * </p>
     * <p>
     * We recommend you avoid calling <code>UpdateSecret</code> at a sustained rate of more than once every 10 minutes.
     * When you call <code>UpdateSecret</code> to update the secret value, Secrets Manager creates a new version of the
     * secret. Secrets Manager removes outdated versions when there are more than 100, but it does not remove versions
     * created less than 24 hours ago. If you update the secret value more than once every 10 minutes, you create more
     * versions than Secrets Manager removes, and you will reach the quota for secret versions.
     * </p>
     * <p>
     * If you include <code>SecretString</code> or <code>SecretBinary</code> to create a new secret version, Secrets
     * Manager automatically moves the staging label <code>AWSCURRENT</code> to the new version. Then it attaches the
     * label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.
     * </p>
     * <p>
     * If you call this operation with a <code>ClientRequestToken</code> that matches an existing version's
     * <code>VersionId</code>, the operation results in an error. You can't modify an existing version, you can only
     * create a new version. To remove a version, remove all staging labels from it. See
     * <a>UpdateSecretVersionStage</a>.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters except <code>SecretBinary</code> or <code>SecretString</code> because it might be logged.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:UpdateSecret</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>. If you use a customer managed key, you must also have
     * <code>kms:GenerateDataKey</code>, <code>kms:Encrypt</code>, and <code>kms:Decrypt</code> permissions on the key.
     * If you change the KMS key and you don't have <code>kms:Encrypt</code> permission to the new key, Secrets Manager
     * does not re-ecrypt existing secret versions with the new key. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/security-encryption.html"> Secret encryption
     * and decryption</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecretRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSecretRequest#builder()}
     * </p>
     *
     * @param updateSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSecret operation returned by the service.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         The request failed because it would exceed one of the Secrets Manager quotas.
     * @throws EncryptionFailureException
     *         Secrets Manager can't encrypt the protected secret text using the provided KMS key. Check that the KMS
     *         key is available, enabled, and not in an invalid state. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
     *         key</a>.
     * @throws ResourceExistsException
     *         A resource with the ID you requested already exists.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws MalformedPolicyDocumentException
     *         The resource policy has syntax errors.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws PreconditionNotMetException
     *         The request failed because you did not complete all the prerequisite steps.
     * @throws DecryptionFailureException
     *         Secrets Manager can't decrypt the protected secret text using the provided KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.UpdateSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecret" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSecretResponse updateSecret(Consumer<UpdateSecretRequest.Builder> updateSecretRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, EncryptionFailureException,
            ResourceExistsException, ResourceNotFoundException, MalformedPolicyDocumentException, InternalServiceErrorException,
            PreconditionNotMetException, DecryptionFailureException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        return updateSecret(UpdateSecretRequest.builder().applyMutation(updateSecretRequest).build());
    }

    /**
     * <p>
     * Modifies the staging labels attached to a version of a secret. Secrets Manager uses staging labels to track a
     * version as it progresses through the secret rotation process. Each staging label can be attached to only one
     * version at a time. To add a staging label to a version when it is already attached to another version, Secrets
     * Manager first removes it from the other version first and then attaches it to this one. For more information
     * about versions and staging labels, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts:
     * Version</a>.
     * </p>
     * <p>
     * The staging labels that you specify in the <code>VersionStage</code> parameter are added to the existing list of
     * staging labels for the version.
     * </p>
     * <p>
     * You can move the <code>AWSCURRENT</code> staging label to this version by including it in this call.
     * </p>
     * <note>
     * <p>
     * Whenever you move <code>AWSCURRENT</code>, Secrets Manager automatically moves the label <code>AWSPREVIOUS</code>
     * to the version that <code>AWSCURRENT</code> was removed from.
     * </p>
     * </note>
     * <p>
     * If this action results in the last label being removed from a version, then the version is considered to be
     * 'deprecated' and can be deleted by Secrets Manager.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:UpdateSecretVersionStage</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param updateSecretVersionStageRequest
     * @return Result of the UpdateSecretVersionStage operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         The request failed because it would exceed one of the Secrets Manager quotas.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.UpdateSecretVersionStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStage"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecretVersionStageResponse updateSecretVersionStage(
            UpdateSecretVersionStageRequest updateSecretVersionStageRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, LimitExceededException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the staging labels attached to a version of a secret. Secrets Manager uses staging labels to track a
     * version as it progresses through the secret rotation process. Each staging label can be attached to only one
     * version at a time. To add a staging label to a version when it is already attached to another version, Secrets
     * Manager first removes it from the other version first and then attaches it to this one. For more information
     * about versions and staging labels, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts:
     * Version</a>.
     * </p>
     * <p>
     * The staging labels that you specify in the <code>VersionStage</code> parameter are added to the existing list of
     * staging labels for the version.
     * </p>
     * <p>
     * You can move the <code>AWSCURRENT</code> staging label to this version by including it in this call.
     * </p>
     * <note>
     * <p>
     * Whenever you move <code>AWSCURRENT</code>, Secrets Manager automatically moves the label <code>AWSPREVIOUS</code>
     * to the version that <code>AWSCURRENT</code> was removed from.
     * </p>
     * </note>
     * <p>
     * If this action results in the last label being removed from a version, then the version is considered to be
     * 'deprecated' and can be deleted by Secrets Manager.
     * </p>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:UpdateSecretVersionStage</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecretVersionStageRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSecretVersionStageRequest#builder()}
     * </p>
     *
     * @param updateSecretVersionStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSecretVersionStage operation returned by the service.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         The request failed because it would exceed one of the Secrets Manager quotas.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.UpdateSecretVersionStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStage"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecretVersionStageResponse updateSecretVersionStage(
            Consumer<UpdateSecretVersionStageRequest.Builder> updateSecretVersionStageRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, LimitExceededException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, SecretsManagerException {
        return updateSecretVersionStage(UpdateSecretVersionStageRequest.builder().applyMutation(updateSecretVersionStageRequest)
                .build());
    }

    /**
     * <p>
     * Validates that a resource policy does not grant a wide range of principals access to your secret. A
     * resource-based policy is optional for secrets.
     * </p>
     * <p>
     * The API performs three checks when validating the policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sends a call to <a href=
     * "https://aws.amazon.com/blogs/security/protect-sensitive-data-in-the-cloud-with-automated-reasoning-zelkova/"
     * >Zelkova</a>, an automated reasoning engine, to ensure your resource policy does not allow broad access to your
     * secret, for example policies that use a wildcard for the principal.
     * </p>
     * </li>
     * <li>
     * <p>
     * Checks for correct syntax in a policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Verifies the policy does not lock out a caller.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ValidateResourcePolicy</code> and
     * <code>secretsmanager:PutResourcePolicy</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     *
     * @param validateResourcePolicyRequest
     * @return Result of the ValidateResourcePolicy operation returned by the service.
     * @throws MalformedPolicyDocumentException
     *         The resource policy has syntax errors.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ValidateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ValidateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateResourcePolicyResponse validateResourcePolicy(ValidateResourcePolicyRequest validateResourcePolicyRequest)
            throws MalformedPolicyDocumentException, ResourceNotFoundException, InvalidParameterException,
            InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates that a resource policy does not grant a wide range of principals access to your secret. A
     * resource-based policy is optional for secrets.
     * </p>
     * <p>
     * The API performs three checks when validating the policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sends a call to <a href=
     * "https://aws.amazon.com/blogs/security/protect-sensitive-data-in-the-cloud-with-automated-reasoning-zelkova/"
     * >Zelkova</a>, an automated reasoning engine, to ensure your resource policy does not allow broad access to your
     * secret, for example policies that use a wildcard for the principal.
     * </p>
     * </li>
     * <li>
     * <p>
     * Checks for correct syntax in a policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Verifies the policy does not lock out a caller.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Secrets Manager generates a CloudTrail log entry when you call this action. Do not include sensitive information
     * in request parameters because it might be logged. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html">Logging Secrets
     * Manager events with CloudTrail</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>secretsmanager:ValidateResourcePolicy</code> and
     * <code>secretsmanager:PutResourcePolicy</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions"
     * > IAM policy actions for Secrets Manager</a> and <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access
     * control in Secrets Manager</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link ValidateResourcePolicyRequest#builder()}
     * </p>
     *
     * @param validateResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the ValidateResourcePolicy operation returned by the service.
     * @throws MalformedPolicyDocumentException
     *         The resource policy has syntax errors.
     * @throws ResourceNotFoundException
     *         Secrets Manager can't find the resource that you asked for.
     * @throws InvalidParameterException
     *         The parameter name or value is invalid.
     * @throws InternalServiceErrorException
     *         An error occurred on the server side.
     * @throws InvalidRequestException
     *         A parameter value is not valid for the current state of the resource.</p>
     *         <p>
     *         Possible causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The secret is scheduled for deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to enable rotation on a secret that doesn't already have a Lambda function ARN configured and
     *         you didn't include such an ARN as a parameter in this call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The secret is managed by another service, and you must use that service to update it. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecretsManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecretsManagerClient.ValidateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ValidateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateResourcePolicyResponse validateResourcePolicy(
            Consumer<ValidateResourcePolicyRequest.Builder> validateResourcePolicyRequest)
            throws MalformedPolicyDocumentException, ResourceNotFoundException, InvalidParameterException,
            InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException,
            SecretsManagerException {
        return validateResourcePolicy(ValidateResourcePolicyRequest.builder().applyMutation(validateResourcePolicyRequest)
                .build());
    }

    /**
     * Create a {@link SecretsManagerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecretsManagerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecretsManagerClient}.
     */
    static SecretsManagerClientBuilder builder() {
        return new DefaultSecretsManagerClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SecretsManagerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
