/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecretVersionStageRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<UpdateSecretVersionStageRequest.Builder, UpdateSecretVersionStageRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(UpdateSecretVersionStageRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<String> VERSION_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionStage").getter(getter(UpdateSecretVersionStageRequest::versionStage))
            .setter(setter(Builder::versionStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionStage").build()).build();

    private static final SdkField<String> REMOVE_FROM_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoveFromVersionId").getter(getter(UpdateSecretVersionStageRequest::removeFromVersionId))
            .setter(setter(Builder::removeFromVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveFromVersionId").build())
            .build();

    private static final SdkField<String> MOVE_TO_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MoveToVersionId").getter(getter(UpdateSecretVersionStageRequest::moveToVersionId))
            .setter(setter(Builder::moveToVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoveToVersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD,
            VERSION_STAGE_FIELD, REMOVE_FROM_VERSION_ID_FIELD, MOVE_TO_VERSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String secretId;

    private final String versionStage;

    private final String removeFromVersionId;

    private final String moveToVersionId;

    private UpdateSecretVersionStageRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.versionStage = builder.versionStage;
        this.removeFromVersionId = builder.removeFromVersionId;
        this.moveToVersionId = builder.moveToVersionId;
    }

    /**
     * <p>
     * The ARN or the name of the secret with the version and staging labelsto modify.
     * </p>
     * <p>
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen">Finding
     * a secret from a partial ARN</a>.
     * </p>
     * 
     * @return The ARN or the name of the secret with the version and staging labelsto modify.</p>
     *         <p>
     *         For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
     *         "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
     *         >Finding a secret from a partial ARN</a>.
     */
    public final String secretId() {
        return secretId;
    }

    /**
     * <p>
     * The staging label to add to this version.
     * </p>
     * 
     * @return The staging label to add to this version.
     */
    public final String versionStage() {
        return versionStage;
    }

    /**
     * <p>
     * The ID of the version that the staging label is to be removed from. If the staging label you are trying to attach
     * to one version is already attached to a different version, then you must include this parameter and specify the
     * version that the label is to be removed from. If the label is attached and you either do not specify this
     * parameter, or the version ID does not match, then the operation fails.
     * </p>
     * 
     * @return The ID of the version that the staging label is to be removed from. If the staging label you are trying
     *         to attach to one version is already attached to a different version, then you must include this parameter
     *         and specify the version that the label is to be removed from. If the label is attached and you either do
     *         not specify this parameter, or the version ID does not match, then the operation fails.
     */
    public final String removeFromVersionId() {
        return removeFromVersionId;
    }

    /**
     * <p>
     * The ID of the version to add the staging label to. To remove a label from a version, then do not specify this
     * parameter.
     * </p>
     * <p>
     * If the staging label is already attached to a different version of the secret, then you must also specify the
     * <code>RemoveFromVersionId</code> parameter.
     * </p>
     * 
     * @return The ID of the version to add the staging label to. To remove a label from a version, then do not specify
     *         this parameter.</p>
     *         <p>
     *         If the staging label is already attached to a different version of the secret, then you must also specify
     *         the <code>RemoveFromVersionId</code> parameter.
     */
    public final String moveToVersionId() {
        return moveToVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(versionStage());
        hashCode = 31 * hashCode + Objects.hashCode(removeFromVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(moveToVersionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecretVersionStageRequest)) {
            return false;
        }
        UpdateSecretVersionStageRequest other = (UpdateSecretVersionStageRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(versionStage(), other.versionStage())
                && Objects.equals(removeFromVersionId(), other.removeFromVersionId())
                && Objects.equals(moveToVersionId(), other.moveToVersionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecretVersionStageRequest").add("SecretId", secretId())
                .add("VersionStage", versionStage()).add("RemoveFromVersionId", removeFromVersionId())
                .add("MoveToVersionId", moveToVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "VersionStage":
            return Optional.ofNullable(clazz.cast(versionStage()));
        case "RemoveFromVersionId":
            return Optional.ofNullable(clazz.cast(removeFromVersionId()));
        case "MoveToVersionId":
            return Optional.ofNullable(clazz.cast(moveToVersionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretId", SECRET_ID_FIELD);
        map.put("VersionStage", VERSION_STAGE_FIELD);
        map.put("RemoveFromVersionId", REMOVE_FROM_VERSION_ID_FIELD);
        map.put("MoveToVersionId", MOVE_TO_VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecretVersionStageRequest, T> g) {
        return obj -> g.apply((UpdateSecretVersionStageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSecretVersionStageRequest> {
        /**
         * <p>
         * The ARN or the name of the secret with the version and staging labelsto modify.
         * </p>
         * <p>
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         * >Finding a secret from a partial ARN</a>.
         * </p>
         * 
         * @param secretId
         *        The ARN or the name of the secret with the version and staging labelsto modify.</p>
         *        <p>
         *        For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
         *        "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         *        >Finding a secret from a partial ARN</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * The staging label to add to this version.
         * </p>
         * 
         * @param versionStage
         *        The staging label to add to this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionStage(String versionStage);

        /**
         * <p>
         * The ID of the version that the staging label is to be removed from. If the staging label you are trying to
         * attach to one version is already attached to a different version, then you must include this parameter and
         * specify the version that the label is to be removed from. If the label is attached and you either do not
         * specify this parameter, or the version ID does not match, then the operation fails.
         * </p>
         * 
         * @param removeFromVersionId
         *        The ID of the version that the staging label is to be removed from. If the staging label you are
         *        trying to attach to one version is already attached to a different version, then you must include this
         *        parameter and specify the version that the label is to be removed from. If the label is attached and
         *        you either do not specify this parameter, or the version ID does not match, then the operation fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFromVersionId(String removeFromVersionId);

        /**
         * <p>
         * The ID of the version to add the staging label to. To remove a label from a version, then do not specify this
         * parameter.
         * </p>
         * <p>
         * If the staging label is already attached to a different version of the secret, then you must also specify the
         * <code>RemoveFromVersionId</code> parameter.
         * </p>
         * 
         * @param moveToVersionId
         *        The ID of the version to add the staging label to. To remove a label from a version, then do not
         *        specify this parameter.</p>
         *        <p>
         *        If the staging label is already attached to a different version of the secret, then you must also
         *        specify the <code>RemoveFromVersionId</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moveToVersionId(String moveToVersionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String versionStage;

        private String removeFromVersionId;

        private String moveToVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecretVersionStageRequest model) {
            super(model);
            secretId(model.secretId);
            versionStage(model.versionStage);
            removeFromVersionId(model.removeFromVersionId);
            moveToVersionId(model.moveToVersionId);
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final String getVersionStage() {
            return versionStage;
        }

        public final void setVersionStage(String versionStage) {
            this.versionStage = versionStage;
        }

        @Override
        public final Builder versionStage(String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        public final String getRemoveFromVersionId() {
            return removeFromVersionId;
        }

        public final void setRemoveFromVersionId(String removeFromVersionId) {
            this.removeFromVersionId = removeFromVersionId;
        }

        @Override
        public final Builder removeFromVersionId(String removeFromVersionId) {
            this.removeFromVersionId = removeFromVersionId;
            return this;
        }

        public final String getMoveToVersionId() {
            return moveToVersionId;
        }

        public final void setMoveToVersionId(String moveToVersionId) {
            this.moveToVersionId = moveToVersionId;
        }

        @Override
        public final Builder moveToVersionId(String moveToVersionId) {
            this.moveToVersionId = moveToVersionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecretVersionStageRequest build() {
            return new UpdateSecretVersionStageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
