/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecretResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<UpdateSecretResponse.Builder, UpdateSecretResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSecretResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSecretResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSecretResponse::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            VERSION_ID_FIELD));

    private final String arn;

    private final String name;

    private final String versionId;

    private UpdateSecretResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * The ARN of the secret that was updated.
     * </p>
     * <note>
     * <p>
     * Secrets Manager automatically adds several random characters to the name at the end of the ARN when you initially
     * create a secret. This affects only the ARN and not the actual friendly name. This ensures that if you create a
     * new secret with the same name as an old secret that you previously deleted, then users with access to the old
     * secret <i>don't</i> automatically get access to the new secret because the ARNs are different.
     * </p>
     * </note>
     * 
     * @return The ARN of the secret that was updated.</p> <note>
     *         <p>
     *         Secrets Manager automatically adds several random characters to the name at the end of the ARN when you
     *         initially create a secret. This affects only the ARN and not the actual friendly name. This ensures that
     *         if you create a new secret with the same name as an old secret that you previously deleted, then users
     *         with access to the old secret <i>don't</i> automatically get access to the new secret because the ARNs
     *         are different.
     *         </p>
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name of the secret that was updated.
     * </p>
     * 
     * @return The friendly name of the secret that was updated.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * If a new version of the secret was created by this operation, then <code>VersionId</code> contains the unique
     * identifier of the new version.
     * </p>
     * 
     * @return If a new version of the secret was created by this operation, then <code>VersionId</code> contains the
     *         unique identifier of the new version.
     */
    public String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecretResponse)) {
            return false;
        }
        UpdateSecretResponse other = (UpdateSecretResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSecretResponse").add("ARN", arn()).add("Name", name()).add("VersionId", versionId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecretResponse, T> g) {
        return obj -> g.apply((UpdateSecretResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSecretResponse> {
        /**
         * <p>
         * The ARN of the secret that was updated.
         * </p>
         * <note>
         * <p>
         * Secrets Manager automatically adds several random characters to the name at the end of the ARN when you
         * initially create a secret. This affects only the ARN and not the actual friendly name. This ensures that if
         * you create a new secret with the same name as an old secret that you previously deleted, then users with
         * access to the old secret <i>don't</i> automatically get access to the new secret because the ARNs are
         * different.
         * </p>
         * </note>
         * 
         * @param arn
         *        The ARN of the secret that was updated.</p> <note>
         *        <p>
         *        Secrets Manager automatically adds several random characters to the name at the end of the ARN when
         *        you initially create a secret. This affects only the ARN and not the actual friendly name. This
         *        ensures that if you create a new secret with the same name as an old secret that you previously
         *        deleted, then users with access to the old secret <i>don't</i> automatically get access to the new
         *        secret because the ARNs are different.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name of the secret that was updated.
         * </p>
         * 
         * @param name
         *        The friendly name of the secret that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If a new version of the secret was created by this operation, then <code>VersionId</code> contains the unique
         * identifier of the new version.
         * </p>
         * 
         * @param versionId
         *        If a new version of the secret was created by this operation, then <code>VersionId</code> contains the
         *        unique identifier of the new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecretResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            versionId(model.versionId);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public UpdateSecretResponse build() {
            return new UpdateSecretResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
