/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a cache behavior for the distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionCacheBehavior implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionCacheBehavior.Builder, AwsCloudFrontDistributionCacheBehavior> {
    private static final SdkField<String> VIEWER_PROTOCOL_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewerProtocolPolicy").getter(getter(AwsCloudFrontDistributionCacheBehavior::viewerProtocolPolicy))
            .setter(setter(Builder::viewerProtocolPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerProtocolPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIEWER_PROTOCOL_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String viewerProtocolPolicy;

    private AwsCloudFrontDistributionCacheBehavior(BuilderImpl builder) {
        this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
    }

    /**
     * <p>
     * The protocol that viewers can use to access the files in an origin. You can specify the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow-all</code> - Viewers can use HTTP or HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>redirect-to-https</code> - CloudFront responds to HTTP requests with an HTTP status code of 301 (Moved
     * Permanently) and the HTTPS URL. The viewer then uses the new URL to resubmit.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https-only</code> - CloudFront responds to HTTP request with an HTTP status code of 403 (Forbidden).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The protocol that viewers can use to access the files in an origin. You can specify the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow-all</code> - Viewers can use HTTP or HTTPS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>redirect-to-https</code> - CloudFront responds to HTTP requests with an HTTP status code of 301
     *         (Moved Permanently) and the HTTPS URL. The viewer then uses the new URL to resubmit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https-only</code> - CloudFront responds to HTTP request with an HTTP status code of 403
     *         (Forbidden).
     *         </p>
     *         </li>
     */
    public final String viewerProtocolPolicy() {
        return viewerProtocolPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(viewerProtocolPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionCacheBehavior)) {
            return false;
        }
        AwsCloudFrontDistributionCacheBehavior other = (AwsCloudFrontDistributionCacheBehavior) obj;
        return Objects.equals(viewerProtocolPolicy(), other.viewerProtocolPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionCacheBehavior").add("ViewerProtocolPolicy", viewerProtocolPolicy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViewerProtocolPolicy":
            return Optional.ofNullable(clazz.cast(viewerProtocolPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionCacheBehavior, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionCacheBehavior) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionCacheBehavior> {
        /**
         * <p>
         * The protocol that viewers can use to access the files in an origin. You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-all</code> - Viewers can use HTTP or HTTPS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>redirect-to-https</code> - CloudFront responds to HTTP requests with an HTTP status code of 301 (Moved
         * Permanently) and the HTTPS URL. The viewer then uses the new URL to resubmit.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https-only</code> - CloudFront responds to HTTP request with an HTTP status code of 403 (Forbidden).
         * </p>
         * </li>
         * </ul>
         * 
         * @param viewerProtocolPolicy
         *        The protocol that viewers can use to access the files in an origin. You can specify the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-all</code> - Viewers can use HTTP or HTTPS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>redirect-to-https</code> - CloudFront responds to HTTP requests with an HTTP status code of 301
         *        (Moved Permanently) and the HTTPS URL. The viewer then uses the new URL to resubmit.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https-only</code> - CloudFront responds to HTTP request with an HTTP status code of 403
         *        (Forbidden).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerProtocolPolicy(String viewerProtocolPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String viewerProtocolPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionCacheBehavior model) {
            viewerProtocolPolicy(model.viewerProtocolPolicy);
        }

        public final String getViewerProtocolPolicy() {
            return viewerProtocolPolicy;
        }

        @Override
        public final Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        public final void setViewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        @Override
        public AwsCloudFrontDistributionCacheBehavior build() {
            return new AwsCloudFrontDistributionCacheBehavior(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
