/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an IPV6 address that is associated with the network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2NetworkInterfaceIpV6AddressDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2NetworkInterfaceIpV6AddressDetail.Builder, AwsEc2NetworkInterfaceIpV6AddressDetail> {
    private static final SdkField<String> IP_V6_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpV6Address").getter(getter(AwsEc2NetworkInterfaceIpV6AddressDetail::ipV6Address))
            .setter(setter(Builder::ipV6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV6Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_V6_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipV6Address;

    private AwsEc2NetworkInterfaceIpV6AddressDetail(BuilderImpl builder) {
        this.ipV6Address = builder.ipV6Address;
    }

    /**
     * <p>
     * The IPV6 address.
     * </p>
     * 
     * @return The IPV6 address.
     */
    public final String ipV6Address() {
        return ipV6Address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipV6Address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceIpV6AddressDetail)) {
            return false;
        }
        AwsEc2NetworkInterfaceIpV6AddressDetail other = (AwsEc2NetworkInterfaceIpV6AddressDetail) obj;
        return Objects.equals(ipV6Address(), other.ipV6Address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2NetworkInterfaceIpV6AddressDetail").add("IpV6Address", ipV6Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpV6Address":
            return Optional.ofNullable(clazz.cast(ipV6Address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceIpV6AddressDetail, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceIpV6AddressDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2NetworkInterfaceIpV6AddressDetail> {
        /**
         * <p>
         * The IPV6 address.
         * </p>
         * 
         * @param ipV6Address
         *        The IPV6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Address(String ipV6Address);
    }

    static final class BuilderImpl implements Builder {
        private String ipV6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceIpV6AddressDetail model) {
            ipV6Address(model.ipV6Address);
        }

        public final String getIpV6Address() {
            return ipV6Address;
        }

        @Override
        public final Builder ipV6Address(String ipV6Address) {
            this.ipV6Address = ipV6Address;
            return this;
        }

        public final void setIpV6Address(String ipV6Address) {
            this.ipV6Address = ipV6Address;
        }

        @Override
        public AwsEc2NetworkInterfaceIpV6AddressDetail build() {
            return new AwsEc2NetworkInterfaceIpV6AddressDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
