/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A range of IPv6 addresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2SecurityGroupIpv6Range implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2SecurityGroupIpv6Range.Builder, AwsEc2SecurityGroupIpv6Range> {
    private static final SdkField<String> CIDR_IPV6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CidrIpv6").getter(getter(AwsEc2SecurityGroupIpv6Range::cidrIpv6)).setter(setter(Builder::cidrIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv6").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_IPV6_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidrIpv6;

    private AwsEc2SecurityGroupIpv6Range(BuilderImpl builder) {
        this.cidrIpv6 = builder.cidrIpv6;
    }

    /**
     * <p>
     * The IPv6 CIDR range. You can specify either a CIDR range or a source security group, but not both. To specify a
     * single IPv6 address, use the /128 prefix length.
     * </p>
     * 
     * @return The IPv6 CIDR range. You can specify either a CIDR range or a source security group, but not both. To
     *         specify a single IPv6 address, use the /128 prefix length.
     */
    public final String cidrIpv6() {
        return cidrIpv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv6());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2SecurityGroupIpv6Range)) {
            return false;
        }
        AwsEc2SecurityGroupIpv6Range other = (AwsEc2SecurityGroupIpv6Range) obj;
        return Objects.equals(cidrIpv6(), other.cidrIpv6());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2SecurityGroupIpv6Range").add("CidrIpv6", cidrIpv6()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIpv6":
            return Optional.ofNullable(clazz.cast(cidrIpv6()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2SecurityGroupIpv6Range, T> g) {
        return obj -> g.apply((AwsEc2SecurityGroupIpv6Range) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2SecurityGroupIpv6Range> {
        /**
         * <p>
         * The IPv6 CIDR range. You can specify either a CIDR range or a source security group, but not both. To specify
         * a single IPv6 address, use the /128 prefix length.
         * </p>
         * 
         * @param cidrIpv6
         *        The IPv6 CIDR range. You can specify either a CIDR range or a source security group, but not both. To
         *        specify a single IPv6 address, use the /128 prefix length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv6(String cidrIpv6);
    }

    static final class BuilderImpl implements Builder {
        private String cidrIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2SecurityGroupIpv6Range model) {
            cidrIpv6(model.cidrIpv6);
        }

        public final String getCidrIpv6() {
            return cidrIpv6;
        }

        @Override
        public final Builder cidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        public final void setCidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
        }

        @Override
        public AwsEc2SecurityGroupIpv6Range build() {
            return new AwsEc2SecurityGroupIpv6Range(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
