/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a stickiness policy that was created using <code>CreateLBCookieStickinessPolicy</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElbLbCookieStickinessPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElbLbCookieStickinessPolicy.Builder, AwsElbLbCookieStickinessPolicy> {
    private static final SdkField<Long> COOKIE_EXPIRATION_PERIOD_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CookieExpirationPeriod").getter(getter(AwsElbLbCookieStickinessPolicy::cookieExpirationPeriod))
            .setter(setter(Builder::cookieExpirationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieExpirationPeriod").build())
            .build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(AwsElbLbCookieStickinessPolicy::policyName))
            .setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COOKIE_EXPIRATION_PERIOD_FIELD, POLICY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long cookieExpirationPeriod;

    private final String policyName;

    private AwsElbLbCookieStickinessPolicy(BuilderImpl builder) {
        this.cookieExpirationPeriod = builder.cookieExpirationPeriod;
        this.policyName = builder.policyName;
    }

    /**
     * <p>
     * The amount of time, in seconds, after which the cookie is considered stale. If an expiration period is not
     * specified, the stickiness session lasts for the duration of the browser session.
     * </p>
     * 
     * @return The amount of time, in seconds, after which the cookie is considered stale. If an expiration period is
     *         not specified, the stickiness session lasts for the duration of the browser session.
     */
    public final Long cookieExpirationPeriod() {
        return cookieExpirationPeriod;
    }

    /**
     * <p>
     * The name of the policy. The name must be unique within the set of policies for the load balancer.
     * </p>
     * 
     * @return The name of the policy. The name must be unique within the set of policies for the load balancer.
     */
    public final String policyName() {
        return policyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cookieExpirationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLbCookieStickinessPolicy)) {
            return false;
        }
        AwsElbLbCookieStickinessPolicy other = (AwsElbLbCookieStickinessPolicy) obj;
        return Objects.equals(cookieExpirationPeriod(), other.cookieExpirationPeriod())
                && Objects.equals(policyName(), other.policyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElbLbCookieStickinessPolicy").add("CookieExpirationPeriod", cookieExpirationPeriod())
                .add("PolicyName", policyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CookieExpirationPeriod":
            return Optional.ofNullable(clazz.cast(cookieExpirationPeriod()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLbCookieStickinessPolicy, T> g) {
        return obj -> g.apply((AwsElbLbCookieStickinessPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElbLbCookieStickinessPolicy> {
        /**
         * <p>
         * The amount of time, in seconds, after which the cookie is considered stale. If an expiration period is not
         * specified, the stickiness session lasts for the duration of the browser session.
         * </p>
         * 
         * @param cookieExpirationPeriod
         *        The amount of time, in seconds, after which the cookie is considered stale. If an expiration period is
         *        not specified, the stickiness session lasts for the duration of the browser session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookieExpirationPeriod(Long cookieExpirationPeriod);

        /**
         * <p>
         * The name of the policy. The name must be unique within the set of policies for the load balancer.
         * </p>
         * 
         * @param policyName
         *        The name of the policy. The name must be unique within the set of policies for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);
    }

    static final class BuilderImpl implements Builder {
        private Long cookieExpirationPeriod;

        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLbCookieStickinessPolicy model) {
            cookieExpirationPeriod(model.cookieExpirationPeriod);
            policyName(model.policyName);
        }

        public final Long getCookieExpirationPeriod() {
            return cookieExpirationPeriod;
        }

        @Override
        public final Builder cookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
            return this;
        }

        public final void setCookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public AwsElbLbCookieStickinessPolicy build() {
            return new AwsElbLbCookieStickinessPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
