/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a load balancer listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElbLoadBalancerListener implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElbLoadBalancerListener.Builder, AwsElbLoadBalancerListener> {
    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstancePort").getter(getter(AwsElbLoadBalancerListener::instancePort))
            .setter(setter(Builder::instancePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePort").build()).build();

    private static final SdkField<String> INSTANCE_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProtocol").getter(getter(AwsElbLoadBalancerListener::instanceProtocol))
            .setter(setter(Builder::instanceProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProtocol").build()).build();

    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LoadBalancerPort").getter(getter(AwsElbLoadBalancerListener::loadBalancerPort))
            .setter(setter(Builder::loadBalancerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AwsElbLoadBalancerListener::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> SSL_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslCertificateId").getter(getter(AwsElbLoadBalancerListener::sslCertificateId))
            .setter(setter(Builder::sslCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCertificateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PORT_FIELD,
            INSTANCE_PROTOCOL_FIELD, LOAD_BALANCER_PORT_FIELD, PROTOCOL_FIELD, SSL_CERTIFICATE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instancePort;

    private final String instanceProtocol;

    private final Integer loadBalancerPort;

    private final String protocol;

    private final String sslCertificateId;

    private AwsElbLoadBalancerListener(BuilderImpl builder) {
        this.instancePort = builder.instancePort;
        this.instanceProtocol = builder.instanceProtocol;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.protocol = builder.protocol;
        this.sslCertificateId = builder.sslCertificateId;
    }

    /**
     * <p>
     * The port on which the instance is listening.
     * </p>
     * 
     * @return The port on which the instance is listening.
     */
    public final Integer instancePort() {
        return instancePort;
    }

    /**
     * <p>
     * The protocol to use to route traffic to instances.
     * </p>
     * <p>
     * Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code>
     * </p>
     * 
     * @return The protocol to use to route traffic to instances.</p>
     *         <p>
     *         Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code>
     */
    public final String instanceProtocol() {
        return instanceProtocol;
    }

    /**
     * <p>
     * The port on which the load balancer is listening.
     * </p>
     * <p>
     * On EC2-VPC, you can specify any port from the range 1-65535.
     * </p>
     * <p>
     * On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
     * </p>
     * 
     * @return The port on which the load balancer is listening.</p>
     *         <p>
     *         On EC2-VPC, you can specify any port from the range 1-65535.
     *         </p>
     *         <p>
     *         On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
     */
    public final Integer loadBalancerPort() {
        return loadBalancerPort;
    }

    /**
     * <p>
     * The load balancer transport protocol to use for routing.
     * </p>
     * <p>
     * Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code>
     * </p>
     * 
     * @return The load balancer transport protocol to use for routing.</p>
     *         <p>
     *         Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code>
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The ARN of the server certificate.
     * </p>
     * 
     * @return The ARN of the server certificate.
     */
    public final String sslCertificateId() {
        return sslCertificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(sslCertificateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerListener)) {
            return false;
        }
        AwsElbLoadBalancerListener other = (AwsElbLoadBalancerListener) obj;
        return Objects.equals(instancePort(), other.instancePort())
                && Objects.equals(instanceProtocol(), other.instanceProtocol())
                && Objects.equals(loadBalancerPort(), other.loadBalancerPort()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(sslCertificateId(), other.sslCertificateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElbLoadBalancerListener").add("InstancePort", instancePort())
                .add("InstanceProtocol", instanceProtocol()).add("LoadBalancerPort", loadBalancerPort())
                .add("Protocol", protocol()).add("SslCertificateId", sslCertificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstancePort":
            return Optional.ofNullable(clazz.cast(instancePort()));
        case "InstanceProtocol":
            return Optional.ofNullable(clazz.cast(instanceProtocol()));
        case "LoadBalancerPort":
            return Optional.ofNullable(clazz.cast(loadBalancerPort()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "SslCertificateId":
            return Optional.ofNullable(clazz.cast(sslCertificateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerListener, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerListener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElbLoadBalancerListener> {
        /**
         * <p>
         * The port on which the instance is listening.
         * </p>
         * 
         * @param instancePort
         *        The port on which the instance is listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePort(Integer instancePort);

        /**
         * <p>
         * The protocol to use to route traffic to instances.
         * </p>
         * <p>
         * Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code>
         * </p>
         * 
         * @param instanceProtocol
         *        The protocol to use to route traffic to instances.</p>
         *        <p>
         *        Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProtocol(String instanceProtocol);

        /**
         * <p>
         * The port on which the load balancer is listening.
         * </p>
         * <p>
         * On EC2-VPC, you can specify any port from the range 1-65535.
         * </p>
         * <p>
         * On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
         * </p>
         * 
         * @param loadBalancerPort
         *        The port on which the load balancer is listening.</p>
         *        <p>
         *        On EC2-VPC, you can specify any port from the range 1-65535.
         *        </p>
         *        <p>
         *        On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerPort(Integer loadBalancerPort);

        /**
         * <p>
         * The load balancer transport protocol to use for routing.
         * </p>
         * <p>
         * Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code>
         * </p>
         * 
         * @param protocol
         *        The load balancer transport protocol to use for routing.</p>
         *        <p>
         *        Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The ARN of the server certificate.
         * </p>
         * 
         * @param sslCertificateId
         *        The ARN of the server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslCertificateId(String sslCertificateId);
    }

    static final class BuilderImpl implements Builder {
        private Integer instancePort;

        private String instanceProtocol;

        private Integer loadBalancerPort;

        private String protocol;

        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerListener model) {
            instancePort(model.instancePort);
            instanceProtocol(model.instanceProtocol);
            loadBalancerPort(model.loadBalancerPort);
            protocol(model.protocol);
            sslCertificateId(model.sslCertificateId);
        }

        public final Integer getInstancePort() {
            return instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public final String getInstanceProtocol() {
            return instanceProtocol;
        }

        @Override
        public final Builder instanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
            return this;
        }

        public final void setInstanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
        }

        public final Integer getLoadBalancerPort() {
            return loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getSslCertificateId() {
            return sslCertificateId;
        }

        @Override
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        public final void setSslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        @Override
        public AwsElbLoadBalancerListener build() {
            return new AwsElbLoadBalancerListener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
