/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An IAM role that the cluster can use to access other AWS services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterIamRole implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterIamRole.Builder, AwsRedshiftClusterIamRole> {
    private static final SdkField<String> APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplyStatus").getter(getter(AwsRedshiftClusterIamRole::applyStatus))
            .setter(setter(Builder::applyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyStatus").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(AwsRedshiftClusterIamRole::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLY_STATUS_FIELD,
            IAM_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applyStatus;

    private final String iamRoleArn;

    private AwsRedshiftClusterIamRole(BuilderImpl builder) {
        this.applyStatus = builder.applyStatus;
        this.iamRoleArn = builder.iamRoleArn;
    }

    /**
     * <p>
     * The status of the IAM role's association with the cluster.
     * </p>
     * <p>
     * Valid values: <code>in-sync</code> | <code>adding</code> | <code>removing</code>
     * </p>
     * 
     * @return The status of the IAM role's association with the cluster.</p>
     *         <p>
     *         Valid values: <code>in-sync</code> | <code>adding</code> | <code>removing</code>
     */
    public final String applyStatus() {
        return applyStatus;
    }

    /**
     * <p>
     * The ARN of the IAM role.
     * </p>
     * 
     * @return The ARN of the IAM role.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterIamRole)) {
            return false;
        }
        AwsRedshiftClusterIamRole other = (AwsRedshiftClusterIamRole) obj;
        return Objects.equals(applyStatus(), other.applyStatus()) && Objects.equals(iamRoleArn(), other.iamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterIamRole").add("ApplyStatus", applyStatus()).add("IamRoleArn", iamRoleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplyStatus":
            return Optional.ofNullable(clazz.cast(applyStatus()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterIamRole, T> g) {
        return obj -> g.apply((AwsRedshiftClusterIamRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterIamRole> {
        /**
         * <p>
         * The status of the IAM role's association with the cluster.
         * </p>
         * <p>
         * Valid values: <code>in-sync</code> | <code>adding</code> | <code>removing</code>
         * </p>
         * 
         * @param applyStatus
         *        The status of the IAM role's association with the cluster.</p>
         *        <p>
         *        Valid values: <code>in-sync</code> | <code>adding</code> | <code>removing</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyStatus(String applyStatus);

        /**
         * <p>
         * The ARN of the IAM role.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String applyStatus;

        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterIamRole model) {
            applyStatus(model.applyStatus);
            iamRoleArn(model.iamRoleArn);
        }

        public final String getApplyStatus() {
            return applyStatus;
        }

        @Override
        public final Builder applyStatus(String applyStatus) {
            this.applyStatus = applyStatus;
            return this;
        }

        public final void setApplyStatus(String applyStatus) {
            this.applyStatus = applyStatus;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public AwsRedshiftClusterIamRole build() {
            return new AwsRedshiftClusterIamRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
