/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the resize operation for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterResizeInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterResizeInfo.Builder, AwsRedshiftClusterResizeInfo> {
    private static final SdkField<Boolean> ALLOW_CANCEL_RESIZE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowCancelResize").getter(getter(AwsRedshiftClusterResizeInfo::allowCancelResize))
            .setter(setter(Builder::allowCancelResize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCancelResize").build()).build();

    private static final SdkField<String> RESIZE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResizeType").getter(getter(AwsRedshiftClusterResizeInfo::resizeType))
            .setter(setter(Builder::resizeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_CANCEL_RESIZE_FIELD,
            RESIZE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowCancelResize;

    private final String resizeType;

    private AwsRedshiftClusterResizeInfo(BuilderImpl builder) {
        this.allowCancelResize = builder.allowCancelResize;
        this.resizeType = builder.resizeType;
    }

    /**
     * <p>
     * Indicates whether the resize operation can be canceled.
     * </p>
     * 
     * @return Indicates whether the resize operation can be canceled.
     */
    public final Boolean allowCancelResize() {
        return allowCancelResize;
    }

    /**
     * <p>
     * The type of resize operation.
     * </p>
     * <p>
     * Valid values: <code>ClassicResize</code>
     * </p>
     * 
     * @return The type of resize operation.</p>
     *         <p>
     *         Valid values: <code>ClassicResize</code>
     */
    public final String resizeType() {
        return resizeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowCancelResize());
        hashCode = 31 * hashCode + Objects.hashCode(resizeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterResizeInfo)) {
            return false;
        }
        AwsRedshiftClusterResizeInfo other = (AwsRedshiftClusterResizeInfo) obj;
        return Objects.equals(allowCancelResize(), other.allowCancelResize()) && Objects.equals(resizeType(), other.resizeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterResizeInfo").add("AllowCancelResize", allowCancelResize())
                .add("ResizeType", resizeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowCancelResize":
            return Optional.ofNullable(clazz.cast(allowCancelResize()));
        case "ResizeType":
            return Optional.ofNullable(clazz.cast(resizeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterResizeInfo, T> g) {
        return obj -> g.apply((AwsRedshiftClusterResizeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterResizeInfo> {
        /**
         * <p>
         * Indicates whether the resize operation can be canceled.
         * </p>
         * 
         * @param allowCancelResize
         *        Indicates whether the resize operation can be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCancelResize(Boolean allowCancelResize);

        /**
         * <p>
         * The type of resize operation.
         * </p>
         * <p>
         * Valid values: <code>ClassicResize</code>
         * </p>
         * 
         * @param resizeType
         *        The type of resize operation.</p>
         *        <p>
         *        Valid values: <code>ClassicResize</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resizeType(String resizeType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowCancelResize;

        private String resizeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterResizeInfo model) {
            allowCancelResize(model.allowCancelResize);
            resizeType(model.resizeType);
        }

        public final Boolean getAllowCancelResize() {
            return allowCancelResize;
        }

        @Override
        public final Builder allowCancelResize(Boolean allowCancelResize) {
            this.allowCancelResize = allowCancelResize;
            return this;
        }

        public final void setAllowCancelResize(Boolean allowCancelResize) {
            this.allowCancelResize = allowCancelResize;
        }

        public final String getResizeType() {
            return resizeType;
        }

        @Override
        public final Builder resizeType(String resizeType) {
            this.resizeType = resizeType;
            return this;
        }

        public final void setResizeType(String resizeType) {
            this.resizeType = resizeType;
        }

        @Override
        public AwsRedshiftClusterResizeInfo build() {
            return new AwsRedshiftClusterResizeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
