/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * provides information about the Amazon S3 Public Access Block configuration for accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3AccountPublicAccessBlockDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3AccountPublicAccessBlockDetails.Builder, AwsS3AccountPublicAccessBlockDetails> {
    private static final SdkField<Boolean> BLOCK_PUBLIC_ACLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BlockPublicAcls").getter(getter(AwsS3AccountPublicAccessBlockDetails::blockPublicAcls))
            .setter(setter(Builder::blockPublicAcls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicAcls").build()).build();

    private static final SdkField<Boolean> BLOCK_PUBLIC_POLICY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BlockPublicPolicy").getter(getter(AwsS3AccountPublicAccessBlockDetails::blockPublicPolicy))
            .setter(setter(Builder::blockPublicPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicPolicy").build()).build();

    private static final SdkField<Boolean> IGNORE_PUBLIC_ACLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IgnorePublicAcls").getter(getter(AwsS3AccountPublicAccessBlockDetails::ignorePublicAcls))
            .setter(setter(Builder::ignorePublicAcls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnorePublicAcls").build()).build();

    private static final SdkField<Boolean> RESTRICT_PUBLIC_BUCKETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RestrictPublicBuckets").getter(getter(AwsS3AccountPublicAccessBlockDetails::restrictPublicBuckets))
            .setter(setter(Builder::restrictPublicBuckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictPublicBuckets").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_PUBLIC_ACLS_FIELD,
            BLOCK_PUBLIC_POLICY_FIELD, IGNORE_PUBLIC_ACLS_FIELD, RESTRICT_PUBLIC_BUCKETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean blockPublicAcls;

    private final Boolean blockPublicPolicy;

    private final Boolean ignorePublicAcls;

    private final Boolean restrictPublicBuckets;

    private AwsS3AccountPublicAccessBlockDetails(BuilderImpl builder) {
        this.blockPublicAcls = builder.blockPublicAcls;
        this.blockPublicPolicy = builder.blockPublicPolicy;
        this.ignorePublicAcls = builder.ignorePublicAcls;
        this.restrictPublicBuckets = builder.restrictPublicBuckets;
    }

    /**
     * <p>
     * Indicates whether to reject calls to update an S3 bucket if the calls include a public access control list (ACL).
     * </p>
     * 
     * @return Indicates whether to reject calls to update an S3 bucket if the calls include a public access control
     *         list (ACL).
     */
    public final Boolean blockPublicAcls() {
        return blockPublicAcls;
    }

    /**
     * <p>
     * Indicates whether to reject calls to update the access policy for an S3 bucket or access point if the policy
     * allows public access.
     * </p>
     * 
     * @return Indicates whether to reject calls to update the access policy for an S3 bucket or access point if the
     *         policy allows public access.
     */
    public final Boolean blockPublicPolicy() {
        return blockPublicPolicy;
    }

    /**
     * <p>
     * Indicates whether Amazon S3 ignores public ACLs that are associated with an S3 bucket.
     * </p>
     * 
     * @return Indicates whether Amazon S3 ignores public ACLs that are associated with an S3 bucket.
     */
    public final Boolean ignorePublicAcls() {
        return ignorePublicAcls;
    }

    /**
     * <p>
     * Indicates whether to restrict access to an access point or S3 bucket that has a public policy to only AWS service
     * principals and authorized users within the S3 bucket owner's account.
     * </p>
     * 
     * @return Indicates whether to restrict access to an access point or S3 bucket that has a public policy to only AWS
     *         service principals and authorized users within the S3 bucket owner's account.
     */
    public final Boolean restrictPublicBuckets() {
        return restrictPublicBuckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicAcls());
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(ignorePublicAcls());
        hashCode = 31 * hashCode + Objects.hashCode(restrictPublicBuckets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3AccountPublicAccessBlockDetails)) {
            return false;
        }
        AwsS3AccountPublicAccessBlockDetails other = (AwsS3AccountPublicAccessBlockDetails) obj;
        return Objects.equals(blockPublicAcls(), other.blockPublicAcls())
                && Objects.equals(blockPublicPolicy(), other.blockPublicPolicy())
                && Objects.equals(ignorePublicAcls(), other.ignorePublicAcls())
                && Objects.equals(restrictPublicBuckets(), other.restrictPublicBuckets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3AccountPublicAccessBlockDetails").add("BlockPublicAcls", blockPublicAcls())
                .add("BlockPublicPolicy", blockPublicPolicy()).add("IgnorePublicAcls", ignorePublicAcls())
                .add("RestrictPublicBuckets", restrictPublicBuckets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockPublicAcls":
            return Optional.ofNullable(clazz.cast(blockPublicAcls()));
        case "BlockPublicPolicy":
            return Optional.ofNullable(clazz.cast(blockPublicPolicy()));
        case "IgnorePublicAcls":
            return Optional.ofNullable(clazz.cast(ignorePublicAcls()));
        case "RestrictPublicBuckets":
            return Optional.ofNullable(clazz.cast(restrictPublicBuckets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3AccountPublicAccessBlockDetails, T> g) {
        return obj -> g.apply((AwsS3AccountPublicAccessBlockDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3AccountPublicAccessBlockDetails> {
        /**
         * <p>
         * Indicates whether to reject calls to update an S3 bucket if the calls include a public access control list
         * (ACL).
         * </p>
         * 
         * @param blockPublicAcls
         *        Indicates whether to reject calls to update an S3 bucket if the calls include a public access control
         *        list (ACL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicAcls(Boolean blockPublicAcls);

        /**
         * <p>
         * Indicates whether to reject calls to update the access policy for an S3 bucket or access point if the policy
         * allows public access.
         * </p>
         * 
         * @param blockPublicPolicy
         *        Indicates whether to reject calls to update the access policy for an S3 bucket or access point if the
         *        policy allows public access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicPolicy(Boolean blockPublicPolicy);

        /**
         * <p>
         * Indicates whether Amazon S3 ignores public ACLs that are associated with an S3 bucket.
         * </p>
         * 
         * @param ignorePublicAcls
         *        Indicates whether Amazon S3 ignores public ACLs that are associated with an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignorePublicAcls(Boolean ignorePublicAcls);

        /**
         * <p>
         * Indicates whether to restrict access to an access point or S3 bucket that has a public policy to only AWS
         * service principals and authorized users within the S3 bucket owner's account.
         * </p>
         * 
         * @param restrictPublicBuckets
         *        Indicates whether to restrict access to an access point or S3 bucket that has a public policy to only
         *        AWS service principals and authorized users within the S3 bucket owner's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictPublicBuckets(Boolean restrictPublicBuckets);
    }

    static final class BuilderImpl implements Builder {
        private Boolean blockPublicAcls;

        private Boolean blockPublicPolicy;

        private Boolean ignorePublicAcls;

        private Boolean restrictPublicBuckets;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3AccountPublicAccessBlockDetails model) {
            blockPublicAcls(model.blockPublicAcls);
            blockPublicPolicy(model.blockPublicPolicy);
            ignorePublicAcls(model.ignorePublicAcls);
            restrictPublicBuckets(model.restrictPublicBuckets);
        }

        public final Boolean getBlockPublicAcls() {
            return blockPublicAcls;
        }

        @Override
        public final Builder blockPublicAcls(Boolean blockPublicAcls) {
            this.blockPublicAcls = blockPublicAcls;
            return this;
        }

        public final void setBlockPublicAcls(Boolean blockPublicAcls) {
            this.blockPublicAcls = blockPublicAcls;
        }

        public final Boolean getBlockPublicPolicy() {
            return blockPublicPolicy;
        }

        @Override
        public final Builder blockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        public final void setBlockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
        }

        public final Boolean getIgnorePublicAcls() {
            return ignorePublicAcls;
        }

        @Override
        public final Builder ignorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
            return this;
        }

        public final void setIgnorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
        }

        public final Boolean getRestrictPublicBuckets() {
            return restrictPublicBuckets;
        }

        @Override
        public final Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
            return this;
        }

        public final void setRestrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
        }

        @Override
        public AwsS3AccountPublicAccessBlockDetails build() {
            return new AwsS3AccountPublicAccessBlockDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
