/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A wrapper type for the topic's Amazon Resource Name (ARN).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSnsTopicDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSnsTopicDetails.Builder, AwsSnsTopicDetails> {
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsMasterKeyId").getter(getter(AwsSnsTopicDetails::kmsMasterKeyId))
            .setter(setter(Builder::kmsMasterKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsMasterKeyId").build()).build();

    private static final SdkField<List<AwsSnsTopicSubscription>> SUBSCRIPTION_FIELD = SdkField
            .<List<AwsSnsTopicSubscription>> builder(MarshallingType.LIST)
            .memberName("Subscription")
            .getter(getter(AwsSnsTopicDetails::subscription))
            .setter(setter(Builder::subscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscription").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsSnsTopicSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsSnsTopicSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(AwsSnsTopicDetails::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(AwsSnsTopicDetails::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_MASTER_KEY_ID_FIELD,
            SUBSCRIPTION_FIELD, TOPIC_NAME_FIELD, OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsMasterKeyId;

    private final List<AwsSnsTopicSubscription> subscription;

    private final String topicName;

    private final String owner;

    private AwsSnsTopicDetails(BuilderImpl builder) {
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.subscription = builder.subscription;
        this.topicName = builder.topicName;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
     * </p>
     * 
     * @return The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
     */
    public final String kmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    /**
     * Returns true if the Subscription property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubscription() {
        return subscription != null && !(subscription instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubscription()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
     */
    public final List<AwsSnsTopicSubscription> subscription() {
        return subscription;
    }

    /**
     * <p>
     * The name of the topic.
     * </p>
     * 
     * @return The name of the topic.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * The subscription's owner.
     * </p>
     * 
     * @return The subscription's owner.
     */
    public final String owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscription() ? subscription() : null);
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSnsTopicDetails)) {
            return false;
        }
        AwsSnsTopicDetails other = (AwsSnsTopicDetails) obj;
        return Objects.equals(kmsMasterKeyId(), other.kmsMasterKeyId()) && hasSubscription() == other.hasSubscription()
                && Objects.equals(subscription(), other.subscription()) && Objects.equals(topicName(), other.topicName())
                && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSnsTopicDetails").add("KmsMasterKeyId", kmsMasterKeyId())
                .add("Subscription", hasSubscription() ? subscription() : null).add("TopicName", topicName())
                .add("Owner", owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsMasterKeyId":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyId()));
        case "Subscription":
            return Optional.ofNullable(clazz.cast(subscription()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSnsTopicDetails, T> g) {
        return obj -> g.apply((AwsSnsTopicDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSnsTopicDetails> {
        /**
         * <p>
         * The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
         * </p>
         * 
         * @param kmsMasterKeyId
         *        The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyId(String kmsMasterKeyId);

        /**
         * <p>
         * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * </p>
         * 
         * @param subscription
         *        Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscription(Collection<AwsSnsTopicSubscription> subscription);

        /**
         * <p>
         * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * </p>
         * 
         * @param subscription
         *        Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscription(AwsSnsTopicSubscription... subscription);

        /**
         * <p>
         * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsSnsTopicSubscription>.Builder} avoiding
         * the need to create one manually via {@link List<AwsSnsTopicSubscription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsSnsTopicSubscription>.Builder#build()} is called
         * immediately and its result is passed to {@link #subscription(List<AwsSnsTopicSubscription>)}.
         * 
         * @param subscription
         *        a consumer that will call methods on {@link List<AwsSnsTopicSubscription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscription(List<AwsSnsTopicSubscription>)
         */
        Builder subscription(Consumer<AwsSnsTopicSubscription.Builder>... subscription);

        /**
         * <p>
         * The name of the topic.
         * </p>
         * 
         * @param topicName
         *        The name of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * The subscription's owner.
         * </p>
         * 
         * @param owner
         *        The subscription's owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);
    }

    static final class BuilderImpl implements Builder {
        private String kmsMasterKeyId;

        private List<AwsSnsTopicSubscription> subscription = DefaultSdkAutoConstructList.getInstance();

        private String topicName;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSnsTopicDetails model) {
            kmsMasterKeyId(model.kmsMasterKeyId);
            subscription(model.subscription);
            topicName(model.topicName);
            owner(model.owner);
        }

        public final String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public final List<AwsSnsTopicSubscription.Builder> getSubscription() {
            List<AwsSnsTopicSubscription.Builder> result = AwsSnsTopicSubscriptionListCopier.copyToBuilder(this.subscription);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder subscription(Collection<AwsSnsTopicSubscription> subscription) {
            this.subscription = AwsSnsTopicSubscriptionListCopier.copy(subscription);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscription(AwsSnsTopicSubscription... subscription) {
            subscription(Arrays.asList(subscription));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscription(Consumer<AwsSnsTopicSubscription.Builder>... subscription) {
            subscription(Stream.of(subscription).map(c -> AwsSnsTopicSubscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubscription(Collection<AwsSnsTopicSubscription.BuilderImpl> subscription) {
            this.subscription = AwsSnsTopicSubscriptionListCopier.copyFromBuilder(subscription);
        }

        public final String getTopicName() {
            return topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public AwsSnsTopicDetails build() {
            return new AwsSnsTopicDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
