/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A finding from a <code>BatchUpdateFindings</code> request that Security Hub was unable to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFindingsUnprocessedFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdateFindingsUnprocessedFinding.Builder, BatchUpdateFindingsUnprocessedFinding> {
    private static final SdkField<AwsSecurityFindingIdentifier> FINDING_IDENTIFIER_FIELD = SdkField
            .<AwsSecurityFindingIdentifier> builder(MarshallingType.SDK_POJO).memberName("FindingIdentifier")
            .getter(getter(BatchUpdateFindingsUnprocessedFinding::findingIdentifier)).setter(setter(Builder::findingIdentifier))
            .constructor(AwsSecurityFindingIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifier").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(BatchUpdateFindingsUnprocessedFinding::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(BatchUpdateFindingsUnprocessedFinding::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIER_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsSecurityFindingIdentifier findingIdentifier;

    private final String errorCode;

    private final String errorMessage;

    private BatchUpdateFindingsUnprocessedFinding(BuilderImpl builder) {
        this.findingIdentifier = builder.findingIdentifier;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The identifier of the finding that was not updated.
     * </p>
     * 
     * @return The identifier of the finding that was not updated.
     */
    public final AwsSecurityFindingIdentifier findingIdentifier() {
        return findingIdentifier;
    }

    /**
     * <p>
     * The code associated with the error.
     * </p>
     * 
     * @return The code associated with the error.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The message associated with the error.
     * </p>
     * 
     * @return The message associated with the error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsUnprocessedFinding)) {
            return false;
        }
        BatchUpdateFindingsUnprocessedFinding other = (BatchUpdateFindingsUnprocessedFinding) obj;
        return Objects.equals(findingIdentifier(), other.findingIdentifier()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFindingsUnprocessedFinding").add("FindingIdentifier", findingIdentifier())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingIdentifier":
            return Optional.ofNullable(clazz.cast(findingIdentifier()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsUnprocessedFinding, T> g) {
        return obj -> g.apply((BatchUpdateFindingsUnprocessedFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateFindingsUnprocessedFinding> {
        /**
         * <p>
         * The identifier of the finding that was not updated.
         * </p>
         * 
         * @param findingIdentifier
         *        The identifier of the finding that was not updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifier(AwsSecurityFindingIdentifier findingIdentifier);

        /**
         * <p>
         * The identifier of the finding that was not updated.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSecurityFindingIdentifier.Builder} avoiding
         * the need to create one manually via {@link AwsSecurityFindingIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSecurityFindingIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #findingIdentifier(AwsSecurityFindingIdentifier)}.
         * 
         * @param findingIdentifier
         *        a consumer that will call methods on {@link AwsSecurityFindingIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingIdentifier(AwsSecurityFindingIdentifier)
         */
        default Builder findingIdentifier(Consumer<AwsSecurityFindingIdentifier.Builder> findingIdentifier) {
            return findingIdentifier(AwsSecurityFindingIdentifier.builder().applyMutation(findingIdentifier).build());
        }

        /**
         * <p>
         * The code associated with the error.
         * </p>
         * 
         * @param errorCode
         *        The code associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The message associated with the error.
         * </p>
         * 
         * @param errorMessage
         *        The message associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private AwsSecurityFindingIdentifier findingIdentifier;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsUnprocessedFinding model) {
            findingIdentifier(model.findingIdentifier);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final AwsSecurityFindingIdentifier.Builder getFindingIdentifier() {
            return findingIdentifier != null ? findingIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder findingIdentifier(AwsSecurityFindingIdentifier findingIdentifier) {
            this.findingIdentifier = findingIdentifier;
            return this;
        }

        public final void setFindingIdentifier(AwsSecurityFindingIdentifier.BuilderImpl findingIdentifier) {
            this.findingIdentifier = findingIdentifier != null ? findingIdentifier.build() : null;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchUpdateFindingsUnprocessedFinding build() {
            return new BatchUpdateFindingsUnprocessedFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
