/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an instance of sensitive data that was detected by a customer-defined identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomDataIdentifiersResult implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomDataIdentifiersResult.Builder, CustomDataIdentifiersResult> {
    private static final SdkField<List<CustomDataIdentifiersDetections>> DETECTIONS_FIELD = SdkField
            .<List<CustomDataIdentifiersDetections>> builder(MarshallingType.LIST)
            .memberName("Detections")
            .getter(getter(CustomDataIdentifiersResult::detections))
            .setter(setter(Builder::detections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomDataIdentifiersDetections> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomDataIdentifiersDetections::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCount").getter(getter(CustomDataIdentifiersResult::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTIONS_FIELD,
            TOTAL_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CustomDataIdentifiersDetections> detections;

    private final Long totalCount;

    private CustomDataIdentifiersResult(BuilderImpl builder) {
        this.detections = builder.detections;
        this.totalCount = builder.totalCount;
    }

    /**
     * Returns true if the Detections property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDetections() {
        return detections != null && !(detections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of detected instances of sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetections()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of detected instances of sensitive data.
     */
    public final List<CustomDataIdentifiersDetections> detections() {
        return detections;
    }

    /**
     * <p>
     * The total number of occurrences of sensitive data.
     * </p>
     * 
     * @return The total number of occurrences of sensitive data.
     */
    public final Long totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDetections() ? detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDataIdentifiersResult)) {
            return false;
        }
        CustomDataIdentifiersResult other = (CustomDataIdentifiersResult) obj;
        return hasDetections() == other.hasDetections() && Objects.equals(detections(), other.detections())
                && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomDataIdentifiersResult").add("Detections", hasDetections() ? detections() : null)
                .add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Detections":
            return Optional.ofNullable(clazz.cast(detections()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomDataIdentifiersResult, T> g) {
        return obj -> g.apply((CustomDataIdentifiersResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomDataIdentifiersResult> {
        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * 
         * @param detections
         *        The list of detected instances of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detections(Collection<CustomDataIdentifiersDetections> detections);

        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * 
         * @param detections
         *        The list of detected instances of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detections(CustomDataIdentifiersDetections... detections);

        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomDataIdentifiersDetections>.Builder}
         * avoiding the need to create one manually via {@link List<CustomDataIdentifiersDetections>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomDataIdentifiersDetections>.Builder#build()} is called
         * immediately and its result is passed to {@link #detections(List<CustomDataIdentifiersDetections>)}.
         * 
         * @param detections
         *        a consumer that will call methods on {@link List<CustomDataIdentifiersDetections>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detections(List<CustomDataIdentifiersDetections>)
         */
        Builder detections(Consumer<CustomDataIdentifiersDetections.Builder>... detections);

        /**
         * <p>
         * The total number of occurrences of sensitive data.
         * </p>
         * 
         * @param totalCount
         *        The total number of occurrences of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);
    }

    static final class BuilderImpl implements Builder {
        private List<CustomDataIdentifiersDetections> detections = DefaultSdkAutoConstructList.getInstance();

        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDataIdentifiersResult model) {
            detections(model.detections);
            totalCount(model.totalCount);
        }

        public final List<CustomDataIdentifiersDetections.Builder> getDetections() {
            List<CustomDataIdentifiersDetections.Builder> result = CustomDataIdentifiersDetectionsListCopier
                    .copyToBuilder(this.detections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder detections(Collection<CustomDataIdentifiersDetections> detections) {
            this.detections = CustomDataIdentifiersDetectionsListCopier.copy(detections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(CustomDataIdentifiersDetections... detections) {
            detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Consumer<CustomDataIdentifiersDetections.Builder>... detections) {
            detections(Stream.of(detections).map(c -> CustomDataIdentifiersDetections.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDetections(Collection<CustomDataIdentifiersDetections.BuilderImpl> detections) {
            this.detections = CustomDataIdentifiersDetectionsListCopier.copyFromBuilder(detections);
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public CustomDataIdentifiersResult build() {
            return new CustomDataIdentifiersResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
