/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CVSS scores from the advisory related to the vulnerability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cvss implements SdkPojo, Serializable, ToCopyableBuilder<Cvss.Builder, Cvss> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(Cvss::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Double> BASE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BaseScore").getter(getter(Cvss::baseScore)).setter(setter(Builder::baseScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseScore").build()).build();

    private static final SdkField<String> BASE_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseVector").getter(getter(Cvss::baseVector)).setter(setter(Builder::baseVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseVector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD,
            BASE_SCORE_FIELD, BASE_VECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String version;

    private final Double baseScore;

    private final String baseVector;

    private Cvss(BuilderImpl builder) {
        this.version = builder.version;
        this.baseScore = builder.baseScore;
        this.baseVector = builder.baseVector;
    }

    /**
     * <p>
     * The version of CVSS for the CVSS score.
     * </p>
     * 
     * @return The version of CVSS for the CVSS score.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The base CVSS score.
     * </p>
     * 
     * @return The base CVSS score.
     */
    public final Double baseScore() {
        return baseScore;
    }

    /**
     * <p>
     * The base scoring vector for the CVSS score.
     * </p>
     * 
     * @return The base scoring vector for the CVSS score.
     */
    public final String baseVector() {
        return baseVector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(baseScore());
        hashCode = 31 * hashCode + Objects.hashCode(baseVector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cvss)) {
            return false;
        }
        Cvss other = (Cvss) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(baseScore(), other.baseScore())
                && Objects.equals(baseVector(), other.baseVector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cvss").add("Version", version()).add("BaseScore", baseScore()).add("BaseVector", baseVector())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "BaseScore":
            return Optional.ofNullable(clazz.cast(baseScore()));
        case "BaseVector":
            return Optional.ofNullable(clazz.cast(baseVector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cvss, T> g) {
        return obj -> g.apply((Cvss) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cvss> {
        /**
         * <p>
         * The version of CVSS for the CVSS score.
         * </p>
         * 
         * @param version
         *        The version of CVSS for the CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The base CVSS score.
         * </p>
         * 
         * @param baseScore
         *        The base CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseScore(Double baseScore);

        /**
         * <p>
         * The base scoring vector for the CVSS score.
         * </p>
         * 
         * @param baseVector
         *        The base scoring vector for the CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseVector(String baseVector);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private Double baseScore;

        private String baseVector;

        private BuilderImpl() {
        }

        private BuilderImpl(Cvss model) {
            version(model.version);
            baseScore(model.baseScore);
            baseVector(model.baseVector);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Double getBaseScore() {
            return baseScore;
        }

        @Override
        public final Builder baseScore(Double baseScore) {
            this.baseScore = baseScore;
            return this;
        }

        public final void setBaseScore(Double baseScore) {
            this.baseScore = baseScore;
        }

        public final String getBaseVector() {
            return baseVector;
        }

        @Override
        public final Builder baseVector(String baseVector) {
            this.baseVector = baseVector;
            return this;
        }

        public final void setBaseVector(String baseVector) {
            this.baseVector = baseVector;
        }

        @Override
        public Cvss build() {
            return new Cvss(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
