/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about sensitive data that was detected on a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataClassificationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DataClassificationDetails.Builder, DataClassificationDetails> {
    private static final SdkField<String> DETAILED_RESULTS_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedResultsLocation").getter(getter(DataClassificationDetails::detailedResultsLocation))
            .setter(setter(Builder::detailedResultsLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedResultsLocation").build())
            .build();

    private static final SdkField<ClassificationResult> RESULT_FIELD = SdkField
            .<ClassificationResult> builder(MarshallingType.SDK_POJO).memberName("Result")
            .getter(getter(DataClassificationDetails::result)).setter(setter(Builder::result))
            .constructor(ClassificationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DETAILED_RESULTS_LOCATION_FIELD, RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detailedResultsLocation;

    private final ClassificationResult result;

    private DataClassificationDetails(BuilderImpl builder) {
        this.detailedResultsLocation = builder.detailedResultsLocation;
        this.result = builder.result;
    }

    /**
     * <p>
     * The path to the folder or file that contains the sensitive data.
     * </p>
     * 
     * @return The path to the folder or file that contains the sensitive data.
     */
    public final String detailedResultsLocation() {
        return detailedResultsLocation;
    }

    /**
     * <p>
     * The details about the sensitive data that was detected on the resource.
     * </p>
     * 
     * @return The details about the sensitive data that was detected on the resource.
     */
    public final ClassificationResult result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailedResultsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataClassificationDetails)) {
            return false;
        }
        DataClassificationDetails other = (DataClassificationDetails) obj;
        return Objects.equals(detailedResultsLocation(), other.detailedResultsLocation())
                && Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataClassificationDetails").add("DetailedResultsLocation", detailedResultsLocation())
                .add("Result", result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetailedResultsLocation":
            return Optional.ofNullable(clazz.cast(detailedResultsLocation()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataClassificationDetails, T> g) {
        return obj -> g.apply((DataClassificationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataClassificationDetails> {
        /**
         * <p>
         * The path to the folder or file that contains the sensitive data.
         * </p>
         * 
         * @param detailedResultsLocation
         *        The path to the folder or file that contains the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedResultsLocation(String detailedResultsLocation);

        /**
         * <p>
         * The details about the sensitive data that was detected on the resource.
         * </p>
         * 
         * @param result
         *        The details about the sensitive data that was detected on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(ClassificationResult result);

        /**
         * <p>
         * The details about the sensitive data that was detected on the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ClassificationResult.Builder} avoiding the need
         * to create one manually via {@link ClassificationResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClassificationResult.Builder#build()} is called immediately and
         * its result is passed to {@link #result(ClassificationResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link ClassificationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(ClassificationResult)
         */
        default Builder result(Consumer<ClassificationResult.Builder> result) {
            return result(ClassificationResult.builder().applyMutation(result).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String detailedResultsLocation;

        private ClassificationResult result;

        private BuilderImpl() {
        }

        private BuilderImpl(DataClassificationDetails model) {
            detailedResultsLocation(model.detailedResultsLocation);
            result(model.result);
        }

        public final String getDetailedResultsLocation() {
            return detailedResultsLocation;
        }

        @Override
        public final Builder detailedResultsLocation(String detailedResultsLocation) {
            this.detailedResultsLocation = detailedResultsLocation;
            return this;
        }

        public final void setDetailedResultsLocation(String detailedResultsLocation) {
            this.detailedResultsLocation = detailedResultsLocation;
        }

        public final ClassificationResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        @Override
        public final Builder result(ClassificationResult result) {
            this.result = result;
            return this;
        }

        public final void setResult(ClassificationResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public DataClassificationDetails build() {
            return new DataClassificationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
