/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHubResponse extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeHubResponse.Builder, DescribeHubResponse> {
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HubArn")
            .getter(getter(DescribeHubResponse::hubArn)).setter(setter(Builder::hubArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()).build();

    private static final SdkField<String> SUBSCRIBED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscribedAt").getter(getter(DescribeHubResponse::subscribedAt)).setter(setter(Builder::subscribedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedAt").build()).build();

    private static final SdkField<Boolean> AUTO_ENABLE_CONTROLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnableControls").getter(getter(DescribeHubResponse::autoEnableControls))
            .setter(setter(Builder::autoEnableControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableControls").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_ARN_FIELD,
            SUBSCRIBED_AT_FIELD, AUTO_ENABLE_CONTROLS_FIELD));

    private final String hubArn;

    private final String subscribedAt;

    private final Boolean autoEnableControls;

    private DescribeHubResponse(BuilderImpl builder) {
        super(builder);
        this.hubArn = builder.hubArn;
        this.subscribedAt = builder.subscribedAt;
        this.autoEnableControls = builder.autoEnableControls;
    }

    /**
     * <p>
     * The ARN of the Hub resource that was retrieved.
     * </p>
     * 
     * @return The ARN of the Hub resource that was retrieved.
     */
    public final String hubArn() {
        return hubArn;
    }

    /**
     * <p>
     * The date and time when Security Hub was enabled in the account.
     * </p>
     * 
     * @return The date and time when Security Hub was enabled in the account.
     */
    public final String subscribedAt() {
        return subscribedAt;
    }

    /**
     * <p>
     * Whether to automatically enable new controls when they are added to standards that are enabled.
     * </p>
     * <p>
     * If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to
     * <code>false</code>, then new controls are not enabled.
     * </p>
     * 
     * @return Whether to automatically enable new controls when they are added to standards that are enabled.</p>
     *         <p>
     *         If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to
     *         <code>false</code>, then new controls are not enabled.
     */
    public final Boolean autoEnableControls() {
        return autoEnableControls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedAt());
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableControls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHubResponse)) {
            return false;
        }
        DescribeHubResponse other = (DescribeHubResponse) obj;
        return Objects.equals(hubArn(), other.hubArn()) && Objects.equals(subscribedAt(), other.subscribedAt())
                && Objects.equals(autoEnableControls(), other.autoEnableControls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHubResponse").add("HubArn", hubArn()).add("SubscribedAt", subscribedAt())
                .add("AutoEnableControls", autoEnableControls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubArn":
            return Optional.ofNullable(clazz.cast(hubArn()));
        case "SubscribedAt":
            return Optional.ofNullable(clazz.cast(subscribedAt()));
        case "AutoEnableControls":
            return Optional.ofNullable(clazz.cast(autoEnableControls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHubResponse, T> g) {
        return obj -> g.apply((DescribeHubResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHubResponse> {
        /**
         * <p>
         * The ARN of the Hub resource that was retrieved.
         * </p>
         * 
         * @param hubArn
         *        The ARN of the Hub resource that was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubArn(String hubArn);

        /**
         * <p>
         * The date and time when Security Hub was enabled in the account.
         * </p>
         * 
         * @param subscribedAt
         *        The date and time when Security Hub was enabled in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedAt(String subscribedAt);

        /**
         * <p>
         * Whether to automatically enable new controls when they are added to standards that are enabled.
         * </p>
         * <p>
         * If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to
         * <code>false</code>, then new controls are not enabled.
         * </p>
         * 
         * @param autoEnableControls
         *        Whether to automatically enable new controls when they are added to standards that are enabled.</p>
         *        <p>
         *        If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set
         *        to <code>false</code>, then new controls are not enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableControls(Boolean autoEnableControls);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String hubArn;

        private String subscribedAt;

        private Boolean autoEnableControls;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHubResponse model) {
            super(model);
            hubArn(model.hubArn);
            subscribedAt(model.subscribedAt);
            autoEnableControls(model.autoEnableControls);
        }

        public final String getHubArn() {
            return hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        public final String getSubscribedAt() {
            return subscribedAt;
        }

        @Override
        public final Builder subscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        public final void setSubscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        public final Boolean getAutoEnableControls() {
            return autoEnableControls;
        }

        @Override
        public final Builder autoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
            return this;
        }

        public final void setAutoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
        }

        @Override
        public DescribeHubResponse build() {
            return new DescribeHubResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
