/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The severity assigned to the finding by the finding provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingProviderSeverity implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingProviderSeverity.Builder, FindingProviderSeverity> {
    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(FindingProviderSeverity::labelAsString)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> ORIGINAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Original").getter(getter(FindingProviderSeverity::original)).setter(setter(Builder::original))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Original").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD, ORIGINAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String label;

    private final String original;

    private FindingProviderSeverity(BuilderImpl builder) {
        this.label = builder.label;
        this.original = builder.original;
    }

    /**
     * <p>
     * The severity label assigned to the finding by the finding provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #label} will return
     * {@link SeverityLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelAsString}.
     * </p>
     * 
     * @return The severity label assigned to the finding by the finding provider.
     * @see SeverityLabel
     */
    public final SeverityLabel label() {
        return SeverityLabel.fromValue(label);
    }

    /**
     * <p>
     * The severity label assigned to the finding by the finding provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #label} will return
     * {@link SeverityLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelAsString}.
     * </p>
     * 
     * @return The severity label assigned to the finding by the finding provider.
     * @see SeverityLabel
     */
    public final String labelAsString() {
        return label;
    }

    /**
     * <p>
     * The finding provider's original value for the severity.
     * </p>
     * 
     * @return The finding provider's original value for the severity.
     */
    public final String original() {
        return original;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(original());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingProviderSeverity)) {
            return false;
        }
        FindingProviderSeverity other = (FindingProviderSeverity) obj;
        return Objects.equals(labelAsString(), other.labelAsString()) && Objects.equals(original(), other.original());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingProviderSeverity").add("Label", labelAsString()).add("Original", original()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Label":
            return Optional.ofNullable(clazz.cast(labelAsString()));
        case "Original":
            return Optional.ofNullable(clazz.cast(original()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingProviderSeverity, T> g) {
        return obj -> g.apply((FindingProviderSeverity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingProviderSeverity> {
        /**
         * <p>
         * The severity label assigned to the finding by the finding provider.
         * </p>
         * 
         * @param label
         *        The severity label assigned to the finding by the finding provider.
         * @see SeverityLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityLabel
         */
        Builder label(String label);

        /**
         * <p>
         * The severity label assigned to the finding by the finding provider.
         * </p>
         * 
         * @param label
         *        The severity label assigned to the finding by the finding provider.
         * @see SeverityLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityLabel
         */
        Builder label(SeverityLabel label);

        /**
         * <p>
         * The finding provider's original value for the severity.
         * </p>
         * 
         * @param original
         *        The finding provider's original value for the severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder original(String original);
    }

    static final class BuilderImpl implements Builder {
        private String label;

        private String original;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingProviderSeverity model) {
            label(model.label);
            original(model.original);
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public final Builder label(SeverityLabel label) {
            this.label(label == null ? null : label.toString());
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final String getOriginal() {
            return original;
        }

        @Override
        public final Builder original(String original) {
            this.original = original;
            return this;
        }

        public final void setOriginal(String original) {
            this.original = original;
        }

        @Override
        public FindingProviderSeverity build() {
            return new FindingProviderSeverity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
