/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a network path component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkPathComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkPathComponent.Builder, NetworkPathComponent> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentId").getter(getter(NetworkPathComponent::componentId)).setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentType").getter(getter(NetworkPathComponent::componentType))
            .setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentType").build()).build();

    private static final SdkField<NetworkHeader> EGRESS_FIELD = SdkField.<NetworkHeader> builder(MarshallingType.SDK_POJO)
            .memberName("Egress").getter(getter(NetworkPathComponent::egress)).setter(setter(Builder::egress))
            .constructor(NetworkHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress").build()).build();

    private static final SdkField<NetworkHeader> INGRESS_FIELD = SdkField.<NetworkHeader> builder(MarshallingType.SDK_POJO)
            .memberName("Ingress").getter(getter(NetworkPathComponent::ingress)).setter(setter(Builder::ingress))
            .constructor(NetworkHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ingress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD,
            COMPONENT_TYPE_FIELD, EGRESS_FIELD, INGRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentId;

    private final String componentType;

    private final NetworkHeader egress;

    private final NetworkHeader ingress;

    private NetworkPathComponent(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.componentType = builder.componentType;
        this.egress = builder.egress;
        this.ingress = builder.ingress;
    }

    /**
     * <p>
     * The identifier of a component in the network path.
     * </p>
     * 
     * @return The identifier of a component in the network path.
     */
    public final String componentId() {
        return componentId;
    }

    /**
     * <p>
     * The type of component.
     * </p>
     * 
     * @return The type of component.
     */
    public final String componentType() {
        return componentType;
    }

    /**
     * <p>
     * Information about the component that comes after the current component in the network path.
     * </p>
     * 
     * @return Information about the component that comes after the current component in the network path.
     */
    public final NetworkHeader egress() {
        return egress;
    }

    /**
     * <p>
     * Information about the component that comes before the current node in the network path.
     * </p>
     * 
     * @return Information about the component that comes before the current node in the network path.
     */
    public final NetworkHeader ingress() {
        return ingress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentId());
        hashCode = 31 * hashCode + Objects.hashCode(componentType());
        hashCode = 31 * hashCode + Objects.hashCode(egress());
        hashCode = 31 * hashCode + Objects.hashCode(ingress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkPathComponent)) {
            return false;
        }
        NetworkPathComponent other = (NetworkPathComponent) obj;
        return Objects.equals(componentId(), other.componentId()) && Objects.equals(componentType(), other.componentType())
                && Objects.equals(egress(), other.egress()) && Objects.equals(ingress(), other.ingress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkPathComponent").add("ComponentId", componentId()).add("ComponentType", componentType())
                .add("Egress", egress()).add("Ingress", ingress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "ComponentType":
            return Optional.ofNullable(clazz.cast(componentType()));
        case "Egress":
            return Optional.ofNullable(clazz.cast(egress()));
        case "Ingress":
            return Optional.ofNullable(clazz.cast(ingress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkPathComponent, T> g) {
        return obj -> g.apply((NetworkPathComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkPathComponent> {
        /**
         * <p>
         * The identifier of a component in the network path.
         * </p>
         * 
         * @param componentId
         *        The identifier of a component in the network path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(String componentId);

        /**
         * <p>
         * The type of component.
         * </p>
         * 
         * @param componentType
         *        The type of component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(String componentType);

        /**
         * <p>
         * Information about the component that comes after the current component in the network path.
         * </p>
         * 
         * @param egress
         *        Information about the component that comes after the current component in the network path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(NetworkHeader egress);

        /**
         * <p>
         * Information about the component that comes after the current component in the network path.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkHeader.Builder} avoiding the need to
         * create one manually via {@link NetworkHeader#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #egress(NetworkHeader)}.
         * 
         * @param egress
         *        a consumer that will call methods on {@link NetworkHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egress(NetworkHeader)
         */
        default Builder egress(Consumer<NetworkHeader.Builder> egress) {
            return egress(NetworkHeader.builder().applyMutation(egress).build());
        }

        /**
         * <p>
         * Information about the component that comes before the current node in the network path.
         * </p>
         * 
         * @param ingress
         *        Information about the component that comes before the current node in the network path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingress(NetworkHeader ingress);

        /**
         * <p>
         * Information about the component that comes before the current node in the network path.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkHeader.Builder} avoiding the need to
         * create one manually via {@link NetworkHeader#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #ingress(NetworkHeader)}.
         * 
         * @param ingress
         *        a consumer that will call methods on {@link NetworkHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingress(NetworkHeader)
         */
        default Builder ingress(Consumer<NetworkHeader.Builder> ingress) {
            return ingress(NetworkHeader.builder().applyMutation(ingress).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String componentId;

        private String componentType;

        private NetworkHeader egress;

        private NetworkHeader ingress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkPathComponent model) {
            componentId(model.componentId);
            componentType(model.componentType);
            egress(model.egress);
            ingress(model.ingress);
        }

        public final String getComponentId() {
            return componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        public final String getComponentType() {
            return componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        public final NetworkHeader.Builder getEgress() {
            return egress != null ? egress.toBuilder() : null;
        }

        @Override
        public final Builder egress(NetworkHeader egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(NetworkHeader.BuilderImpl egress) {
            this.egress = egress != null ? egress.build() : null;
        }

        public final NetworkHeader.Builder getIngress() {
            return ingress != null ? ingress.toBuilder() : null;
        }

        @Override
        public final Builder ingress(NetworkHeader ingress) {
            this.ingress = ingress;
            return this;
        }

        public final void setIngress(NetworkHeader.BuilderImpl ingress) {
            this.ingress = ingress != null ? ingress.build() : null;
        }

        @Override
        public NetworkPathComponent build() {
            return new NetworkPathComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
