/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStandardsControlRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateStandardsControlRequest.Builder, UpdateStandardsControlRequest> {
    private static final SdkField<String> STANDARDS_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsControlArn").getter(getter(UpdateStandardsControlRequest::standardsControlArn))
            .setter(setter(Builder::standardsControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("StandardsControlArn").build())
            .build();

    private static final SdkField<String> CONTROL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlStatus").getter(getter(UpdateStandardsControlRequest::controlStatusAsString))
            .setter(setter(Builder::controlStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlStatus").build()).build();

    private static final SdkField<String> DISABLED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisabledReason").getter(getter(UpdateStandardsControlRequest::disabledReason))
            .setter(setter(Builder::disabledReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_CONTROL_ARN_FIELD,
            CONTROL_STATUS_FIELD, DISABLED_REASON_FIELD));

    private final String standardsControlArn;

    private final String controlStatus;

    private final String disabledReason;

    private UpdateStandardsControlRequest(BuilderImpl builder) {
        super(builder);
        this.standardsControlArn = builder.standardsControlArn;
        this.controlStatus = builder.controlStatus;
        this.disabledReason = builder.disabledReason;
    }

    /**
     * <p>
     * The ARN of the security standard control to enable or disable.
     * </p>
     * 
     * @return The ARN of the security standard control to enable or disable.
     */
    public final String standardsControlArn() {
        return standardsControlArn;
    }

    /**
     * <p>
     * The updated status of the security standard control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #controlStatus}
     * will return {@link ControlStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #controlStatusAsString}.
     * </p>
     * 
     * @return The updated status of the security standard control.
     * @see ControlStatus
     */
    public final ControlStatus controlStatus() {
        return ControlStatus.fromValue(controlStatus);
    }

    /**
     * <p>
     * The updated status of the security standard control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #controlStatus}
     * will return {@link ControlStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #controlStatusAsString}.
     * </p>
     * 
     * @return The updated status of the security standard control.
     * @see ControlStatus
     */
    public final String controlStatusAsString() {
        return controlStatus;
    }

    /**
     * <p>
     * A description of the reason why you are disabling a security standard control. If you are disabling a control,
     * then this is required.
     * </p>
     * 
     * @return A description of the reason why you are disabling a security standard control. If you are disabling a
     *         control, then this is required.
     */
    public final String disabledReason() {
        return disabledReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(standardsControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(controlStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(disabledReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStandardsControlRequest)) {
            return false;
        }
        UpdateStandardsControlRequest other = (UpdateStandardsControlRequest) obj;
        return Objects.equals(standardsControlArn(), other.standardsControlArn())
                && Objects.equals(controlStatusAsString(), other.controlStatusAsString())
                && Objects.equals(disabledReason(), other.disabledReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStandardsControlRequest").add("StandardsControlArn", standardsControlArn())
                .add("ControlStatus", controlStatusAsString()).add("DisabledReason", disabledReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsControlArn":
            return Optional.ofNullable(clazz.cast(standardsControlArn()));
        case "ControlStatus":
            return Optional.ofNullable(clazz.cast(controlStatusAsString()));
        case "DisabledReason":
            return Optional.ofNullable(clazz.cast(disabledReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStandardsControlRequest, T> g) {
        return obj -> g.apply((UpdateStandardsControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStandardsControlRequest> {
        /**
         * <p>
         * The ARN of the security standard control to enable or disable.
         * </p>
         * 
         * @param standardsControlArn
         *        The ARN of the security standard control to enable or disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsControlArn(String standardsControlArn);

        /**
         * <p>
         * The updated status of the security standard control.
         * </p>
         * 
         * @param controlStatus
         *        The updated status of the security standard control.
         * @see ControlStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlStatus
         */
        Builder controlStatus(String controlStatus);

        /**
         * <p>
         * The updated status of the security standard control.
         * </p>
         * 
         * @param controlStatus
         *        The updated status of the security standard control.
         * @see ControlStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlStatus
         */
        Builder controlStatus(ControlStatus controlStatus);

        /**
         * <p>
         * A description of the reason why you are disabling a security standard control. If you are disabling a
         * control, then this is required.
         * </p>
         * 
         * @param disabledReason
         *        A description of the reason why you are disabling a security standard control. If you are disabling a
         *        control, then this is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledReason(String disabledReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String standardsControlArn;

        private String controlStatus;

        private String disabledReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStandardsControlRequest model) {
            super(model);
            standardsControlArn(model.standardsControlArn);
            controlStatus(model.controlStatus);
            disabledReason(model.disabledReason);
        }

        public final String getStandardsControlArn() {
            return standardsControlArn;
        }

        @Override
        public final Builder standardsControlArn(String standardsControlArn) {
            this.standardsControlArn = standardsControlArn;
            return this;
        }

        public final void setStandardsControlArn(String standardsControlArn) {
            this.standardsControlArn = standardsControlArn;
        }

        public final String getControlStatus() {
            return controlStatus;
        }

        @Override
        public final Builder controlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
            return this;
        }

        @Override
        public final Builder controlStatus(ControlStatus controlStatus) {
            this.controlStatus(controlStatus == null ? null : controlStatus.toString());
            return this;
        }

        public final void setControlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
        }

        public final String getDisabledReason() {
            return disabledReason;
        }

        @Override
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStandardsControlRequest build() {
            return new UpdateStandardsControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
