/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest;
import software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationResponse;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.CreateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.CreateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.CreateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.CreateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeHubRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeHubResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromAdministratorAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromAdministratorAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountRequest;
import software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountResponse;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMembersRequest;
import software.amazon.awssdk.services.securityhub.model.GetMembersResponse;
import software.amazon.awssdk.services.securityhub.model.InviteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.InviteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.ListMembersRequest;
import software.amazon.awssdk.services.securityhub.model.ListMembersResponse;
import software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityhub.model.TagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.TagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlResponse;
import software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher;
import software.amazon.awssdk.services.securityhub.paginators.ListInvitationsPublisher;
import software.amazon.awssdk.services.securityhub.paginators.ListMembersPublisher;
import software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsPublisher;

/**
 * Service client for accessing AWS SecurityHub asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Security Hub provides you with a comprehensive view of the security state of your AWS environment and resources. It
 * also provides you with the readiness status of your environment based on controls from supported security standards.
 * Security Hub collects security data from AWS accounts, services, and integrated third-party products and helps you
 * analyze security trends in your environment to identify the highest priority security issues. For more information
 * about Security Hub, see the <i> <a
 * href="https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html">AWS Security Hub User
 * Guide</a> </i>.
 * </p>
 * <p>
 * When you use operations in the Security Hub API, the requests are executed only in the AWS Region that is currently
 * active or in the specific AWS Region that you specify in your request. Any configuration or settings change that
 * results from the operation is applied only to that Region. To make the same change in other Regions, execute the same
 * command for each Region to apply the change to.
 * </p>
 * <p>
 * For example, if your Region is set to <code>us-west-2</code>, when you use <code> <a>CreateMembers</a> </code> to add
 * a member account to Security Hub, the association of the member account with the administrator account is created
 * only in the <code>us-west-2</code> Region. Security Hub must be enabled for the member account in the same Region
 * that the invitation was sent from.
 * </p>
 * <p>
 * The following throttling limits apply to using Security Hub API operations.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code> <a>BatchEnableStandards</a> </code> - <code>RateLimit</code> of 1 request per second, <code>BurstLimit</code>
 * of 1 request per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code> <a>GetFindings</a> </code> - <code>RateLimit</code> of 3 requests per second. <code>BurstLimit</code> of 6
 * requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code> <a>UpdateFindings</a> </code> - <code>RateLimit</code> of 1 request per second. <code>BurstLimit</code> of 5
 * requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code> <a>UpdateStandardsControl</a> </code> - <code>RateLimit</code> of 1 request per second,
 * <code>BurstLimit</code> of 5 requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * All other operations - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30 requests per
 * second.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SecurityHubAsyncClient extends SdkClient {
    String SERVICE_NAME = "securityhub";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "securityhub";

    /**
     * Create a {@link SecurityHubAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecurityHubAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecurityHubAsyncClient}.
     */
    static SecurityHubAsyncClientBuilder builder() {
        return new DefaultSecurityHubAsyncClientBuilder();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     * @return A Java Future containing the result of the AcceptAdministratorInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptAdministratorInvitationResponse> acceptAdministratorInvitation(
            AcceptAdministratorInvitationRequest acceptAdministratorInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAdministratorInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptAdministratorInvitationRequest#builder()}
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptAdministratorInvitationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AcceptAdministratorInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptAdministratorInvitationResponse> acceptAdministratorInvitation(
            Consumer<AcceptAdministratorInvitationRequest.Builder> acceptAdministratorInvitationRequest) {
        return acceptAdministratorInvitation(AcceptAdministratorInvitationRequest.builder()
                .applyMutation(acceptAdministratorInvitationRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>AcceptInvitation</code>. It will eventually change to use
     * <code>AcceptAdministratorInvitation</code>. Any IAM policies that specifically control access to this function
     * must continue to use <code>AcceptInvitation</code>. You should also add
     * <code>AcceptAdministratorInvitation</code> to your policies to ensure that the correct permissions are in place
     * after the console begins to use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptInvitationResponse> acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>AcceptInvitation</code>. It will eventually change to use
     * <code>AcceptAdministratorInvitation</code>. Any IAM policies that specifically control access to this function
     * must continue to use <code>AcceptInvitation</code>. You should also add
     * <code>AcceptAdministratorInvitation</code> to your policies to ensure that the correct permissions are in place
     * after the console begins to use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptInvitationRequest#builder()}
     * </p>
     *
     * @param acceptInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptInvitationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptInvitationResponse> acceptInvitation(
            Consumer<AcceptInvitationRequest.Builder> acceptInvitationRequest) {
        return acceptInvitation(AcceptInvitationRequest.builder().applyMutation(acceptInvitationRequest).build());
    }

    /**
     * <p>
     * Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>AWS Security Hub User Guide</i>.
     * </p>
     *
     * @param batchDisableStandardsRequest
     * @return A Java Future containing the result of the BatchDisableStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchDisableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisableStandardsResponse> batchDisableStandards(
            BatchDisableStandardsRequest batchDisableStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>AWS Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisableStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDisableStandardsRequest#builder()}
     * </p>
     *
     * @param batchDisableStandardsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDisableStandardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDisableStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchDisableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisableStandardsResponse> batchDisableStandards(
            Consumer<BatchDisableStandardsRequest.Builder> batchDisableStandardsRequest) {
        return batchDisableStandards(BatchDisableStandardsRequest.builder().applyMutation(batchDisableStandardsRequest).build());
    }

    /**
     * <p>
     * Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use
     * the <code> <a>DescribeStandards</a> </code> operation.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>AWS Security Hub User Guide</i>.
     * </p>
     *
     * @param batchEnableStandardsRequest
     * @return A Java Future containing the result of the BatchEnableStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchEnableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchEnableStandardsResponse> batchEnableStandards(
            BatchEnableStandardsRequest batchEnableStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use
     * the <code> <a>DescribeStandards</a> </code> operation.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>AWS Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEnableStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchEnableStandardsRequest#builder()}
     * </p>
     *
     * @param batchEnableStandardsRequest
     *        A {@link Consumer} that will call methods on {@link BatchEnableStandardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchEnableStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchEnableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchEnableStandardsResponse> batchEnableStandards(
            Consumer<BatchEnableStandardsRequest.Builder> batchEnableStandardsRequest) {
        return batchEnableStandards(BatchEnableStandardsRequest.builder().applyMutation(batchEnableStandardsRequest).build());
    }

    /**
     * <p>
     * Imports security findings generated from an integrated product into Security Hub. This action is requested by the
     * integrated product to import its findings into Security Hub.
     * </p>
     * <p>
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     * </p>
     * <p>
     * After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding
     * fields and objects, which Security Hub customers use to manage their investigation workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Finding providers also should not use <code>BatchImportFindings</code> to update the following attributes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Instead, finding providers use <code>FindingProviderFields</code> to provide values for these attributes.
     * </p>
     *
     * @param batchImportFindingsRequest
     * @return A Java Future containing the result of the BatchImportFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchImportFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchImportFindingsResponse> batchImportFindings(
            BatchImportFindingsRequest batchImportFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports security findings generated from an integrated product into Security Hub. This action is requested by the
     * integrated product to import its findings into Security Hub.
     * </p>
     * <p>
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     * </p>
     * <p>
     * After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding
     * fields and objects, which Security Hub customers use to manage their investigation workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Finding providers also should not use <code>BatchImportFindings</code> to update the following attributes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Instead, finding providers use <code>FindingProviderFields</code> to provide values for these attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchImportFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchImportFindingsRequest#builder()}
     * </p>
     *
     * @param batchImportFindingsRequest
     *        A {@link Consumer} that will call methods on {@link BatchImportFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchImportFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchImportFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchImportFindingsResponse> batchImportFindings(
            Consumer<BatchImportFindingsRequest.Builder> batchImportFindingsRequest) {
        return batchImportFindings(BatchImportFindingsRequest.builder().applyMutation(batchImportFindingsRequest).build());
    }

    /**
     * <p>
     * Used by Security Hub customers to update information about their investigation into a finding. Requested by
     * administrator accounts or member accounts. Administrator accounts can update findings for their account and their
     * member accounts. Member accounts can update findings for their account.
     * </p>
     * <p>
     * Updates from <code>BatchUpdateFindings</code> do not affect the value of <code>UpdatedAt</code> for a finding.
     * </p>
     * <p>
     * Administrator and member accounts can use <code>BatchUpdateFindings</code> to update the following finding fields
     * and objects.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want
     * member accounts to be able to suppress findings or change the finding severity. See <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access"
     * >Configuring access to BatchUpdateFindings</a> in the <i>AWS Security Hub User Guide</i>.
     * </p>
     *
     * @param batchUpdateFindingsRequest
     * @return A Java Future containing the result of the BatchUpdateFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchUpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateFindingsResponse> batchUpdateFindings(
            BatchUpdateFindingsRequest batchUpdateFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by Security Hub customers to update information about their investigation into a finding. Requested by
     * administrator accounts or member accounts. Administrator accounts can update findings for their account and their
     * member accounts. Member accounts can update findings for their account.
     * </p>
     * <p>
     * Updates from <code>BatchUpdateFindings</code> do not affect the value of <code>UpdatedAt</code> for a finding.
     * </p>
     * <p>
     * Administrator and member accounts can use <code>BatchUpdateFindings</code> to update the following finding fields
     * and objects.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want
     * member accounts to be able to suppress findings or change the finding severity. See <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access"
     * >Configuring access to BatchUpdateFindings</a> in the <i>AWS Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateFindingsRequest#builder()}
     * </p>
     *
     * @param batchUpdateFindingsRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.BatchUpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateFindingsResponse> batchUpdateFindings(
            Consumer<BatchUpdateFindingsRequest.Builder> batchUpdateFindingsRequest) {
        return batchUpdateFindings(BatchUpdateFindingsRequest.builder().applyMutation(batchUpdateFindingsRequest).build());
    }

    /**
     * <p>
     * Creates a custom action target in Security Hub.
     * </p>
     * <p>
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon
     * CloudWatch Events.
     * </p>
     *
     * @param createActionTargetRequest
     * @return A Java Future containing the result of the CreateActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateActionTargetResponse> createActionTarget(CreateActionTargetRequest createActionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom action target in Security Hub.
     * </p>
     * <p>
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon
     * CloudWatch Events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateActionTargetRequest#builder()}
     * </p>
     *
     * @param createActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link CreateActionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateActionTargetResponse> createActionTarget(
            Consumer<CreateActionTargetRequest.Builder> createActionTargetRequest) {
        return createActionTarget(CreateActionTargetRequest.builder().applyMutation(createActionTargetRequest).build());
    }

    /**
     * <p>
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security
     * issue that requires attention or remediation.
     * </p>
     * <p>
     * To group the related findings in the insight, use the <code>GroupByAttribute</code>.
     * </p>
     *
     * @param createInsightRequest
     * @return A Java Future containing the result of the CreateInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInsightResponse> createInsight(CreateInsightRequest createInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security
     * issue that requires attention or remediation.
     * </p>
     * <p>
     * To group the related findings in the insight, use the <code>GroupByAttribute</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInsightRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInsightRequest#builder()}
     * </p>
     *
     * @param createInsightRequest
     *        A {@link Consumer} that will call methods on {@link CreateInsightRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInsightResponse> createInsight(Consumer<CreateInsightRequest.Builder> createInsightRequest) {
        return createInsight(CreateInsightRequest.builder().applyMutation(createInsightRequest).build());
    }

    /**
     * <p>
     * Creates a member association in Security Hub between the specified accounts and the account used to make the
     * request, which is the administrator account. If you are integrated with Organizations, then the administrator
     * account is designated by the organization management account.
     * </p>
     * <p>
     * <code>CreateMembers</code> is always used to add accounts that are not organization members.
     * </p>
     * <p>
     * For accounts that are part of an organization, <code>CreateMembers</code> is only used in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Security Hub is not configured to automatically add new accounts in an organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * The account was disassociated or deleted in Security Hub.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the
     * <code> <a>EnableSecurityHub</a> </code> operation.
     * </p>
     * <p>
     * For accounts that are not organization members, you create the account association and then send an invitation to
     * the member account. To send the invitation, you use the <code> <a>InviteMembers</a> </code> operation. If the
     * account owner accepts the invitation, the account becomes a member account in Security Hub.
     * </p>
     * <p>
     * Accounts that are part of an organization do not receive an invitation. They automatically become a member
     * account in Security Hub.
     * </p>
     * <p>
     * A permissions policy is added that permits the administrator account to view the findings generated in the member
     * account. When Security Hub is enabled in a member account, the member account findings are also visible to the
     * administrator account.
     * </p>
     * <p>
     * To remove the association between the administrator and member accounts, use the
     * <code> <a>DisassociateFromMasterAccount</a> </code> or <code> <a>DisassociateMembers</a> </code> operation.
     * </p>
     *
     * @param createMembersRequest
     * @return A Java Future containing the result of the CreateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMembersResponse> createMembers(CreateMembersRequest createMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a member association in Security Hub between the specified accounts and the account used to make the
     * request, which is the administrator account. If you are integrated with Organizations, then the administrator
     * account is designated by the organization management account.
     * </p>
     * <p>
     * <code>CreateMembers</code> is always used to add accounts that are not organization members.
     * </p>
     * <p>
     * For accounts that are part of an organization, <code>CreateMembers</code> is only used in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Security Hub is not configured to automatically add new accounts in an organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * The account was disassociated or deleted in Security Hub.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the
     * <code> <a>EnableSecurityHub</a> </code> operation.
     * </p>
     * <p>
     * For accounts that are not organization members, you create the account association and then send an invitation to
     * the member account. To send the invitation, you use the <code> <a>InviteMembers</a> </code> operation. If the
     * account owner accepts the invitation, the account becomes a member account in Security Hub.
     * </p>
     * <p>
     * Accounts that are part of an organization do not receive an invitation. They automatically become a member
     * account in Security Hub.
     * </p>
     * <p>
     * A permissions policy is added that permits the administrator account to view the findings generated in the member
     * account. When Security Hub is enabled in a member account, the member account findings are also visible to the
     * administrator account.
     * </p>
     * <p>
     * To remove the association between the administrator and member accounts, use the
     * <code> <a>DisassociateFromMasterAccount</a> </code> or <code> <a>DisassociateMembers</a> </code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembersRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMembersRequest#builder()}
     * </p>
     *
     * @param createMembersRequest
     *        A {@link Consumer} that will call methods on {@link CreateMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMembersResponse> createMembers(Consumer<CreateMembersRequest.Builder> createMembersRequest) {
        return createMembers(CreateMembersRequest.builder().applyMutation(createMembersRequest).build());
    }

    /**
     * <p>
     * Declines invitations to become a member account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not
     * receive invitations.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeclineInvitationsResponse> declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Declines invitations to become a member account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not
     * receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeclineInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeclineInvitationsRequest#builder()}
     * </p>
     *
     * @param declineInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeclineInvitationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeclineInvitationsResponse> declineInvitations(
            Consumer<DeclineInvitationsRequest.Builder> declineInvitationsRequest) {
        return declineInvitations(DeclineInvitationsRequest.builder().applyMutation(declineInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes a custom action target from Security Hub.
     * </p>
     * <p>
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon
     * CloudWatch Events using the custom action.
     * </p>
     *
     * @param deleteActionTargetRequest
     * @return A Java Future containing the result of the DeleteActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteActionTargetResponse> deleteActionTarget(DeleteActionTargetRequest deleteActionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom action target from Security Hub.
     * </p>
     * <p>
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon
     * CloudWatch Events using the custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteActionTargetRequest#builder()}
     * </p>
     *
     * @param deleteActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteActionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteActionTargetResponse> deleteActionTarget(
            Consumer<DeleteActionTargetRequest.Builder> deleteActionTargetRequest) {
        return deleteActionTarget(DeleteActionTargetRequest.builder().applyMutation(deleteActionTargetRequest).build());
    }

    /**
     * <p>
     * Deletes the insight specified by the <code>InsightArn</code>.
     * </p>
     *
     * @param deleteInsightRequest
     * @return A Java Future containing the result of the DeleteInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInsightResponse> deleteInsight(DeleteInsightRequest deleteInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the insight specified by the <code>InsightArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInsightRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInsightRequest#builder()}
     * </p>
     *
     * @param deleteInsightRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInsightRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInsightResponse> deleteInsight(Consumer<DeleteInsightRequest.Builder> deleteInsightRequest) {
        return deleteInsight(DeleteInsightRequest.builder().applyMutation(deleteInsightRequest).build());
    }

    /**
     * <p>
     * Deletes invitations received by the AWS account to become a member account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not
     * receive invitations.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInvitationsResponse> deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes invitations received by the AWS account to become a member account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not
     * receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvitationsRequest#builder()}
     * </p>
     *
     * @param deleteInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInvitationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInvitationsResponse> deleteInvitations(
            Consumer<DeleteInvitationsRequest.Builder> deleteInvitationsRequest) {
        return deleteInvitations(DeleteInvitationsRequest.builder().applyMutation(deleteInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified member accounts from Security Hub.
     * </p>
     * <p>
     * Can be used to delete member accounts that belong to an organization as well as member accounts that were invited
     * manually.
     * </p>
     *
     * @param deleteMembersRequest
     * @return A Java Future containing the result of the DeleteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMembersResponse> deleteMembers(DeleteMembersRequest deleteMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified member accounts from Security Hub.
     * </p>
     * <p>
     * Can be used to delete member accounts that belong to an organization as well as member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMembersRequest#builder()}
     * </p>
     *
     * @param deleteMembersRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMembersResponse> deleteMembers(Consumer<DeleteMembersRequest.Builder> deleteMembersRequest) {
        return deleteMembers(DeleteMembersRequest.builder().applyMutation(deleteMembersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     *
     * @param describeActionTargetsRequest
     * @return A Java Future containing the result of the DescribeActionTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeActionTargetsResponse> describeActionTargets(
            DescribeActionTargetsRequest describeActionTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActionTargetsRequest#builder()}
     * </p>
     *
     * @param describeActionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActionTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeActionTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeActionTargetsResponse> describeActionTargets(
            Consumer<DescribeActionTargetsRequest.Builder> describeActionTargetsRequest) {
        return describeActionTargets(DescribeActionTargetsRequest.builder().applyMutation(describeActionTargetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher publisher = client.describeActionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher publisher = client.describeActionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeActionTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsPublisher describeActionTargetsPaginator(
            DescribeActionTargetsRequest describeActionTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher publisher = client.describeActionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsPublisher publisher = client.describeActionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActionTargetsRequest#builder()}
     * </p>
     *
     * @param describeActionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActionTargetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsPublisher describeActionTargetsPaginator(
            Consumer<DescribeActionTargetsRequest.Builder> describeActionTargetsRequest) {
        return describeActionTargetsPaginator(DescribeActionTargetsRequest.builder().applyMutation(describeActionTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you
     * enabled Security Hub.
     * </p>
     *
     * @param describeHubRequest
     * @return A Java Future containing the result of the DescribeHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeHubResponse> describeHub(DescribeHubRequest describeHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you
     * enabled Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHubRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeHubRequest#builder()}
     * </p>
     *
     * @param describeHubRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHubRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeHubResponse> describeHub(Consumer<DescribeHubRequest.Builder> describeHubRequest) {
        return describeHub(DescribeHubRequest.builder().applyMutation(describeHubRequest).build());
    }

    /**
     * <p>
     * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security
     * Hub administrator account.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security
     * Hub administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest) {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     *
     * @param describeProductsRequest
     * @return A Java Future containing the result of the DescribeProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeProductsResponse> describeProducts(DescribeProductsRequest describeProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductsRequest#builder()}
     * </p>
     *
     * @param describeProductsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeProductsResponse> describeProducts(
            Consumer<DescribeProductsRequest.Builder> describeProductsRequest) {
        return describeProducts(DescribeProductsRequest.builder().applyMutation(describeProductsRequest).build());
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher publisher = client.describeProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher publisher = client.describeProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsPublisher describeProductsPaginator(DescribeProductsRequest describeProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher publisher = client.describeProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsPublisher publisher = client.describeProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductsRequest#builder()}
     * </p>
     *
     * @param describeProductsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsPublisher describeProductsPaginator(Consumer<DescribeProductsRequest.Builder> describeProductsRequest) {
        return describeProductsPaginator(DescribeProductsRequest.builder().applyMutation(describeProductsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     *
     * @param describeStandardsRequest
     * @return A Java Future containing the result of the DescribeStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStandardsResponse> describeStandards(DescribeStandardsRequest describeStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStandardsRequest#builder()}
     * </p>
     *
     * @param describeStandardsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStandardsResponse> describeStandards(
            Consumer<DescribeStandardsRequest.Builder> describeStandardsRequest) {
        return describeStandards(DescribeStandardsRequest.builder().applyMutation(describeStandardsRequest).build());
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     *
     * @param describeStandardsControlsRequest
     * @return A Java Future containing the result of the DescribeStandardsControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStandardsControlsResponse> describeStandardsControls(
            DescribeStandardsControlsRequest describeStandardsControlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStandardsControlsRequest#builder()}
     * </p>
     *
     * @param describeStandardsControlsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsControlsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStandardsControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStandardsControlsResponse> describeStandardsControls(
            Consumer<DescribeStandardsControlsRequest.Builder> describeStandardsControlsRequest) {
        return describeStandardsControls(DescribeStandardsControlsRequest.builder()
                .applyMutation(describeStandardsControlsRequest).build());
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsPublisher publisher = client.describeStandardsControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsPublisher publisher = client.describeStandardsControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStandardsControlsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsPublisher describeStandardsControlsPaginator(
            DescribeStandardsControlsRequest describeStandardsControlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsPublisher publisher = client.describeStandardsControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsPublisher publisher = client.describeStandardsControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStandardsControlsRequest#builder()}
     * </p>
     *
     * @param describeStandardsControlsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsControlsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsPublisher describeStandardsControlsPaginator(
            Consumer<DescribeStandardsControlsRequest.Builder> describeStandardsControlsRequest) {
        return describeStandardsControlsPaginator(DescribeStandardsControlsRequest.builder()
                .applyMutation(describeStandardsControlsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsPublisher publisher = client.describeStandardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsPublisher publisher = client.describeStandardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStandardsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsPublisher describeStandardsPaginator(DescribeStandardsRequest describeStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsPublisher publisher = client.describeStandardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsPublisher publisher = client.describeStandardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStandardsRequest#builder()}
     * </p>
     *
     * @param describeStandardsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsPublisher describeStandardsPaginator(
            Consumer<DescribeStandardsRequest.Builder> describeStandardsRequest) {
        return describeStandardsPaginator(DescribeStandardsRequest.builder().applyMutation(describeStandardsRequest).build());
    }

    /**
     * <p>
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings
     * from that product are no longer sent to Security Hub.
     * </p>
     *
     * @param disableImportFindingsForProductRequest
     * @return A Java Future containing the result of the DisableImportFindingsForProduct operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableImportFindingsForProductResponse> disableImportFindingsForProduct(
            DisableImportFindingsForProductRequest disableImportFindingsForProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings
     * from that product are no longer sent to Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableImportFindingsForProductRequest.Builder}
     * avoiding the need to create one manually via {@link DisableImportFindingsForProductRequest#builder()}
     * </p>
     *
     * @param disableImportFindingsForProductRequest
     *        A {@link Consumer} that will call methods on {@link DisableImportFindingsForProductRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableImportFindingsForProduct operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableImportFindingsForProductResponse> disableImportFindingsForProduct(
            Consumer<DisableImportFindingsForProductRequest.Builder> disableImportFindingsForProductRequest) {
        return disableImportFindingsForProduct(DisableImportFindingsForProductRequest.builder()
                .applyMutation(disableImportFindingsForProductRequest).build());
    }

    /**
     * <p>
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            Consumer<DisableOrganizationAdminAccountRequest.Builder> disableOrganizationAdminAccountRequest) {
        return disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.builder()
                .applyMutation(disableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated
     * member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     *
     * @param disableSecurityHubRequest
     * @return A Java Future containing the result of the DisableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableSecurityHubResponse> disableSecurityHub(DisableSecurityHubRequest disableSecurityHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated
     * member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableSecurityHubRequest.Builder} avoiding the
     * need to create one manually via {@link DisableSecurityHubRequest#builder()}
     * </p>
     *
     * @param disableSecurityHubRequest
     *        A {@link Consumer} that will call methods on {@link DisableSecurityHubRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableSecurityHubResponse> disableSecurityHub(
            Consumer<DisableSecurityHubRequest.Builder> disableSecurityHubRequest) {
        return disableSecurityHub(DisableSecurityHubRequest.builder().applyMutation(disableSecurityHubRequest).build());
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated
     * member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     *
     * @return A Java Future containing the result of the DisableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableSecurityHubResponse> disableSecurityHub() {
        return disableSecurityHub(DisableSecurityHubRequest.builder().build());
    }

    /**
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     * @return A Java Future containing the result of the DisassociateFromAdministratorAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateFromAdministratorAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromAdministratorAccountResponse> disassociateFromAdministratorAccount(
            DisassociateFromAdministratorAccountRequest disassociateFromAdministratorAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateFromAdministratorAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateFromAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromAdministratorAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateFromAdministratorAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateFromAdministratorAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromAdministratorAccountResponse> disassociateFromAdministratorAccount(
            Consumer<DisassociateFromAdministratorAccountRequest.Builder> disassociateFromAdministratorAccountRequest) {
        return disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.builder()
                .applyMutation(disassociateFromAdministratorAccountRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>DisassociateFromMasterAccount</code>. It will eventually change
     * to use <code>DisassociateFromAdministratorAccount</code>. Any IAM policies that specifically control access to
     * this function must continue to use <code>DisassociateFromMasterAccount</code>. You should also add
     * <code>DisassociateFromAdministratorAccount</code> to your policies to ensure that the correct permissions are in
     * place after the console begins to use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>DisassociateFromMasterAccount</code>. It will eventually change
     * to use <code>DisassociateFromAdministratorAccount</code>. Any IAM policies that specifically control access to
     * this function must continue to use <code>DisassociateFromMasterAccount</code>. You should also add
     * <code>DisassociateFromAdministratorAccount</code> to your policies to ensure that the correct permissions are in
     * place after the console begins to use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFromMasterAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFromMasterAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromMasterAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            Consumer<DisassociateFromMasterAccountRequest.Builder> disassociateFromMasterAccountRequest) {
        return disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.builder()
                .applyMutation(disassociateFromMasterAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified member accounts from the associated administrator account.
     * </p>
     * <p>
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     *
     * @param disassociateMembersRequest
     * @return A Java Future containing the result of the DisassociateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMembersResponse> disassociateMembers(
            DisassociateMembersRequest disassociateMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified member accounts from the associated administrator account.
     * </p>
     * <p>
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMembersRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMembersRequest#builder()}
     * </p>
     *
     * @param disassociateMembersRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMembersResponse> disassociateMembers(
            Consumer<DisassociateMembersRequest.Builder> disassociateMembersRequest) {
        return disassociateMembers(DisassociateMembersRequest.builder().applyMutation(disassociateMembersRequest).build());
    }

    /**
     * <p>
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security
     * Hub.
     * </p>
     * <p>
     * When you enable a product integration, a permissions policy that grants permission for the product to send
     * findings to Security Hub is applied.
     * </p>
     *
     * @param enableImportFindingsForProductRequest
     * @return A Java Future containing the result of the EnableImportFindingsForProduct operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableImportFindingsForProductResponse> enableImportFindingsForProduct(
            EnableImportFindingsForProductRequest enableImportFindingsForProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security
     * Hub.
     * </p>
     * <p>
     * When you enable a product integration, a permissions policy that grants permission for the product to send
     * findings to Security Hub is applied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableImportFindingsForProductRequest.Builder}
     * avoiding the need to create one manually via {@link EnableImportFindingsForProductRequest#builder()}
     * </p>
     *
     * @param enableImportFindingsForProductRequest
     *        A {@link Consumer} that will call methods on {@link EnableImportFindingsForProductRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableImportFindingsForProduct operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableImportFindingsForProductResponse> enableImportFindingsForProduct(
            Consumer<EnableImportFindingsForProductRequest.Builder> enableImportFindingsForProductRequest) {
        return enableImportFindingsForProduct(EnableImportFindingsForProductRequest.builder()
                .applyMutation(enableImportFindingsForProductRequest).build());
    }

    /**
     * <p>
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization
     * management account.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization
     * management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link EnableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            Consumer<EnableOrganizationAdminAccountRequest.Builder> enableOrganizationAdminAccountRequest) {
        return enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.builder()
                .applyMutation(enableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CIS AWS Foundations
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     * </p>
     * <p>
     * To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code> <a>BatchEnableStandards</a> </code>
     * operation. To disable a standard, use the <code> <a>BatchDisableStandards</a> </code> operation.
     * </p>
     * <p>
     * To learn more, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">Setting Up AWS
     * Security Hub</a> in the <i>AWS Security Hub User Guide</i>.
     * </p>
     *
     * @param enableSecurityHubRequest
     * @return A Java Future containing the result of the EnableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action specified in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableSecurityHubResponse> enableSecurityHub(EnableSecurityHubRequest enableSecurityHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CIS AWS Foundations
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     * </p>
     * <p>
     * To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code> <a>BatchEnableStandards</a> </code>
     * operation. To disable a standard, use the <code> <a>BatchDisableStandards</a> </code> operation.
     * </p>
     * <p>
     * To learn more, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">Setting Up AWS
     * Security Hub</a> in the <i>AWS Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSecurityHubRequest.Builder} avoiding the need
     * to create one manually via {@link EnableSecurityHubRequest#builder()}
     * </p>
     *
     * @param enableSecurityHubRequest
     *        A {@link Consumer} that will call methods on {@link EnableSecurityHubRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action specified in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableSecurityHubResponse> enableSecurityHub(
            Consumer<EnableSecurityHubRequest.Builder> enableSecurityHubRequest) {
        return enableSecurityHub(EnableSecurityHubRequest.builder().applyMutation(enableSecurityHubRequest).build());
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CIS AWS Foundations
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     * </p>
     * <p>
     * To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code> <a>BatchEnableStandards</a> </code>
     * operation. To disable a standard, use the <code> <a>BatchDisableStandards</a> </code> operation.
     * </p>
     * <p>
     * To learn more, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">Setting Up AWS
     * Security Hub</a> in the <i>AWS Security Hub User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the EnableSecurityHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceConflictException The resource specified in the request conflicts with an existing resource.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action specified in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.EnableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableSecurityHubResponse> enableSecurityHub() {
        return enableSecurityHub(EnableSecurityHubRequest.builder().build());
    }

    /**
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @param getAdministratorAccountRequest
     * @return A Java Future containing the result of the GetAdministratorAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAdministratorAccountResponse> getAdministratorAccount(
            GetAdministratorAccountRequest getAdministratorAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdministratorAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param getAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAdministratorAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAdministratorAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAdministratorAccountResponse> getAdministratorAccount(
            Consumer<GetAdministratorAccountRequest.Builder> getAdministratorAccountRequest) {
        return getAdministratorAccount(GetAdministratorAccountRequest.builder().applyMutation(getAdministratorAccountRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     *
     * @param getEnabledStandardsRequest
     * @return A Java Future containing the result of the GetEnabledStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnabledStandardsResponse> getEnabledStandards(
            GetEnabledStandardsRequest getEnabledStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledStandardsRequest#builder()}
     * </p>
     *
     * @param getEnabledStandardsRequest
     *        A {@link Consumer} that will call methods on {@link GetEnabledStandardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnabledStandards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnabledStandardsResponse> getEnabledStandards(
            Consumer<GetEnabledStandardsRequest.Builder> getEnabledStandardsRequest) {
        return getEnabledStandards(GetEnabledStandardsRequest.builder().applyMutation(getEnabledStandardsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsPublisher publisher = client.getEnabledStandardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsPublisher publisher = client.getEnabledStandardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEnabledStandardsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsPublisher getEnabledStandardsPaginator(GetEnabledStandardsRequest getEnabledStandardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsPublisher publisher = client.getEnabledStandardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsPublisher publisher = client.getEnabledStandardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledStandardsRequest#builder()}
     * </p>
     *
     * @param getEnabledStandardsRequest
     *        A {@link Consumer} that will call methods on {@link GetEnabledStandardsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsPublisher getEnabledStandardsPaginator(
            Consumer<GetEnabledStandardsRequest.Builder> getEnabledStandardsRequest) {
        return getEnabledStandardsPaginator(GetEnabledStandardsRequest.builder().applyMutation(getEnabledStandardsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     *
     * @param getFindingsRequest
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) {
        return getFindings(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     *
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings() {
        return getFindings(GetFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsPublisher getFindingsPaginator() {
        return getFindingsPaginator(GetFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @param getFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsPublisher getFindingsPaginator(GetFindingsRequest getFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsPublisher publisher = client.getFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsPublisher getFindingsPaginator(Consumer<GetFindingsRequest.Builder> getFindingsRequest) {
        return getFindingsPaginator(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Lists the results of the Security Hub insight specified by the insight ARN.
     * </p>
     *
     * @param getInsightResultsRequest
     * @return A Java Future containing the result of the GetInsightResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsightResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInsightResultsResponse> getInsightResults(GetInsightResultsRequest getInsightResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the results of the Security Hub insight specified by the insight ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetInsightResultsRequest#builder()}
     * </p>
     *
     * @param getInsightResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightResultsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInsightResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsightResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInsightResultsResponse> getInsightResults(
            Consumer<GetInsightResultsRequest.Builder> getInsightResultsRequest) {
        return getInsightResults(GetInsightResultsRequest.builder().applyMutation(getInsightResultsRequest).build());
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     *
     * @param getInsightsRequest
     * @return A Java Future containing the result of the GetInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInsightsResponse> getInsights(GetInsightsRequest getInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInsightsResponse> getInsights(Consumer<GetInsightsRequest.Builder> getInsightsRequest) {
        return getInsights(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher publisher = client.getInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher publisher = client.getInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)} operation.</b>
     * </p>
     *
     * @param getInsightsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsPublisher getInsightsPaginator(GetInsightsRequest getInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher publisher = client.getInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsPublisher publisher = client.getInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.GetInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.GetInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsPublisher getInsightsPaginator(Consumer<GetInsightsRequest.Builder> getInsightsRequest) {
        return getInsightsPaginator(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            GetInvitationsCountRequest getInvitationsCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationsCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetInvitationsCountRequest#builder()}
     * </p>
     *
     * @param getInvitationsCountRequest
     *        A {@link Consumer} that will call methods on {@link GetInvitationsCountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            Consumer<GetInvitationsCountRequest.Builder> getInvitationsCountRequest) {
        return getInvitationsCount(GetInvitationsCountRequest.builder().applyMutation(getInvitationsCountRequest).build());
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     *
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount() {
        return getInvitationsCount(GetInvitationsCountRequest.builder().build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMasterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetMasterAccountRequest#builder()}
     * </p>
     *
     * @param getMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetMasterAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount(
            Consumer<GetMasterAccountRequest.Builder> getMasterAccountRequest) {
        return getMasterAccount(GetMasterAccountRequest.builder().applyMutation(getMasterAccountRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount() {
        return getMasterAccount(GetMasterAccountRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     * </p>
     * <p>
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an
     * administrator account that enabled Security Hub manually.
     * </p>
     * <p>
     * The results include both member accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     *
     * @param getMembersRequest
     * @return A Java Future containing the result of the GetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMembersResponse> getMembers(GetMembersRequest getMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     * </p>
     * <p>
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an
     * administrator account that enabled Security Hub manually.
     * </p>
     * <p>
     * The results include both member accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembersRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembersRequest#builder()}
     * </p>
     *
     * @param getMembersRequest
     *        A {@link Consumer} that will call methods on {@link GetMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMembersResponse> getMembers(Consumer<GetMembersRequest.Builder> getMembersRequest) {
        return getMembers(GetMembersRequest.builder().applyMutation(getMembersRequest).build());
    }

    /**
     * <p>
     * Invites other AWS accounts to become member accounts for the Security Hub administrator account that the
     * invitation is sent from.
     * </p>
     * <p>
     * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do
     * not receive invitations.
     * </p>
     * <p>
     * Before you can use this action to invite a member, you must first use the <code> <a>CreateMembers</a> </code>
     * action to create the member account in Security Hub.
     * </p>
     * <p>
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the
     * administrator account can view the findings generated from the member account.
     * </p>
     *
     * @param inviteMembersRequest
     * @return A Java Future containing the result of the InviteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InviteMembersResponse> inviteMembers(InviteMembersRequest inviteMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invites other AWS accounts to become member accounts for the Security Hub administrator account that the
     * invitation is sent from.
     * </p>
     * <p>
     * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do
     * not receive invitations.
     * </p>
     * <p>
     * Before you can use this action to invite a member, you must first use the <code> <a>CreateMembers</a> </code>
     * action to create the member account in Security Hub.
     * </p>
     * <p>
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the
     * administrator account can view the findings generated from the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InviteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link InviteMembersRequest#builder()}
     * </p>
     *
     * @param inviteMembersRequest
     *        A {@link Consumer} that will call methods on {@link InviteMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InviteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InviteMembersResponse> inviteMembers(Consumer<InviteMembersRequest.Builder> inviteMembersRequest) {
        return inviteMembers(InviteMembersRequest.builder().applyMutation(inviteMembersRequest).build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     * @return A Java Future containing the result of the ListEnabledProductsForImport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledProductsForImportResponse> listEnabledProductsForImport(
            ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledProductsForImportRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnabledProductsForImportRequest#builder()}
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     *        A {@link Consumer} that will call methods on {@link ListEnabledProductsForImportRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListEnabledProductsForImport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledProductsForImportResponse> listEnabledProductsForImport(
            Consumer<ListEnabledProductsForImportRequest.Builder> listEnabledProductsForImportRequest) {
        return listEnabledProductsForImport(ListEnabledProductsForImportRequest.builder()
                .applyMutation(listEnabledProductsForImportRequest).build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     *
     * @return A Java Future containing the result of the ListEnabledProductsForImport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledProductsForImportResponse> listEnabledProductsForImport() {
        return listEnabledProductsForImport(ListEnabledProductsForImportRequest.builder().build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportPublisher listEnabledProductsForImportPaginator() {
        return listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest.builder().build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportPublisher listEnabledProductsForImportPaginator(
            ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportPublisher publisher = client.listEnabledProductsForImportPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledProductsForImportRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnabledProductsForImportRequest#builder()}
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     *        A {@link Consumer} that will call methods on {@link ListEnabledProductsForImportRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportPublisher listEnabledProductsForImportPaginator(
            Consumer<ListEnabledProductsForImportRequest.Builder> listEnabledProductsForImportRequest) {
        return listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest.builder()
                .applyMutation(listEnabledProductsForImportRequest).build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with AWS Organizations do not receive invitations.
     * </p>
     *
     * @param listInvitationsRequest
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with AWS Organizations do not receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(
            Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with AWS Organizations do not receive invitations.
     * </p>
     *
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations() {
        return listInvitations(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with AWS Organizations do not receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator() {
        return listInvitationsPaginator(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with AWS Organizations do not receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current AWS account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with AWS Organizations do not receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitationsPaginator(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     *
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers() {
        return listMembers(ListMembersRequest.builder().build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator() {
        return listMembersPaginator(ListMembersRequest.builder().build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest) {
        return listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsPublisher listOrganizationAdminAccountsPaginator(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsPublisher listOrganizationAdminAccountsPaginator(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest) {
        return listOrganizationAdminAccountsPaginator(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the name and description of a custom action target in Security Hub.
     * </p>
     *
     * @param updateActionTargetRequest
     * @return A Java Future containing the result of the UpdateActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateActionTargetResponse> updateActionTarget(UpdateActionTargetRequest updateActionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and description of a custom action target in Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateActionTargetRequest#builder()}
     * </p>
     *
     * @param updateActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateActionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateActionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateActionTargetResponse> updateActionTarget(
            Consumer<UpdateActionTargetRequest.Builder> updateActionTargetRequest) {
        return updateActionTarget(UpdateActionTargetRequest.builder().applyMutation(updateActionTargetRequest).build());
    }

    /**
     * <p>
     * <code>UpdateFindings</code> is deprecated. Instead of <code>UpdateFindings</code>, use
     * <code>BatchUpdateFindings</code>.
     * </p>
     * <p>
     * Updates the <code>Note</code> and <code>RecordState</code> of the Security Hub-aggregated findings that the
     * filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     * </p>
     *
     * @param updateFindingsRequest
     * @return A Java Future containing the result of the UpdateFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFindingsResponse> updateFindings(UpdateFindingsRequest updateFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>UpdateFindings</code> is deprecated. Instead of <code>UpdateFindings</code>, use
     * <code>BatchUpdateFindings</code>.
     * </p>
     * <p>
     * Updates the <code>Note</code> and <code>RecordState</code> of the Security Hub-aggregated findings that the
     * filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFindingsRequest#builder()}
     * </p>
     *
     * @param updateFindingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFindingsResponse> updateFindings(Consumer<UpdateFindingsRequest.Builder> updateFindingsRequest) {
        return updateFindings(UpdateFindingsRequest.builder().applyMutation(updateFindingsRequest).build());
    }

    /**
     * <p>
     * Updates the Security Hub insight identified by the specified insight ARN.
     * </p>
     *
     * @param updateInsightRequest
     * @return A Java Future containing the result of the UpdateInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInsightResponse> updateInsight(UpdateInsightRequest updateInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Security Hub insight identified by the specified insight ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInsightRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInsightRequest#builder()}
     * </p>
     *
     * @param updateInsightRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInsightRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInsightResponse> updateInsight(Consumer<UpdateInsightRequest.Builder> updateInsightRequest) {
        return updateInsight(UpdateInsightRequest.builder().applyMutation(updateInsightRequest).build());
    }

    /**
     * <p>
     * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator
     * account.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest) {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates configuration options for Security Hub.
     * </p>
     *
     * @param updateSecurityHubConfigurationRequest
     * @return A Java Future containing the result of the UpdateSecurityHubConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateSecurityHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSecurityHubConfigurationResponse> updateSecurityHubConfiguration(
            UpdateSecurityHubConfigurationRequest updateSecurityHubConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates configuration options for Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityHubConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSecurityHubConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSecurityHubConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSecurityHubConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSecurityHubConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account or throttling limits. The error code describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateSecurityHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSecurityHubConfigurationResponse> updateSecurityHubConfiguration(
            Consumer<UpdateSecurityHubConfigurationRequest.Builder> updateSecurityHubConfigurationRequest) {
        return updateSecurityHubConfiguration(UpdateSecurityHubConfigurationRequest.builder()
                .applyMutation(updateSecurityHubConfigurationRequest).build());
    }

    /**
     * <p>
     * Used to control whether an individual security standard control is enabled or disabled.
     * </p>
     *
     * @param updateStandardsControlRequest
     * @return A Java Future containing the result of the UpdateStandardsControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateStandardsControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStandardsControlResponse> updateStandardsControl(
            UpdateStandardsControlRequest updateStandardsControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to control whether an individual security standard control is enabled or disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStandardsControlRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStandardsControlRequest#builder()}
     * </p>
     *
     * @param updateStandardsControlRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStandardsControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStandardsControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because you supplied an invalid or out-of-range value
     *         for an input parameter.</li>
     *         <li>InvalidAccessException There is an issue with the account used to make the request. Either Security
     *         Hub is not enabled for the account, or the account does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException The request was rejected because we can't find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityHubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityHubAsyncClient.UpdateStandardsControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStandardsControlResponse> updateStandardsControl(
            Consumer<UpdateStandardsControlRequest.Builder> updateStandardsControlRequest) {
        return updateStandardsControl(UpdateStandardsControlRequest.builder().applyMutation(updateStandardsControlRequest)
                .build());
    }
}
