/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a REST API in version 1 of Amazon API Gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsApiGatewayRestApiDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsApiGatewayRestApiDetails.Builder, AwsApiGatewayRestApiDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsApiGatewayRestApiDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsApiGatewayRestApiDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsApiGatewayRestApiDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(AwsApiGatewayRestApiDetails::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(AwsApiGatewayRestApiDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<List<String>> BINARY_MEDIA_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BinaryMediaTypes")
            .getter(getter(AwsApiGatewayRestApiDetails::binaryMediaTypes))
            .setter(setter(Builder::binaryMediaTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinaryMediaTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MINIMUM_COMPRESSION_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumCompressionSize").getter(getter(AwsApiGatewayRestApiDetails::minimumCompressionSize))
            .setter(setter(Builder::minimumCompressionSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumCompressionSize").build())
            .build();

    private static final SdkField<String> API_KEY_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiKeySource").getter(getter(AwsApiGatewayRestApiDetails::apiKeySource))
            .setter(setter(Builder::apiKeySource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeySource").build()).build();

    private static final SdkField<AwsApiGatewayEndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<AwsApiGatewayEndpointConfiguration> builder(MarshallingType.SDK_POJO).memberName("EndpointConfiguration")
            .getter(getter(AwsApiGatewayRestApiDetails::endpointConfiguration)).setter(setter(Builder::endpointConfiguration))
            .constructor(AwsApiGatewayEndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, BINARY_MEDIA_TYPES_FIELD, MINIMUM_COMPRESSION_SIZE_FIELD,
            API_KEY_SOURCE_FIELD, ENDPOINT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String createdDate;

    private final String version;

    private final List<String> binaryMediaTypes;

    private final Integer minimumCompressionSize;

    private final String apiKeySource;

    private final AwsApiGatewayEndpointConfiguration endpointConfiguration;

    private AwsApiGatewayRestApiDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.minimumCompressionSize = builder.minimumCompressionSize;
        this.apiKeySource = builder.apiKeySource;
        this.endpointConfiguration = builder.endpointConfiguration;
    }

    /**
     * <p>
     * The identifier of the REST API.
     * </p>
     * 
     * @return The identifier of the REST API.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the REST API.
     * </p>
     * 
     * @return The name of the REST API.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the REST API.
     * </p>
     * 
     * @return A description of the REST API.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates when the API was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the API was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The version identifier for the REST API.
     * </p>
     * 
     * @return The version identifier for the REST API.
     */
    public final String version() {
        return version;
    }

    /**
     * Returns true if the BinaryMediaTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBinaryMediaTypes() {
        return binaryMediaTypes != null && !(binaryMediaTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of binary media types supported by the REST API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBinaryMediaTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of binary media types supported by the REST API.
     */
    public final List<String> binaryMediaTypes() {
        return binaryMediaTypes;
    }

    /**
     * <p>
     * The minimum size in bytes of a payload before compression is enabled.
     * </p>
     * <p>
     * If <code>null</code>, then compression is disabled.
     * </p>
     * <p>
     * If 0, then all payloads are compressed.
     * </p>
     * 
     * @return The minimum size in bytes of a payload before compression is enabled.</p>
     *         <p>
     *         If <code>null</code>, then compression is disabled.
     *         </p>
     *         <p>
     *         If 0, then all payloads are compressed.
     */
    public final Integer minimumCompressionSize() {
        return minimumCompressionSize;
    }

    /**
     * <p>
     * The source of the API key for metering requests according to a usage plan.
     * </p>
     * <p>
     * <code>HEADER</code> indicates whether to read the API key from the X-API-Key header of a request.
     * </p>
     * <p>
     * <code>AUTHORIZER</code> indicates whether to read the API key from the <code>UsageIdentifierKey</code> from a
     * custom authorizer.
     * </p>
     * 
     * @return The source of the API key for metering requests according to a usage plan.</p>
     *         <p>
     *         <code>HEADER</code> indicates whether to read the API key from the X-API-Key header of a request.
     *         </p>
     *         <p>
     *         <code>AUTHORIZER</code> indicates whether to read the API key from the <code>UsageIdentifierKey</code>
     *         from a custom authorizer.
     */
    public final String apiKeySource() {
        return apiKeySource;
    }

    /**
     * <p>
     * The endpoint configuration of the REST API.
     * </p>
     * 
     * @return The endpoint configuration of the REST API.
     */
    public final AwsApiGatewayEndpointConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasBinaryMediaTypes() ? binaryMediaTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minimumCompressionSize());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySource());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayRestApiDetails)) {
            return false;
        }
        AwsApiGatewayRestApiDetails other = (AwsApiGatewayRestApiDetails) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(version(), other.version()) && hasBinaryMediaTypes() == other.hasBinaryMediaTypes()
                && Objects.equals(binaryMediaTypes(), other.binaryMediaTypes())
                && Objects.equals(minimumCompressionSize(), other.minimumCompressionSize())
                && Objects.equals(apiKeySource(), other.apiKeySource())
                && Objects.equals(endpointConfiguration(), other.endpointConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsApiGatewayRestApiDetails").add("Id", id()).add("Name", name())
                .add("Description", description()).add("CreatedDate", createdDate()).add("Version", version())
                .add("BinaryMediaTypes", hasBinaryMediaTypes() ? binaryMediaTypes() : null)
                .add("MinimumCompressionSize", minimumCompressionSize()).add("ApiKeySource", apiKeySource())
                .add("EndpointConfiguration", endpointConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "BinaryMediaTypes":
            return Optional.ofNullable(clazz.cast(binaryMediaTypes()));
        case "MinimumCompressionSize":
            return Optional.ofNullable(clazz.cast(minimumCompressionSize()));
        case "ApiKeySource":
            return Optional.ofNullable(clazz.cast(apiKeySource()));
        case "EndpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayRestApiDetails, T> g) {
        return obj -> g.apply((AwsApiGatewayRestApiDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsApiGatewayRestApiDetails> {
        /**
         * <p>
         * The identifier of the REST API.
         * </p>
         * 
         * @param id
         *        The identifier of the REST API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the REST API.
         * </p>
         * 
         * @param name
         *        The name of the REST API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the REST API.
         * </p>
         * 
         * @param description
         *        A description of the REST API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates when the API was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdDate
         *        Indicates when the API was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * The version identifier for the REST API.
         * </p>
         * 
         * @param version
         *        The version identifier for the REST API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The list of binary media types supported by the REST API.
         * </p>
         * 
         * @param binaryMediaTypes
         *        The list of binary media types supported by the REST API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryMediaTypes(Collection<String> binaryMediaTypes);

        /**
         * <p>
         * The list of binary media types supported by the REST API.
         * </p>
         * 
         * @param binaryMediaTypes
         *        The list of binary media types supported by the REST API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryMediaTypes(String... binaryMediaTypes);

        /**
         * <p>
         * The minimum size in bytes of a payload before compression is enabled.
         * </p>
         * <p>
         * If <code>null</code>, then compression is disabled.
         * </p>
         * <p>
         * If 0, then all payloads are compressed.
         * </p>
         * 
         * @param minimumCompressionSize
         *        The minimum size in bytes of a payload before compression is enabled.</p>
         *        <p>
         *        If <code>null</code>, then compression is disabled.
         *        </p>
         *        <p>
         *        If 0, then all payloads are compressed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumCompressionSize(Integer minimumCompressionSize);

        /**
         * <p>
         * The source of the API key for metering requests according to a usage plan.
         * </p>
         * <p>
         * <code>HEADER</code> indicates whether to read the API key from the X-API-Key header of a request.
         * </p>
         * <p>
         * <code>AUTHORIZER</code> indicates whether to read the API key from the <code>UsageIdentifierKey</code> from a
         * custom authorizer.
         * </p>
         * 
         * @param apiKeySource
         *        The source of the API key for metering requests according to a usage plan.</p>
         *        <p>
         *        <code>HEADER</code> indicates whether to read the API key from the X-API-Key header of a request.
         *        </p>
         *        <p>
         *        <code>AUTHORIZER</code> indicates whether to read the API key from the <code>UsageIdentifierKey</code>
         *        from a custom authorizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeySource(String apiKeySource);

        /**
         * <p>
         * The endpoint configuration of the REST API.
         * </p>
         * 
         * @param endpointConfiguration
         *        The endpoint configuration of the REST API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(AwsApiGatewayEndpointConfiguration endpointConfiguration);

        /**
         * <p>
         * The endpoint configuration of the REST API.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsApiGatewayEndpointConfiguration.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayEndpointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsApiGatewayEndpointConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointConfiguration(AwsApiGatewayEndpointConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link AwsApiGatewayEndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(AwsApiGatewayEndpointConfiguration)
         */
        default Builder endpointConfiguration(Consumer<AwsApiGatewayEndpointConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(AwsApiGatewayEndpointConfiguration.builder().applyMutation(endpointConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String createdDate;

        private String version;

        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer minimumCompressionSize;

        private String apiKeySource;

        private AwsApiGatewayEndpointConfiguration endpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayRestApiDetails model) {
            id(model.id);
            name(model.name);
            description(model.description);
            createdDate(model.createdDate);
            version(model.version);
            binaryMediaTypes(model.binaryMediaTypes);
            minimumCompressionSize(model.minimumCompressionSize);
            apiKeySource(model.apiKeySource);
            endpointConfiguration(model.endpointConfiguration);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getBinaryMediaTypes() {
            if (binaryMediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return binaryMediaTypes;
        }

        @Override
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = NonEmptyStringListCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryMediaTypes(String... binaryMediaTypes) {
            binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = NonEmptyStringListCopier.copy(binaryMediaTypes);
        }

        public final Integer getMinimumCompressionSize() {
            return minimumCompressionSize;
        }

        @Override
        public final Builder minimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public final void setMinimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
        }

        public final String getApiKeySource() {
            return apiKeySource;
        }

        @Override
        public final Builder apiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
            return this;
        }

        public final void setApiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
        }

        public final AwsApiGatewayEndpointConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(AwsApiGatewayEndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(AwsApiGatewayEndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public AwsApiGatewayRestApiDetails build() {
            return new AwsApiGatewayRestApiDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
