/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains route settings for a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsApiGatewayV2RouteSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsApiGatewayV2RouteSettings.Builder, AwsApiGatewayV2RouteSettings> {
    private static final SdkField<Boolean> DETAILED_METRICS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DetailedMetricsEnabled").getter(getter(AwsApiGatewayV2RouteSettings::detailedMetricsEnabled))
            .setter(setter(Builder::detailedMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedMetricsEnabled").build())
            .build();

    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingLevel").getter(getter(AwsApiGatewayV2RouteSettings::loggingLevel))
            .setter(setter(Builder::loggingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()).build();

    private static final SdkField<Boolean> DATA_TRACE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataTraceEnabled").getter(getter(AwsApiGatewayV2RouteSettings::dataTraceEnabled))
            .setter(setter(Builder::dataTraceEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTraceEnabled").build()).build();

    private static final SdkField<Integer> THROTTLING_BURST_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThrottlingBurstLimit").getter(getter(AwsApiGatewayV2RouteSettings::throttlingBurstLimit))
            .setter(setter(Builder::throttlingBurstLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrottlingBurstLimit").build())
            .build();

    private static final SdkField<Double> THROTTLING_RATE_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThrottlingRateLimit").getter(getter(AwsApiGatewayV2RouteSettings::throttlingRateLimit))
            .setter(setter(Builder::throttlingRateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrottlingRateLimit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DETAILED_METRICS_ENABLED_FIELD, LOGGING_LEVEL_FIELD, DATA_TRACE_ENABLED_FIELD, THROTTLING_BURST_LIMIT_FIELD,
            THROTTLING_RATE_LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean detailedMetricsEnabled;

    private final String loggingLevel;

    private final Boolean dataTraceEnabled;

    private final Integer throttlingBurstLimit;

    private final Double throttlingRateLimit;

    private AwsApiGatewayV2RouteSettings(BuilderImpl builder) {
        this.detailedMetricsEnabled = builder.detailedMetricsEnabled;
        this.loggingLevel = builder.loggingLevel;
        this.dataTraceEnabled = builder.dataTraceEnabled;
        this.throttlingBurstLimit = builder.throttlingBurstLimit;
        this.throttlingRateLimit = builder.throttlingRateLimit;
    }

    /**
     * <p>
     * Indicates whether detailed metrics are enabled.
     * </p>
     * 
     * @return Indicates whether detailed metrics are enabled.
     */
    public final Boolean detailedMetricsEnabled() {
        return detailedMetricsEnabled;
    }

    /**
     * <p>
     * The logging level. The logging level affects the log entries that are pushed to CloudWatch Logs. Supported only
     * for WebSocket APIs.
     * </p>
     * <p>
     * If the logging level is <code>ERROR</code>, then the logs only include error-level entries.
     * </p>
     * <p>
     * If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and extra
     * informational events.
     * </p>
     * <p>
     * Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code>
     * </p>
     * 
     * @return The logging level. The logging level affects the log entries that are pushed to CloudWatch Logs.
     *         Supported only for WebSocket APIs.</p>
     *         <p>
     *         If the logging level is <code>ERROR</code>, then the logs only include error-level entries.
     *         </p>
     *         <p>
     *         If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and extra
     *         informational events.
     *         </p>
     *         <p>
     *         Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code>
     */
    public final String loggingLevel() {
        return loggingLevel;
    }

    /**
     * <p>
     * Indicates whether data trace logging is enabled. Data trace logging affects the log entries that are pushed to
     * CloudWatch Logs. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return Indicates whether data trace logging is enabled. Data trace logging affects the log entries that are
     *         pushed to CloudWatch Logs. Supported only for WebSocket APIs.
     */
    public final Boolean dataTraceEnabled() {
        return dataTraceEnabled;
    }

    /**
     * <p>
     * The throttling burst limit.
     * </p>
     * 
     * @return The throttling burst limit.
     */
    public final Integer throttlingBurstLimit() {
        return throttlingBurstLimit;
    }

    /**
     * <p>
     * The throttling rate limit.
     * </p>
     * 
     * @return The throttling rate limit.
     */
    public final Double throttlingRateLimit() {
        return throttlingRateLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailedMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(dataTraceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(throttlingBurstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(throttlingRateLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayV2RouteSettings)) {
            return false;
        }
        AwsApiGatewayV2RouteSettings other = (AwsApiGatewayV2RouteSettings) obj;
        return Objects.equals(detailedMetricsEnabled(), other.detailedMetricsEnabled())
                && Objects.equals(loggingLevel(), other.loggingLevel())
                && Objects.equals(dataTraceEnabled(), other.dataTraceEnabled())
                && Objects.equals(throttlingBurstLimit(), other.throttlingBurstLimit())
                && Objects.equals(throttlingRateLimit(), other.throttlingRateLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsApiGatewayV2RouteSettings").add("DetailedMetricsEnabled", detailedMetricsEnabled())
                .add("LoggingLevel", loggingLevel()).add("DataTraceEnabled", dataTraceEnabled())
                .add("ThrottlingBurstLimit", throttlingBurstLimit()).add("ThrottlingRateLimit", throttlingRateLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetailedMetricsEnabled":
            return Optional.ofNullable(clazz.cast(detailedMetricsEnabled()));
        case "LoggingLevel":
            return Optional.ofNullable(clazz.cast(loggingLevel()));
        case "DataTraceEnabled":
            return Optional.ofNullable(clazz.cast(dataTraceEnabled()));
        case "ThrottlingBurstLimit":
            return Optional.ofNullable(clazz.cast(throttlingBurstLimit()));
        case "ThrottlingRateLimit":
            return Optional.ofNullable(clazz.cast(throttlingRateLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayV2RouteSettings, T> g) {
        return obj -> g.apply((AwsApiGatewayV2RouteSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsApiGatewayV2RouteSettings> {
        /**
         * <p>
         * Indicates whether detailed metrics are enabled.
         * </p>
         * 
         * @param detailedMetricsEnabled
         *        Indicates whether detailed metrics are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedMetricsEnabled(Boolean detailedMetricsEnabled);

        /**
         * <p>
         * The logging level. The logging level affects the log entries that are pushed to CloudWatch Logs. Supported
         * only for WebSocket APIs.
         * </p>
         * <p>
         * If the logging level is <code>ERROR</code>, then the logs only include error-level entries.
         * </p>
         * <p>
         * If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and extra
         * informational events.
         * </p>
         * <p>
         * Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code>
         * </p>
         * 
         * @param loggingLevel
         *        The logging level. The logging level affects the log entries that are pushed to CloudWatch Logs.
         *        Supported only for WebSocket APIs.</p>
         *        <p>
         *        If the logging level is <code>ERROR</code>, then the logs only include error-level entries.
         *        </p>
         *        <p>
         *        If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and
         *        extra informational events.
         *        </p>
         *        <p>
         *        Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingLevel(String loggingLevel);

        /**
         * <p>
         * Indicates whether data trace logging is enabled. Data trace logging affects the log entries that are pushed
         * to CloudWatch Logs. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param dataTraceEnabled
         *        Indicates whether data trace logging is enabled. Data trace logging affects the log entries that are
         *        pushed to CloudWatch Logs. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTraceEnabled(Boolean dataTraceEnabled);

        /**
         * <p>
         * The throttling burst limit.
         * </p>
         * 
         * @param throttlingBurstLimit
         *        The throttling burst limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingBurstLimit(Integer throttlingBurstLimit);

        /**
         * <p>
         * The throttling rate limit.
         * </p>
         * 
         * @param throttlingRateLimit
         *        The throttling rate limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingRateLimit(Double throttlingRateLimit);
    }

    static final class BuilderImpl implements Builder {
        private Boolean detailedMetricsEnabled;

        private String loggingLevel;

        private Boolean dataTraceEnabled;

        private Integer throttlingBurstLimit;

        private Double throttlingRateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayV2RouteSettings model) {
            detailedMetricsEnabled(model.detailedMetricsEnabled);
            loggingLevel(model.loggingLevel);
            dataTraceEnabled(model.dataTraceEnabled);
            throttlingBurstLimit(model.throttlingBurstLimit);
            throttlingRateLimit(model.throttlingRateLimit);
        }

        public final Boolean getDetailedMetricsEnabled() {
            return detailedMetricsEnabled;
        }

        @Override
        public final Builder detailedMetricsEnabled(Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
            return this;
        }

        public final void setDetailedMetricsEnabled(Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
        }

        public final String getLoggingLevel() {
            return loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        public final Boolean getDataTraceEnabled() {
            return dataTraceEnabled;
        }

        @Override
        public final Builder dataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        public final void setDataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
        }

        public final Integer getThrottlingBurstLimit() {
            return throttlingBurstLimit;
        }

        @Override
        public final Builder throttlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        public final void setThrottlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
        }

        public final Double getThrottlingRateLimit() {
            return throttlingRateLimit;
        }

        @Override
        public final Builder throttlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        public final void setThrottlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
        }

        @Override
        public AwsApiGatewayV2RouteSettings build() {
            return new AwsApiGatewayV2RouteSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
