/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a CloudTrail trail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudTrailTrailDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudTrailTrailDetails.Builder, AwsCloudTrailTrailDetails> {
    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("CloudWatchLogsLogGroupArn")
            .getter(getter(AwsCloudTrailTrailDetails::cloudWatchLogsLogGroupArn))
            .setter(setter(Builder::cloudWatchLogsLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogsRoleArn").getter(getter(AwsCloudTrailTrailDetails::cloudWatchLogsRoleArn))
            .setter(setter(Builder::cloudWatchLogsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsRoleArn").build())
            .build();

    private static final SdkField<Boolean> HAS_CUSTOM_EVENT_SELECTORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasCustomEventSelectors").getter(getter(AwsCloudTrailTrailDetails::hasCustomEventSelectors))
            .setter(setter(Builder::hasCustomEventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasCustomEventSelectors").build())
            .build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(AwsCloudTrailTrailDetails::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<Boolean> INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeGlobalServiceEvents")
            .getter(getter(AwsCloudTrailTrailDetails::includeGlobalServiceEvents))
            .setter(setter(Builder::includeGlobalServiceEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGlobalServiceEvents").build())
            .build();

    private static final SdkField<Boolean> IS_MULTI_REGION_TRAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsMultiRegionTrail").getter(getter(AwsCloudTrailTrailDetails::isMultiRegionTrail))
            .setter(setter(Builder::isMultiRegionTrail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMultiRegionTrail").build())
            .build();

    private static final SdkField<Boolean> IS_ORGANIZATION_TRAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsOrganizationTrail").getter(getter(AwsCloudTrailTrailDetails::isOrganizationTrail))
            .setter(setter(Builder::isOrganizationTrail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOrganizationTrail").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsCloudTrailTrailDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> LOG_FILE_VALIDATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("LogFileValidationEnabled")
            .getter(getter(AwsCloudTrailTrailDetails::logFileValidationEnabled))
            .setter(setter(Builder::logFileValidationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileValidationEnabled").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsCloudTrailTrailDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(AwsCloudTrailTrailDetails::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix").getter(getter(AwsCloudTrailTrailDetails::s3KeyPrefix))
            .setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(AwsCloudTrailTrailDetails::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SNS_TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicName").getter(getter(AwsCloudTrailTrailDetails::snsTopicName))
            .setter(setter(Builder::snsTopicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicName").build()).build();

    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailArn").getter(getter(AwsCloudTrailTrailDetails::trailArn)).setter(setter(Builder::trailArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD, CLOUD_WATCH_LOGS_ROLE_ARN_FIELD, HAS_CUSTOM_EVENT_SELECTORS_FIELD,
            HOME_REGION_FIELD, INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD, IS_MULTI_REGION_TRAIL_FIELD, IS_ORGANIZATION_TRAIL_FIELD,
            KMS_KEY_ID_FIELD, LOG_FILE_VALIDATION_ENABLED_FIELD, NAME_FIELD, S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD,
            SNS_TOPIC_ARN_FIELD, SNS_TOPIC_NAME_FIELD, TRAIL_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogsLogGroupArn;

    private final String cloudWatchLogsRoleArn;

    private final Boolean hasCustomEventSelectors;

    private final String homeRegion;

    private final Boolean includeGlobalServiceEvents;

    private final Boolean isMultiRegionTrail;

    private final Boolean isOrganizationTrail;

    private final String kmsKeyId;

    private final Boolean logFileValidationEnabled;

    private final String name;

    private final String s3BucketName;

    private final String s3KeyPrefix;

    private final String snsTopicArn;

    private final String snsTopicName;

    private final String trailArn;

    private AwsCloudTrailTrailDetails(BuilderImpl builder) {
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.hasCustomEventSelectors = builder.hasCustomEventSelectors;
        this.homeRegion = builder.homeRegion;
        this.includeGlobalServiceEvents = builder.includeGlobalServiceEvents;
        this.isMultiRegionTrail = builder.isMultiRegionTrail;
        this.isOrganizationTrail = builder.isOrganizationTrail;
        this.kmsKeyId = builder.kmsKeyId;
        this.logFileValidationEnabled = builder.logFileValidationEnabled;
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsTopicName = builder.snsTopicName;
        this.trailArn = builder.trailArn;
    }

    /**
     * <p>
     * The ARN of the log group that CloudTrail logs are delivered to.
     * </p>
     * 
     * @return The ARN of the log group that CloudTrail logs are delivered to.
     */
    public final String cloudWatchLogsLogGroupArn() {
        return cloudWatchLogsLogGroupArn;
    }

    /**
     * <p>
     * The ARN of the role that the CloudWatch Logs endpoint assumes when it writes to the log group.
     * </p>
     * 
     * @return The ARN of the role that the CloudWatch Logs endpoint assumes when it writes to the log group.
     */
    public final String cloudWatchLogsRoleArn() {
        return cloudWatchLogsRoleArn;
    }

    /**
     * <p>
     * Indicates whether the trail has custom event selectors.
     * </p>
     * 
     * @return Indicates whether the trail has custom event selectors.
     */
    public final Boolean hasCustomEventSelectors() {
        return hasCustomEventSelectors;
    }

    /**
     * <p>
     * The Region where the trail was created.
     * </p>
     * 
     * @return The Region where the trail was created.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * Indicates whether the trail publishes events from global services such as IAM to the log files.
     * </p>
     * 
     * @return Indicates whether the trail publishes events from global services such as IAM to the log files.
     */
    public final Boolean includeGlobalServiceEvents() {
        return includeGlobalServiceEvents;
    }

    /**
     * <p>
     * Indicates whether the trail applies only to the current Region or to all Regions.
     * </p>
     * 
     * @return Indicates whether the trail applies only to the current Region or to all Regions.
     */
    public final Boolean isMultiRegionTrail() {
        return isMultiRegionTrail;
    }

    /**
     * <p>
     * Whether the trail is created for all accounts in an organization in AWS Organizations, or only for the current
     * AWS account.
     * </p>
     * 
     * @return Whether the trail is created for all accounts in an organization in AWS Organizations, or only for the
     *         current AWS account.
     */
    public final Boolean isOrganizationTrail() {
        return isOrganizationTrail;
    }

    /**
     * <p>
     * The AWS KMS key ID to use to encrypt the logs.
     * </p>
     * 
     * @return The AWS KMS key ID to use to encrypt the logs.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Indicates whether CloudTrail log file validation is enabled.
     * </p>
     * 
     * @return Indicates whether CloudTrail log file validation is enabled.
     */
    public final Boolean logFileValidationEnabled() {
        return logFileValidationEnabled;
    }

    /**
     * <p>
     * The name of the trail.
     * </p>
     * 
     * @return The name of the trail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the S3 bucket where the log files are published.
     * </p>
     * 
     * @return The name of the S3 bucket where the log files are published.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The S3 key prefix. The key prefix is added after the name of the S3 bucket where the log files are published.
     * </p>
     * 
     * @return The S3 key prefix. The key prefix is added after the name of the S3 bucket where the log files are
     *         published.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * The ARN of the SNS topic that is used for notifications of log file delivery.
     * </p>
     * 
     * @return The ARN of the SNS topic that is used for notifications of log file delivery.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The name of the SNS topic that is used for notifications of log file delivery.
     * </p>
     * 
     * @return The name of the SNS topic that is used for notifications of log file delivery.
     */
    public final String snsTopicName() {
        return snsTopicName;
    }

    /**
     * <p>
     * The ARN of the trail.
     * </p>
     * 
     * @return The ARN of the trail.
     */
    public final String trailArn() {
        return trailArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomEventSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(includeGlobalServiceEvents());
        hashCode = 31 * hashCode + Objects.hashCode(isMultiRegionTrail());
        hashCode = 31 * hashCode + Objects.hashCode(isOrganizationTrail());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(logFileValidationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicName());
        hashCode = 31 * hashCode + Objects.hashCode(trailArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudTrailTrailDetails)) {
            return false;
        }
        AwsCloudTrailTrailDetails other = (AwsCloudTrailTrailDetails) obj;
        return Objects.equals(cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn())
                && Objects.equals(cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn())
                && Objects.equals(hasCustomEventSelectors(), other.hasCustomEventSelectors())
                && Objects.equals(homeRegion(), other.homeRegion())
                && Objects.equals(includeGlobalServiceEvents(), other.includeGlobalServiceEvents())
                && Objects.equals(isMultiRegionTrail(), other.isMultiRegionTrail())
                && Objects.equals(isOrganizationTrail(), other.isOrganizationTrail())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(logFileValidationEnabled(), other.logFileValidationEnabled())
                && Objects.equals(name(), other.name()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(snsTopicName(), other.snsTopicName()) && Objects.equals(trailArn(), other.trailArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudTrailTrailDetails").add("CloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn())
                .add("CloudWatchLogsRoleArn", cloudWatchLogsRoleArn()).add("HasCustomEventSelectors", hasCustomEventSelectors())
                .add("HomeRegion", homeRegion()).add("IncludeGlobalServiceEvents", includeGlobalServiceEvents())
                .add("IsMultiRegionTrail", isMultiRegionTrail()).add("IsOrganizationTrail", isOrganizationTrail())
                .add("KmsKeyId", kmsKeyId()).add("LogFileValidationEnabled", logFileValidationEnabled()).add("Name", name())
                .add("S3BucketName", s3BucketName()).add("S3KeyPrefix", s3KeyPrefix()).add("SnsTopicArn", snsTopicArn())
                .add("SnsTopicName", snsTopicName()).add("TrailArn", trailArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogsLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroupArn()));
        case "CloudWatchLogsRoleArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsRoleArn()));
        case "HasCustomEventSelectors":
            return Optional.ofNullable(clazz.cast(hasCustomEventSelectors()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "IncludeGlobalServiceEvents":
            return Optional.ofNullable(clazz.cast(includeGlobalServiceEvents()));
        case "IsMultiRegionTrail":
            return Optional.ofNullable(clazz.cast(isMultiRegionTrail()));
        case "IsOrganizationTrail":
            return Optional.ofNullable(clazz.cast(isOrganizationTrail()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "LogFileValidationEnabled":
            return Optional.ofNullable(clazz.cast(logFileValidationEnabled()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SnsTopicName":
            return Optional.ofNullable(clazz.cast(snsTopicName()));
        case "TrailArn":
            return Optional.ofNullable(clazz.cast(trailArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudTrailTrailDetails, T> g) {
        return obj -> g.apply((AwsCloudTrailTrailDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudTrailTrailDetails> {
        /**
         * <p>
         * The ARN of the log group that CloudTrail logs are delivered to.
         * </p>
         * 
         * @param cloudWatchLogsLogGroupArn
         *        The ARN of the log group that CloudTrail logs are delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn);

        /**
         * <p>
         * The ARN of the role that the CloudWatch Logs endpoint assumes when it writes to the log group.
         * </p>
         * 
         * @param cloudWatchLogsRoleArn
         *        The ARN of the role that the CloudWatch Logs endpoint assumes when it writes to the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn);

        /**
         * <p>
         * Indicates whether the trail has custom event selectors.
         * </p>
         * 
         * @param hasCustomEventSelectors
         *        Indicates whether the trail has custom event selectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasCustomEventSelectors(Boolean hasCustomEventSelectors);

        /**
         * <p>
         * The Region where the trail was created.
         * </p>
         * 
         * @param homeRegion
         *        The Region where the trail was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * Indicates whether the trail publishes events from global services such as IAM to the log files.
         * </p>
         * 
         * @param includeGlobalServiceEvents
         *        Indicates whether the trail publishes events from global services such as IAM to the log files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents);

        /**
         * <p>
         * Indicates whether the trail applies only to the current Region or to all Regions.
         * </p>
         * 
         * @param isMultiRegionTrail
         *        Indicates whether the trail applies only to the current Region or to all Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMultiRegionTrail(Boolean isMultiRegionTrail);

        /**
         * <p>
         * Whether the trail is created for all accounts in an organization in AWS Organizations, or only for the
         * current AWS account.
         * </p>
         * 
         * @param isOrganizationTrail
         *        Whether the trail is created for all accounts in an organization in AWS Organizations, or only for the
         *        current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOrganizationTrail(Boolean isOrganizationTrail);

        /**
         * <p>
         * The AWS KMS key ID to use to encrypt the logs.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS key ID to use to encrypt the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Indicates whether CloudTrail log file validation is enabled.
         * </p>
         * 
         * @param logFileValidationEnabled
         *        Indicates whether CloudTrail log file validation is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFileValidationEnabled(Boolean logFileValidationEnabled);

        /**
         * <p>
         * The name of the trail.
         * </p>
         * 
         * @param name
         *        The name of the trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the S3 bucket where the log files are published.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket where the log files are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The S3 key prefix. The key prefix is added after the name of the S3 bucket where the log files are published.
         * </p>
         * 
         * @param s3KeyPrefix
         *        The S3 key prefix. The key prefix is added after the name of the S3 bucket where the log files are
         *        published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * The ARN of the SNS topic that is used for notifications of log file delivery.
         * </p>
         * 
         * @param snsTopicArn
         *        The ARN of the SNS topic that is used for notifications of log file delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The name of the SNS topic that is used for notifications of log file delivery.
         * </p>
         * 
         * @param snsTopicName
         *        The name of the SNS topic that is used for notifications of log file delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicName(String snsTopicName);

        /**
         * <p>
         * The ARN of the trail.
         * </p>
         * 
         * @param trailArn
         *        The ARN of the trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailArn(String trailArn);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogsLogGroupArn;

        private String cloudWatchLogsRoleArn;

        private Boolean hasCustomEventSelectors;

        private String homeRegion;

        private Boolean includeGlobalServiceEvents;

        private Boolean isMultiRegionTrail;

        private Boolean isOrganizationTrail;

        private String kmsKeyId;

        private Boolean logFileValidationEnabled;

        private String name;

        private String s3BucketName;

        private String s3KeyPrefix;

        private String snsTopicArn;

        private String snsTopicName;

        private String trailArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudTrailTrailDetails model) {
            cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
            cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            hasCustomEventSelectors(model.hasCustomEventSelectors);
            homeRegion(model.homeRegion);
            includeGlobalServiceEvents(model.includeGlobalServiceEvents);
            isMultiRegionTrail(model.isMultiRegionTrail);
            isOrganizationTrail(model.isOrganizationTrail);
            kmsKeyId(model.kmsKeyId);
            logFileValidationEnabled(model.logFileValidationEnabled);
            name(model.name);
            s3BucketName(model.s3BucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            snsTopicArn(model.snsTopicArn);
            snsTopicName(model.snsTopicName);
            trailArn(model.trailArn);
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        public final String getCloudWatchLogsRoleArn() {
            return cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        public final Boolean getHasCustomEventSelectors() {
            return hasCustomEventSelectors;
        }

        @Override
        public final Builder hasCustomEventSelectors(Boolean hasCustomEventSelectors) {
            this.hasCustomEventSelectors = hasCustomEventSelectors;
            return this;
        }

        public final void setHasCustomEventSelectors(Boolean hasCustomEventSelectors) {
            this.hasCustomEventSelectors = hasCustomEventSelectors;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        public final Boolean getIncludeGlobalServiceEvents() {
            return includeGlobalServiceEvents;
        }

        @Override
        public final Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        public final void setIncludeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
        }

        public final Boolean getIsMultiRegionTrail() {
            return isMultiRegionTrail;
        }

        @Override
        public final Builder isMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        public final void setIsMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
        }

        public final Boolean getIsOrganizationTrail() {
            return isOrganizationTrail;
        }

        @Override
        public final Builder isOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        public final void setIsOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getLogFileValidationEnabled() {
            return logFileValidationEnabled;
        }

        @Override
        public final Builder logFileValidationEnabled(Boolean logFileValidationEnabled) {
            this.logFileValidationEnabled = logFileValidationEnabled;
            return this;
        }

        public final void setLogFileValidationEnabled(Boolean logFileValidationEnabled) {
            this.logFileValidationEnabled = logFileValidationEnabled;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSnsTopicName() {
            return snsTopicName;
        }

        @Override
        public final Builder snsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
            return this;
        }

        public final void setSnsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
        }

        public final String getTrailArn() {
            return trailArn;
        }

        @Override
        public final Builder trailArn(String trailArn) {
            this.trailArn = trailArn;
            return this;
        }

        public final void setTrailArn(String trailArn) {
            this.trailArn = trailArn;
        }

        @Override
        public AwsCloudTrailTrailDetails build() {
            return new AwsCloudTrailTrailDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
